package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;




import javax.persistence.*;
import java.util.Date;



/**
 * <p>
 * 下载日志
 * Generated 2011-12-15 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_downloadlog")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class DownloadLog {

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 用户id
     */
    @Column(length = 100)
    private String userId;

    /**
     * 用户名
     */
    @Column(length = 100)
    private String userName;

    /**
     * 下载时间
     */
    private Date downloadTime;

    /**
     * 原文id
     */
    @Column(length = 100, nullable = false)
    private String originalId;

    /**
     * 案卷id
     */
    @Column(length = 1000)
    private String arcId;

    /**
     * 操作类型
     */
    @Column(length = 100)
    private String action;
    
    @Column(length = 100,name = "dl_count")
    private int count;

    @Transient
    private String ownerId;

    @Transient
    private String name;

    @Transient
    private String ownerModelName;

    @ManyToOne
    @JoinColumn(name = "originalId", insertable = false, updatable = false)
    private Original original;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Date getDownloadTime() {
        return downloadTime;
    }

    public void setDownloadTime(Date downloadTime) {
        this.downloadTime = downloadTime;
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getArcId() {
        return arcId;
    }

    public void setArcId(String arcId) {
        this.arcId = arcId;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Original getOriginal() {
        return original;
    }

    public void setOriginal(Original original) {
        this.original = original;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwnerModelName() {
        return ownerModelName;
    }

    public void setOwnerModelName(String ownerModelName) {
        this.ownerModelName = ownerModelName;
    }
}
