package com.gtis.archive.entity;

import com.google.common.base.MoreObjects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * 配置的键值对
 *
 * @author linlong
 */
@Entity
@Table(name = "t_config_prop")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ConfigProp {

    public static final String MODEL_NAME = ConfigProp.class.getSimpleName();

    /** 打开时的值为true */
    public static final String ON_VALUE = "true";

    /** 关闭时的值为false */
    public static final String OFF_VALUE = "false";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 键，同时也作为id
     */
    @Column
    private String key;

    /**
     * 值
     */
    @Column
    private String value;

    public ConfigProp() { }

    public ConfigProp(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("key", key)
                .add("value", value)
                .toString();
    }
}
