package com.gtis.archive.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * 卷内
 * <p/>
 * Generated 2010-08-13 13:16:33 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_chapter")
@Inheritance(strategy = InheritanceType.JOINED)
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Chapter {
    public static final String MODEL_NAME = Chapter.class.getSimpleName();
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    private String modelName = getClass().getSimpleName();

    /**
     * 题名
     */
    @Column(length = 100)
    private String tm;

    /**
     * 全宗号
     */
    @Column(length = 100, nullable = true)
    private String qzh;

    /**
     * 目录号
     */
    @Column(length = 100)
    private String mlh;

    /**
     * 案卷号
     */
    @Column
    private Integer ajh;

    /**
     * 顺序号
     */
    @Column
    private Integer sxh;

    /**
     * 案卷号
     */
    @Column
    private Integer ys;

    /**
     * 页号
     */
    @Column(length = 100)
    private String yh;

    /**
     * 文号
     */
    @Column(length = 100)
    private String wh;

    /**
     * 责任者
     */
    @Column(length = 100)
    private String zrz;

    /**
     * 日期
     */
    private Date rq;

    /**
     * 备注
     */
    @Column(length = 100)
    private String bz;

    /**
     * 档案序号
     */
    @Column(length = 32)
    private String documentId;

    /**
     * 卷内编号
     */
    @Column(length = 100)
    private String jnbh;

    /**
     * 编号
     */
    @Column(length = 100)
    private String bh;

    /**
     * 单位代码
     */
    @Column(length = 100)
    private String dwdm;

    /**
     * 自动编研记录原档案id
     */
    @Column(length = 100)
    private String oldId;


    @Transient
    private Boolean hasOriginal;

    @Transient
    private Document document;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        if (StringUtils.isNotEmpty(modelName)) {
            this.modelName = modelName;
        }
    }

    public String getTm() {
        return tm;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    public Integer getSxh() {
        return sxh;
    }

    public void setSxh(Integer sxh) {
        this.sxh = sxh;
    }

    public String getYh() {
        return yh;
    }

    public void setYh(String yh) {
        this.yh = yh;
    }

    public Integer getYs() {
        return ys;
    }

    public void setYs(Integer ys) {
        this.ys = ys;
    }

    public String getWh() {
        return wh;
    }

    public void setWh(String wh) {
        this.wh = wh;
    }

    public String getZrz() {
        return zrz;
    }

    public void setZrz(String zrz) {
        this.zrz = zrz;
    }

    @JSONField(format = "yyyy-MM-dd")
    public Date getRq() {
        return rq;
    }

    public void setRq(Date rq) {
        this.rq = rq;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getDocumentId() {
        return documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = StringUtils.isBlank(documentId) ? null : documentId;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public Document getDocument() {
        return document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Boolean getHasOriginal() {
        return hasOriginal;
    }

    public void setHasOriginal(Boolean hasOriginal) {
        this.hasOriginal = hasOriginal;
    }

    public static boolean isDocumentModelName(String modelName) {
        return modelName.endsWith(Archive.DOCUMENT_SUFFIX) || MODEL_NAME.equals(modelName);
    }

    public static String toArchiveModelName(String docModelName) {
        int index = docModelName.indexOf(Archive.DOCUMENT_SUFFIX);
        if (index > 0) {
            return docModelName.substring(0, index);
        } else if (Chapter.MODEL_NAME.equals(docModelName)) {
            return Archive.MODEL_NAME;
        } else {
            return docModelName;
        }
    }

    public String getQzh() {
        return qzh;
    }

    public void setQzh(String qzh) {
        this.qzh = qzh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public Integer getAjh() {
        return ajh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public String getJnbh() {
        return jnbh;
    }

    public void setJnbh(String jnbh) {
        this.jnbh = jnbh;
    }

    public String getBh() {
        return bh;
    }

    public void setBh(String bh) {
        this.bh = bh;
    }

    public String getOldId() {
        return oldId;
    }

    public void setOldId(String oldId) {
        this.oldId = oldId;
    }
}
