package com.gtis.archive.entity;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.util.Date;

/**
 * 档案元数据
 * <p/>
 * Generated 2019-03-18
 * <p/>
 *
 * @author linlong
 */
@Entity
@Table(name = "t_archive_metadata")
@Inheritance(strategy = InheritanceType.JOINED)
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@XStreamAlias(value = "ArchiveMetaData")
public class ArchiveMetaData {

    @Id
    @Column(length = 32)
    private String id;

    /**
     * 聚合层次
     */
    @Column
    private String aggregationLevel;

    /**
     * 来源
     */
    @Column
    private String provenance;

    /**
     * 档案馆名称
     */
    @Column
    private String archivesName;

    /**
     * 档案馆代码
     * 注意：与archiveId有区别
     */
    @Column
    private String archiveIdentifier;

    /**
     * 全宗名称
     */
    @Column
    private String fondsName;

    /**
     * 立档单位名称
     */
    @Column
    private String fondsConsUnitName;

    /**
     * 电子文件号
     */
    @Column
    private String elcRecordCode;

    /**
     * 档号
     */
    @Column
    private String archiveCode;

    /**
     * 全宗号
     */
    @Column
    private String fondsId;

    /**
     * 年度
     */
    @Column
    private String year;

    /**
     * 保管期限
     */
    @Column
    private String retentionPeriod;

    /**
     * 保管期限
     */
    @Column
    private String bgqx;

    /**
     * 机构或问题
     */
    @Column
    private String jghwt;

    /**
     * 类别号
     */
    @Column
    private String categoryCode;

    /**
     * 室编案卷号
     */
    @Column
    private String agencyFileNumber;

    /**
     * 馆编案卷号
     */
    @Column
    private String archiveFileNumber;

    /**
     * 室编件号
     */
    @Column
    private String agencyItemNumber;

    /**
     * 文档序号
     */
    @Column
    private String docSeqNumber;

    /**
     * 页号
     */
    @Column
    private String pageNumber;

    /**
     * 内容描述
     */
    @Column
    private String contentDescription;

    /**
     * 副标题
     */
    @Column
    private String alternativeTitle;

    /**
     * 说明题名文字
     */
    @Column
    private String otherTitleInfo;

    /**
     * 主题词
     */
    @Column
    private String descriptor;

    /**
     * 关键词
     */
    @Column
    private String keyword;

    /**
     * 人名
     */
    @Column
    private String personalName;

    /**
     * 摘要
     */
    @Column
    private String abstractContent;

    /**
     * 分类号
     */
    @Column
    private String classCode;

    /**
     * 文件编号
     */
    @Column
    private String docNumber;

    /**
     * 责任者
     */
    @Column
    private String author;

    /**
     * 日期
     */
    // 数据库中date是关键字
    @Column(name = "column_date")
    private Date rq;

    /**
     * 文种
     */
    @Column
    private String docType;

    /**
     * 主送
     */
    @Column
    private String principleReceiver;

    /**
     * 抄送
     */
    @Column
    private String otherReceivers;

    /**
     * 密级
     */
    @Column
    private String secClassification;

    /**
     * 保密期限
     */
    @Column
    private String secrecyPeriod;

    /**
     * 形式特征
     */
    @Column
    private String formalCharacter;

    /**
     * 文件组合类型
     */
    @Column
    private String docAggrType;

    /**
     * 件数
     */
    @Column
    private Integer totalNumberOfItems;

    /**
     * 页数
     */
    @Column
    private Integer totalPages;

    /**
     * 语种
     */
    @Column
    private String language;

    /**
     * 稿本
     */
    @Column
    private String manuscriptType;

    /**
     * 电子属性
     */
    @Column
    private String electronicAttr;

    /**
     * 格式信息
     */
    @Column
    private String formatInfo;

    /**
     * 计算机文件名
     */
    @Column
    private String computerFileName;

    /**
     * 计算机文件大小
     */
    @Column
    private String computerFileSize;

    /**
     * 文档创建程序
     */
    @Column
    private String docCreatingApp;

    /**
     * 信息系统描述
     */
    @Column
    private String infoSystemDesc;

    /**
     * 数字化属性
     */
    @Column
    private String digitizationAttr;

    /**
     * 数字化对象形态
     */
    @Column
    private String phyRecordCharacter;

    /**
     * 扫描分辨率
     */
    @Column
    private String scanningResolution;

    /**
     * 扫描色彩格式
     */
    @Column
    private String scanningColorModel;

    /**
     * 图像压缩方案
     */
    @Column
    private String imageCompScheme;

    /**
     * 电子签名
     */
    @Column
    private String electronicSign;

    /**
     * 签名规则
     */
    @Column
    private String signatureRule;

    /**
     * 签名时间
     */
    @Column
    private Date signatureTime;

    /**
     * 签名人
     */
    @Column
    private String signer;

    /**
     * 签名结果
     */
    @Column
    private String signature;

    /**
     * 证书
     */
    @Column
    private String certificate;

    /**
     * 证书引证
     */
    @Column
    private String certReference;

    /**
     * 签名算法标识
     */
    @Column
    private String signatureAlgoId;

    /**
     * 存储位置
     */
    @Column
    private String storageLocation;

    /**
     * 当前位置
     */
    @Column
    private String currentLocation;

    /**
     * 脱机载体编号
     */
    @Column
    private String offlineMediumId;

    /**
     * 脱机载体存址
     */
    @Column
    private String offMedStorageLoc;

    /**
     * 缩微号
     */
    @Column
    private String microformId;

    /**
     * 权限管理
     */
    @Column
    private String rightsManagement;

    /**
     * 知识产权说明
     */
    @Column
    private String intellectualPropStat;

    /**
     * 授权对象
     */
    @Column
    private String authorizedAgent;

    /**
     * 授权行为
     */
    @Column
    private String permissionAssignment;

    /**
     * 控制标识
     */
    @Column
    private String controlId;

    /**
     * 附注
     */
    @Column
    private String annotation;

    /**
     * 机构人员类型
     */
    @Column
    private String agentType;

    /**
     * 机构人员名称
     */
    @Column
    private String agentName;

    /**
     * 组织机构代码
     */
    @Column
    private String organizationCode;

    /**
     * 个人职位
     */
    @Column
    private String positionName;

    /**
     * 业务状态
     */
    @Column
    private String businessStatus;

    /**
     * 关系
     */
    @Column
    private String relation;

    /**
     * 关系描述
     */
    // 减少单词长度
    @Column
    private String relationDesc;

    /**
     * 关系类型
     */
    @Column
    private String relationType;

    @Column
    private String archiveId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAggregationLevel() {
        return aggregationLevel;
    }

    public void setAggregationLevel(String aggregationLevel) {
        this.aggregationLevel = aggregationLevel;
    }

    public String getProvenance() {
        return provenance;
    }

    public void setProvenance(String provenance) {
        this.provenance = provenance;
    }

    public String getArchivesName() {
        return archivesName;
    }

    public void setArchivesName(String archivesName) {
        this.archivesName = archivesName;
    }

    public String getArchiveIdentifier() {
        return archiveIdentifier;
    }

    public void setArchiveIdentifier(String archiveIdentifier) {
        this.archiveIdentifier = archiveIdentifier;
    }

    public String getFondsName() {
        return fondsName;
    }

    public void setFondsName(String fondsName) {
        this.fondsName = fondsName;
    }

    public String getFondsConsUnitName() {
        return fondsConsUnitName;
    }

    public void setFondsConsUnitName(String fondsConsUnitName) {
        this.fondsConsUnitName = fondsConsUnitName;
    }

    public String getElcRecordCode() {
        return elcRecordCode;
    }

    public void setElcRecordCode(String elcRecordCode) {
        this.elcRecordCode = elcRecordCode;
    }

    public String getArchiveCode() {
        return archiveCode;
    }

    public void setArchiveCode(String archiveCode) {
        this.archiveCode = archiveCode;
    }

    public String getFondsId() {
        return fondsId;
    }

    public void setFondsId(String fondsId) {
        this.fondsId = fondsId;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getRetentionPeriod() {
        return retentionPeriod;
    }

    public void setRetentionPeriod(String retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public String getBgqx() {
        return bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }

    public String getJghwt() {
        return jghwt;
    }

    public void setJghwt(String jghwt) {
        this.jghwt = jghwt;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getAgencyFileNumber() {
        return agencyFileNumber;
    }

    public void setAgencyFileNumber(String agencyFileNumber) {
        this.agencyFileNumber = agencyFileNumber;
    }

    public String getArchiveFileNumber() {
        return archiveFileNumber;
    }

    public void setArchiveFileNumber(String archiveFileNumber) {
        this.archiveFileNumber = archiveFileNumber;
    }

    public String getAgencyItemNumber() {
        return agencyItemNumber;
    }

    public void setAgencyItemNumber(String agencyItemNumber) {
        this.agencyItemNumber = agencyItemNumber;
    }

    public String getDocSeqNumber() {
        return docSeqNumber;
    }

    public void setDocSeqNumber(String docSeqNumber) {
        this.docSeqNumber = docSeqNumber;
    }

    public String getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    public String getContentDescription() {
        return contentDescription;
    }

    public void setContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
    }

    public String getAlternativeTitle() {
        return alternativeTitle;
    }

    public void setAlternativeTitle(String alternativeTitle) {
        this.alternativeTitle = alternativeTitle;
    }

    public String getOtherTitleInfo() {
        return otherTitleInfo;
    }

    public void setOtherTitleInfo(String otherTitleInfo) {
        this.otherTitleInfo = otherTitleInfo;
    }

    public String getDescriptor() {
        return descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getPersonalName() {
        return personalName;
    }

    public void setPersonalName(String personalName) {
        this.personalName = personalName;
    }

    public String getAbstractContent() {
        return abstractContent;
    }

    public void setAbstractContent(String abstractContent) {
        this.abstractContent = abstractContent;
    }

    public String getClassCode() {
        return classCode;
    }

    public void setClassCode(String classCode) {
        this.classCode = classCode;
    }

    public String getDocNumber() {
        return docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getRq() {
        return rq;
    }

    public void setRq(Date rq) {
        this.rq = rq;
    }

    public String getDocType() {
        return docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getPrincipleReceiver() {
        return principleReceiver;
    }

    public void setPrincipleReceiver(String principleReceiver) {
        this.principleReceiver = principleReceiver;
    }

    public String getOtherReceivers() {
        return otherReceivers;
    }

    public void setOtherReceivers(String otherReceivers) {
        this.otherReceivers = otherReceivers;
    }

    public String getSecClassification() {
        return secClassification;
    }

    public void setSecClassification(String secClassification) {
        this.secClassification = secClassification;
    }

    public String getSecrecyPeriod() {
        return secrecyPeriod;
    }

    public void setSecrecyPeriod(String secrecyPeriod) {
        this.secrecyPeriod = secrecyPeriod;
    }

    public String getFormalCharacter() {
        return formalCharacter;
    }

    public void setFormalCharacter(String formalCharacter) {
        this.formalCharacter = formalCharacter;
    }

    public String getDocAggrType() {
        return docAggrType;
    }

    public void setDocAggrType(String docAggrType) {
        this.docAggrType = docAggrType;
    }

    public Integer getTotalNumberOfItems() {
        return totalNumberOfItems;
    }

    public void setTotalNumberOfItems(Integer totalNumberOfItems) {
        this.totalNumberOfItems = totalNumberOfItems;
    }

    public Integer getTotalPages() {
        return totalPages;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getManuscriptType() {
        return manuscriptType;
    }

    public void setManuscriptType(String manuscriptType) {
        this.manuscriptType = manuscriptType;
    }

    public String getElectronicAttr() {
        return electronicAttr;
    }

    public void setElectronicAttr(String electronicAttr) {
        this.electronicAttr = electronicAttr;
    }

    public String getFormatInfo() {
        return formatInfo;
    }

    public void setFormatInfo(String formatInfo) {
        this.formatInfo = formatInfo;
    }

    public String getComputerFileName() {
        return computerFileName;
    }

    public void setComputerFileName(String computerFileName) {
        this.computerFileName = computerFileName;
    }

    public String getComputerFileSize() {
        return computerFileSize;
    }

    public void setComputerFileSize(String computerFileSize) {
        this.computerFileSize = computerFileSize;
    }

    public String getDocCreatingApp() {
        return docCreatingApp;
    }

    public void setDocCreatingApp(String docCreatingApp) {
        this.docCreatingApp = docCreatingApp;
    }

    public String getInfoSystemDesc() {
        return infoSystemDesc;
    }

    public void setInfoSystemDesc(String infoSystemDesc) {
        this.infoSystemDesc = infoSystemDesc;
    }

    public String getDigitizationAttr() {
        return digitizationAttr;
    }

    public void setDigitizationAttr(String digitizationAttr) {
        this.digitizationAttr = digitizationAttr;
    }

    public String getPhyRecordCharacter() {
        return phyRecordCharacter;
    }

    public void setPhyRecordCharacter(String phyRecordCharacter) {
        this.phyRecordCharacter = phyRecordCharacter;
    }

    public String getScanningResolution() {
        return scanningResolution;
    }

    public void setScanningResolution(String scanningResolution) {
        this.scanningResolution = scanningResolution;
    }

    public String getScanningColorModel() {
        return scanningColorModel;
    }

    public void setScanningColorModel(String scanningColorModel) {
        this.scanningColorModel = scanningColorModel;
    }

    public String getImageCompScheme() {
        return imageCompScheme;
    }

    public void setImageCompScheme(String imageCompScheme) {
        this.imageCompScheme = imageCompScheme;
    }

    public String getElectronicSign() {
        return electronicSign;
    }

    public void setElectronicSign(String electronicSign) {
        this.electronicSign = electronicSign;
    }

    public String getSignatureRule() {
        return signatureRule;
    }

    public void setSignatureRule(String signatureRule) {
        this.signatureRule = signatureRule;
    }

    public Date getSignatureTime() {
        return signatureTime;
    }

    public void setSignatureTime(Date signatureTime) {
        this.signatureTime = signatureTime;
    }

    public String getSigner() {
        return signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getCertificate() {
        return certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getCertReference() {
        return certReference;
    }

    public void setCertReference(String certReference) {
        this.certReference = certReference;
    }

    public String getSignatureAlgoId() {
        return signatureAlgoId;
    }

    public void setSignatureAlgoId(String signatureAlgoId) {
        this.signatureAlgoId = signatureAlgoId;
    }

    public String getStorageLocation() {
        return storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public String getCurrentLocation() {
        return currentLocation;
    }

    public void setCurrentLocation(String currentLocation) {
        this.currentLocation = currentLocation;
    }

    public String getOfflineMediumId() {
        return offlineMediumId;
    }

    public void setOfflineMediumId(String offlineMediumId) {
        this.offlineMediumId = offlineMediumId;
    }

    public String getOffMedStorageLoc() {
        return offMedStorageLoc;
    }

    public void setOffMedStorageLoc(String offMedStorageLoc) {
        this.offMedStorageLoc = offMedStorageLoc;
    }

    public String getMicroformId() {
        return microformId;
    }

    public void setMicroformId(String microformId) {
        this.microformId = microformId;
    }

    public String getRightsManagement() {
        return rightsManagement;
    }

    public void setRightsManagement(String rightsManagement) {
        this.rightsManagement = rightsManagement;
    }

    public String getIntellectualPropStat() {
        return intellectualPropStat;
    }

    public void setIntellectualPropStat(String intellectualPropStat) {
        this.intellectualPropStat = intellectualPropStat;
    }

    public String getAuthorizedAgent() {
        return authorizedAgent;
    }

    public void setAuthorizedAgent(String authorizedAgent) {
        this.authorizedAgent = authorizedAgent;
    }

    public String getPermissionAssignment() {
        return permissionAssignment;
    }

    public void setPermissionAssignment(String permissionAssignment) {
        this.permissionAssignment = permissionAssignment;
    }

    public String getControlId() {
        return controlId;
    }

    public void setControlId(String controlId) {
        this.controlId = controlId;
    }

    public String getAnnotation() {
        return annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getAgentType() {
        return agentType;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getPositionName() {
        return positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public String getRelation() {
        return relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public String getRelationDesc() {
        return relationDesc;
    }

    public void setRelationDesc(String relationDesc) {
        this.relationDesc = relationDesc;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public static class ArchiveMetadataBuilder {

        private ArchiveMetaData metaData;

        public ArchiveMetadataBuilder() {
            metaData = new ArchiveMetaData();
        }

        public ArchiveMetadataBuilder(ArchiveMetaData metaData) {
            this.metaData = metaData;
        }

        public ArchiveMetadataBuilder id(String id) {
            // 限制修改id，只在没有id时允许修改
            if (StringUtils.isBlank(metaData.id)) {
                metaData.setId(id);
            }
            return this;
        }

        public ArchiveMetadataBuilder aggregation(String aggregationLevel) {
            metaData.setAggregationLevel(aggregationLevel);
            return this;
        }

        public ArchiveMetadataBuilder provenance(String provenance) {
            metaData.setProvenance(provenance);
            return this;
        }

        public ArchiveMetadataBuilder archivesName(String archivesName) {
            metaData.setArchivesName(archivesName);
            return this;
        }

        public ArchiveMetadataBuilder archiveIdentifier(String identifier) {
            metaData.setArchiveIdentifier(identifier);
            return this;
        }

        public ArchiveMetadataBuilder fondsName(String fondsName) {
            metaData.setFondsName(fondsName);
            return this;
        }

        public ArchiveMetadataBuilder fondsConstitutingUnitName(String fondsConstitutingUnitName) {
            metaData.setFondsConsUnitName(fondsConstitutingUnitName);
            return this;
        }

        public ArchiveMetadataBuilder electronicRecordCode(String electronicRecordCode) {
            metaData.setElcRecordCode(electronicRecordCode);
            return this;
        }

        public ArchiveMetadataBuilder archiveCode(String archiveCode) {
            metaData.setArchiveCode(archiveCode);
            return this;
        }

        public ArchiveMetadataBuilder fondsId(String fondsId) {
            metaData.setFondsId(fondsId);
            return this;
        }

        public ArchiveMetadataBuilder year(String year) {
            metaData.setYear(year);
            return this;
        }

        public ArchiveMetadataBuilder retentionPeriod(String retentionPeriod) {
            metaData.setRetentionPeriod(retentionPeriod);
            return this;
        }

        public ArchiveMetadataBuilder bgqx(String bgqx) {
            metaData.setBgqx(bgqx);
            return this;
        }

        public ArchiveMetadataBuilder jghwt(String jghwt) {
            metaData.setJghwt(jghwt);
            return this;
        }

        public ArchiveMetadataBuilder categoryCode(String categoryCode) {
            metaData.setCategoryCode(categoryCode);
            return this;
        }

        public ArchiveMetadataBuilder agencyFileNumber(String agencyFileNumber) {
            metaData.setAgencyFileNumber(agencyFileNumber);
            return this;
        }

        public ArchiveMetadataBuilder archiveFileNumber(String archiveFileNumber) {
            metaData.setArchiveFileNumber(archiveFileNumber);
            return this;
        }

        public ArchiveMetadataBuilder documentSequenceNumber(String documentSequenceNumber) {
            metaData.setDocSeqNumber(documentSequenceNumber);
            return this;
        }

        public ArchiveMetadataBuilder pageNumber(String pageNumber) {
            metaData.setPageNumber(pageNumber);
            return this;
        }

        public ArchiveMetadataBuilder contentDescription(String contentDescription) {
            metaData.setContentDescription(contentDescription);
            return this;
        }

        public ArchiveMetadataBuilder alternativeTitle(String alternativeTitle) {
            metaData.setAlternativeTitle(alternativeTitle);
            return this;
        }

        public ArchiveMetadataBuilder otherTitleInfo(String otherTitleInfo) {
            metaData.setOtherTitleInfo(otherTitleInfo);
            return this;
        }

        public ArchiveMetadataBuilder descriptor(String descriptor) {
            metaData.setDescriptor(descriptor);
            return this;
        }

        public ArchiveMetadataBuilder keyword(String keyword) {
            metaData.setKeyword(keyword);
            return this;
        }

        public ArchiveMetadataBuilder personalName(String personalName) {
            metaData.setPersonalName(personalName);
            return this;
        }

        public ArchiveMetadataBuilder abstractContent(String abstractContent) {
            metaData.setAbstractContent(abstractContent);
            return this;
        }

        public ArchiveMetadataBuilder classCode(String classCode) {
            metaData.setClassCode(classCode);
            return this;
        }

        public ArchiveMetadataBuilder docNumber(String docNumber) {
            metaData.setDocNumber(docNumber);
            return this;
        }

        public ArchiveMetadataBuilder author(String author) {
            metaData.setAuthor(author);
            return this;
        }

        public ArchiveMetadataBuilder rq(Date rq) {
            metaData.setRq(rq);
            return this;
        }

        public ArchiveMetadataBuilder docType(String docType) {
            metaData.setDocType(docType);
            return this;
        }

        public ArchiveMetadataBuilder principleReceiver(String principleReceiver) {
            metaData.setPrincipleReceiver(principleReceiver);
            return this;
        }

        public ArchiveMetadataBuilder otherReceivers(String otherReceivers) {
            metaData.setOtherReceivers(otherReceivers);
            return this;
        }

        public ArchiveMetadataBuilder securityClassification(String securityClassification) {
            metaData.setSecClassification(securityClassification);
            return this;
        }

        public ArchiveMetadataBuilder secrecyPeriod(String secrecyPeriod) {
            metaData.setSecrecyPeriod(secrecyPeriod);
            return this;
        }

        public ArchiveMetadataBuilder formalCharacteristics(String formalCharacteristics) {
            metaData.setFormalCharacter(formalCharacteristics);
            return this;
        }

        public ArchiveMetadataBuilder docAggregationType(String docAggregationType) {
            metaData.setDocAggrType(docAggregationType);
            return this;
        }

        public ArchiveMetadataBuilder totalNumberOfItems(Integer totalNumberOfItems) {
            metaData.setTotalNumberOfItems(totalNumberOfItems);
            return this;
        }

        public ArchiveMetadataBuilder totalPages(Integer totalPages) {
            metaData.setTotalPages(totalPages);
            return this;
        }

        public ArchiveMetadataBuilder language(String language) {
            metaData.setLanguage(language);
            return this;
        }

        public ArchiveMetadataBuilder manuscriptType(String manuscriptType) {
            metaData.setManuscriptType(manuscriptType);
            return this;
        }

        public ArchiveMetadataBuilder electronicAttr(String electronicAttr) {
            metaData.setElectronicAttr(electronicAttr);
            return this;
        }

        public ArchiveMetadataBuilder formatInfo(String formatInfo) {
            metaData.setFormatInfo(formatInfo);
            return this;
        }

        public ArchiveMetadataBuilder computerFileName(String computerFileName) {
            metaData.setComputerFileName(computerFileName);
            return this;
        }

        public ArchiveMetadataBuilder computerFileSize(String computerFileSize) {
            metaData.setComputerFileSize(computerFileSize);
            return this;
        }

        public ArchiveMetadataBuilder docCreatingApp(String docCreatingApp) {
            metaData.setDocCreatingApp(docCreatingApp);
            return this;
        }

        public ArchiveMetadataBuilder infoSystemDescription(String infoSystemDescription) {
            metaData.setInfoSystemDesc(infoSystemDescription);
            return this;
        }

        public ArchiveMetadataBuilder digitizationAttr(String digitizationAttr) {
            metaData.setDigitizationAttr(digitizationAttr);
            return this;
        }

        public ArchiveMetadataBuilder physicalRecordCharacteristics(String physicalRecordCharacteristics) {
            metaData.setPhyRecordCharacter(physicalRecordCharacteristics);
            return this;
        }

        public ArchiveMetadataBuilder scanningResolution(String scanningResolution) {
            metaData.setScanningResolution(scanningResolution);
            return this;
        }

        public ArchiveMetadataBuilder scanningColorModel(String scanningColorModel) {
            metaData.setScanningColorModel(scanningColorModel);
            return this;
        }

        public ArchiveMetadataBuilder imageCompressionScheme(String imageCompressionScheme) {
            metaData.setImageCompScheme(imageCompressionScheme);
            return this;
        }

        public ArchiveMetadataBuilder electronicSign(String electronicSign) {
            metaData.setElectronicSign(electronicSign);
            return this;
        }

        public ArchiveMetadataBuilder signatureRule(String signatureRule) {
            metaData.setSignatureRule(signatureRule);
            return this;
        }

        public ArchiveMetadataBuilder signatureTime(Date signatureTime) {
            metaData.setSignatureTime(signatureTime);
            return this;
        }

        public ArchiveMetadataBuilder signer(String signer) {
            metaData.setSigner(signer);
            return this;
        }

        public ArchiveMetadataBuilder signature(String signature) {
            metaData.setSignature(signature);
            return this;
        }

        public ArchiveMetadataBuilder certificate(String certificate) {
            metaData.setCertificate(certificate);
            return this;
        }

        public ArchiveMetadataBuilder certificateReference(String certificateReference) {
            metaData.setCertReference(certificateReference);
            return this;
        }

        public ArchiveMetadataBuilder signatureAlgoId(String signatureAlgoId) {
            metaData.setSignatureAlgoId(signatureAlgoId);
            return this;
        }

        public ArchiveMetadataBuilder storageLocation(String storageLocation) {
            metaData.setStorageLocation(storageLocation);
            return this;
        }

        public ArchiveMetadataBuilder currentLocation(String currentLocation) {
            metaData.setCurrentLocation(currentLocation);
            return this;
        }

        public ArchiveMetadataBuilder offlineMediumId(String offlineMediumId) {
            metaData.setOfflineMediumId(offlineMediumId);
            return this;
        }

        public ArchiveMetadataBuilder offlineMediumStorageLocation(String offlineMediumStorageLocation) {
            metaData.setOffMedStorageLoc(offlineMediumStorageLocation);
            return this;
        }

        public ArchiveMetadataBuilder microformId(String microformId) {
            metaData.setMicroformId(microformId);
            return this;
        }

        public ArchiveMetadataBuilder rightsManagement(String rightsManagement) {
            metaData.setRightsManagement(rightsManagement);
            return this;
        }

        public ArchiveMetadataBuilder intellectualPropStat(String intellectualPropStat) {
            metaData.setIntellectualPropStat(intellectualPropStat);
            return this;
        }

        public ArchiveMetadataBuilder authorizedAgent(String authorizedAgent) {
            metaData.setAuthorizedAgent(authorizedAgent);
            return this;
        }

        public ArchiveMetadataBuilder permissionAssignment(String permissionAssignment) {
            metaData.setPermissionAssignment(permissionAssignment);
            return this;
        }

        public ArchiveMetadataBuilder controlId(String controlId) {
            metaData.setControlId(controlId);
            return this;
        }

        public ArchiveMetadataBuilder annotation(String annotation) {
            metaData.setAnnotation(annotation);
            return this;
        }

        public ArchiveMetadataBuilder agentType(String agentType) {
            metaData.setAgentType(agentType);
            return this;
        }

        public ArchiveMetadataBuilder agentName(String agentName) {
            metaData.setAgentName(agentName);
            return this;
        }

        public ArchiveMetadataBuilder organizationCode(String organizationCode) {
            metaData.setOrganizationCode(organizationCode);
            return this;
        }

        public ArchiveMetadataBuilder positionName(String positionName) {
            metaData.setPositionName(positionName);
            return this;
        }

        public ArchiveMetadataBuilder businessStatus(String businessStatus) {
            metaData.setBusinessStatus(businessStatus);
            return this;
        }

        public ArchiveMetadataBuilder relation(String relation) {
            metaData.setRelation(relation);
            return this;
        }

        public ArchiveMetadataBuilder relationDescription(String relationDescription) {
            metaData.setRelationDesc(relationDescription);
            return this;
        }

        public ArchiveMetadataBuilder relationType(String relationType) {
            metaData.setRelationType(relationType);
            return this;
        }

        public ArchiveMetadataBuilder archiveId(String archiveId) {
            metaData.setArchiveId(archiveId);
            return this;
        }

        public ArchiveMetaData build() {
            return this.metaData;
        }
    }
}
