package com.gtis.archive.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

/**
 * 描述：档案鉴定历史
 * @author 卜祥东
 * 2017年10月12日 下午2:48:37
 */
@Entity
@Table(name = "t_archivejdhistory")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ArchiveJdHistory implements Cloneable{
    public static final String MODEL_NAME = ArchiveJdHistory.class.getSimpleName();
    
    public static final String ENTITY_NAME = "档案鉴定历史";
    public static final String FIELD_ARCHIVEID = "档案主键";
    public static final String FIELD_TM = "题名";
    public static final String FIELD_BGQXOLD = "原保管期限";
    public static final String FIELD_BGQXUPDATED = "新保管期限";
    public static final String FIELD_CZ = "操作";
    public static final String FIELD_SPZTNAME = "鉴定审批结果";
    public static final String FIELD_SPRQ = "审批日期";
    public static final String FIELD_SPRNAME = "审批人";
    public static final String FIELD_SPRID = "审批人Id";
    public static final String FIELD_SQRNAME = "申请人";
    public static final String FIELD_SQRID = "申请人Id";
    public static final String FIELD_SQRQ = "申请日期";
    public static final String FIELD_SPYJ = "审批意见";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
    * 档案主键 
    */
    @Column(length = 100)
    private String archiveId;

    /**
    * 题名 
    */
    @Column(length = 1000)
    private String tm;

    /**
    * 保管期限 
    */
    @Column(length = 10)
    private String bgqxOld;

    /**
    * 新保管期限 
    */
    @Column(length = 10)
    private String bgqxUpdated;

    /**
    * 操作 
    */
    @Column(length = 100)
    private String cz;

    /**
    * 鉴定审批结果 
    */
    @Column(length = 100)
    private String spztName;
    
    /**
     * 鉴定审批结果 
     */
    @Column(length = 1000)
    private String spyj;

    /**
    * 审批日期 
    */
    private Date sprq;
    
    /**
    * 审批人 
    */
    @Column(length = 100)
    private String sprName;

    /**
    * 审批人Id 
    */
    @Column(length = 100)
    private String sprId;

    /**
    * 申请人 
    */
    @Column(length = 100)
    private String sqrName;

    /**
    * 申请人Id 
    */
    @Column(length = 100)
    private String sqrId;

    /**
     * 档号
     */
    @Column(length = 100)
    private String dh;

    /**
    * 申请日期 
    */
    private Date sqrq;

    public String getId() {
    return id;
    }

    public void setId(String id) {
    this.id = id;
    }

    public String getArchiveId() {
    return archiveId;
    }

    public void setArchiveId(String archiveId) {
    this.archiveId = archiveId;
    }
    public String getTm() {
    return tm;
    }

    public void setTm(String tm) {
    this.tm = tm;
    }
    public String getBgqxUpdated() {
    return bgqxUpdated;
    }

    public void setBgqxUpdated(String bgqxUpdated) {
    this.bgqxUpdated = bgqxUpdated;
    }
    public String getCz() {
    return cz;
    }

    public void setCz(String cz) {
    this.cz = cz;
    }
    public String getSpztName() {
    return spztName;
    }

    public void setSpztName(String spztName) {
    this.spztName = spztName;
    }
    public Date getSprq() {
    return sprq;
    }

    public void setSprq(Date sprq) {
    this.sprq = sprq;
    }
    public String getSprName() {
    return sprName;
    }

    public void setSprName(String sprName) {
    this.sprName = sprName;
    }
    public String getSprId() {
    return sprId;
    }

    public void setSprId(String sprId) {
    this.sprId = sprId;
    }
    public String getSqrName() {
    return sqrName;
    }

    public void setSqrName(String sqrName) {
    this.sqrName = sqrName;
    }
    public String getSqrId() {
    return sqrId;
    }

    public void setSqrId(String sqrId) {
    this.sqrId = sqrId;
    }
    public Date getSqrq() {
    return sqrq;
    }

    public void setSqrq(Date sqrq) {
    this.sqrq = sqrq;
    }

	public String getBgqxOld() {
		return bgqxOld;
	}

	public void setBgqxOld(String bgqxOld) {
		this.bgqxOld = bgqxOld;
	}

	public String getSpyj() {
		return spyj;
	}

	public void setSpyj(String spyj) {
		this.spyj = spyj;
	}

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    @Override
    public ArchiveJdHistory clone() throws CloneNotSupportedException {
        return (ArchiveJdHistory) super.clone();
    }
}
