package com.gtis.archive.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.google.common.base.MoreObjects;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.envers.Audited;

/**
 * 档案
 * <p/>
 * Generated 2010-08-13 13:15:25 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_archive")
@Inheritance(strategy = InheritanceType.JOINED)
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Audited
public class Archive {
    public static final String MODEL_NAME = Archive.class.getSimpleName();
    public static final String DOCUMENT_SUFFIX = "_jn";
    public static final int STATE_WGD = 0;
    public static final int STATE_YGD = 1;

    @Id
    @Column(length = 32)
    private String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    private String modelName = getClass().getSimpleName();

    /**
     * 档号
     */
    @Column(length = 100)
    private String dh;

    /**
     * 单位代码
     */
    @Column(length = 100, nullable = true)
    private String dwdm;

    /**
     * 全宗号
     */
    @Column(length = 100, nullable = true)
    private String qzh;

    /**
     * 目录号
     */
    @Column(length = 100)
    private String mlh;

    /**
     * 案卷号
     */
    @Column
    private Integer ajh;

    /**
     * 题名
     */
    @Column(length = 1000)
    private String tm;

    /**
     * 分类号
     */
    @Column(length = 100)
    private String flh;

    /**
     * 年度
     */
    @Column(length = 10)
    private String nd;

    /**
     * 起日期
     */
    private Date qrq;

    /**
     * 止日期
     */
    private Date zrq;

    /**
     * 责任者
     */
    private String zrz;

    /**
     * 件数
     */
    @Column
    private Integer js;

    /**
     * 页数
     */
    @Column
    private Integer ys;

    /**
     * 保管期限  空值，短期，长期，定期-10年，定期-30年，永久
     */
    @Column(length = 10, nullable = false)
    private String bgqx;

    /**
     * 密级
     */
    @Column(length = 10, nullable = true)
    private String mj;

    /**
     * 箱号
     */
    @Column(length = 100)
    private String xh;

    /**
     * 存放位置
     */
    @Column(length = 100)
    private String cfwz;

    /**
     * 备注
     */
    @Column(length = 1000)
    private String bz;

    /**
     * 归档时间
     */
    private Date gdsj;

    /**
     * 归档人
     */
    @Column(length = 100)
    private String gdr;

    /**
     * 归档人Id
     */
    @Column(length = 100)
    private String gdrId;

    /**
     * 录入时间
     */
    private Date lrsj;

    /**
     * 录入人
     */
    @Column(length = 100)
    private String lrr;

    /**
     * 录入人ID
     */
    @Column(length = 100)
    private String lrrId;

    /**
     * 资源序号
     */
    @Column(length = 100)
    private String resourceId;

    /**
     * 状态，1:已归档，0:未归档,2:预处理,3：未处理,8：销毁
     */
    @Column
    private int state;

    /**
     * 文本格式的起日期
     */
    private String sqrq;


    /**
     * 文本格式的止日期
     */
    private String szrq;

    /**
     * 是否存在原文
     */
    @Transient
    private Boolean hasOriginal;

    /**
     * 房间号
     */
    @Column(length = 100)
    private String roomId;

    /**
     * 柜号
     */
    @Column(length = 100)
    private String  cabinetSno;

    /**
     * 柜左右面
     */
    @Column(length = 10)
    private Integer sideId;

    /**
     * 行号
     */
    @Column(length = 10)
    private Integer rowId;

    /**
     * 列号
     */
    @Column(length = 10)
    private Integer columnId;
    /**
     * 格号（从一个柜子的第一个第一行第一列开始，一次标识为1、2、3、4、......）
     */
    @Column(length = 10)
    private Integer cellId;

    /**
     * 盒号
     */
    @Column(length = 10)
    private Integer boxId;

    /**
     * 项目Id
     */
    @Column(length = 100)
    private String proId;

    /**
     * 授奖时间
     */
    private Date sjsj;

    /**
     * 移交单号
     */
    private String yjdh;

    /**
     * 接收单号
     */
    private String jsdh;

    /**
     * 移交批次号
     */
    private String yjpch;

    /**
     * 接收批次号
     */
    private String jspch;

    /**
     * 移交时间
     */
    private Date yjsj;

    /**
     * 接收时间
     */
    private Date jssj;

    /**
     * 接收人
     */
    private String jsr;

    /**
     * 流水号
     */
    @Column(length = 100)
    private String lsh;

    /**
     * 开放状态，0不开放；
     */
    @Column
    private Integer open;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        if (StringUtils.isNotEmpty(modelName)) {
            this.modelName = modelName;
        }
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getQzh() {
        return qzh;
    }

    public void setQzh(String qzh) {
        this.qzh = qzh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public Integer getAjh() {
        return ajh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public String getTm() {
        return tm;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    public String getFlh() {
        return flh;
    }

    public void setFlh(String flh) {
        this.flh = flh;
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public Date getQrq() {
        return qrq;
    }

    public void setQrq(Date qrq) {
        this.qrq = qrq;
    }

    public Date getZrq() {
        return zrq;
    }

    public void setZrq(Date zrq) {
        this.zrq = zrq;
    }

    public String getZrz() {
        return zrz;
    }

    public void setZrz(String zrz) {
        this.zrz = zrz;
    }

    public Integer getJs() {
        return js;
    }

    public void setJs(Integer js) {
        this.js = js;
    }

    public Integer getYs() {
        return ys;
    }

    public void setYs(Integer ys) {
        this.ys = ys;
    }

    public String getBgqx() {
        return bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = StringUtils.trim(bgqx);
    }

    public String getMj() {
        return mj;
    }

    public void setMj(String mj) {
        this.mj = StringUtils.trim(mj);
    }

    public String getXh() {
        return xh;
    }

    public void setXh(String xh) {
        this.xh = xh;
    }

    public String getCfwz() {
        return cfwz;
    }

    public void setCfwz(String cfwz) {
        this.cfwz = cfwz;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public Date getGdsj() {
        return gdsj;
    }

    public void setGdsj(Date gdsj) {
        this.gdsj = gdsj;
    }

    public String getGdr() {
        return gdr;
    }

    public void setGdr(String gdr) {
        this.gdr = gdr;
    }

    public String getGdrId() {
        return gdrId;
    }

    public void setGdrId(String gdrId) {
        this.gdrId = gdrId;
    }

    public Date getLrsj() {
        return lrsj;
    }

    public void setLrsj(Date lrsj) {
        this.lrsj = lrsj;
    }

    public String getLrr() {
        return lrr;
    }

    public void setLrr(String lrr) {
        this.lrr = lrr;
    }

    public String getLrrId() {
        return lrrId;
    }

    public void setLrrId(String lrrId) {
        this.lrrId = lrrId;
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getSqrq() {
        return sqrq;
    }

    public void setSqrq(String sqrq) {
        this.sqrq = sqrq;
    }

    public String getSzrq() {
        return szrq;
    }

    public void setSzrq(String szrq) {
        this.szrq = szrq;
    }

    public Boolean getHasOriginal() {
        return hasOriginal;
    }

    public void setHasOriginal(Boolean hasOriginal) {
        this.hasOriginal = hasOriginal;
    }

    public String getRoomId() {
        return roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getCabinetSno() {
        return cabinetSno;
    }

    public void setCabinetSno(String cabinetSno) {
        this.cabinetSno = cabinetSno;
    }

    public Integer getSideId() {
        return sideId;
    }

    public void setSideId(Integer sideId) {
        this.sideId = sideId;
    }

    public Integer getRowId() {
        return rowId;
    }

    public void setRowId(Integer rowId) {
        this.rowId = rowId;
    }

    public Integer getColumnId() {
        return columnId;
    }

    public void setColumnId(Integer columnId) {
        this.columnId = columnId;
    }

    public Integer getCellId() {
        return cellId;
    }

    public void setCellId(Integer cellId) {
        this.cellId = cellId;
    }

    public Integer getBoxId() {
        return boxId;
    }

    public void setBoxId(Integer boxId) {
        this.boxId = boxId;
    }

    public String getProId() {
        return proId;
    }

    public void setProId(String proId) {
        this.proId = proId;
    }

    public Date getSjsj() {
        return sjsj;
    }

    public void setSjsj(Date sjsj) {
        this.sjsj = sjsj;
    }

    public String getYjdh() {
        return yjdh;
    }

    public void setYjdh(String yjdh) {
        this.yjdh = yjdh;
    }

    public String getJsdh() {
        return jsdh;
    }

    public void setJsdh(String jsdh) {
        this.jsdh = jsdh;
    }

    public String getYjpch() {
        return yjpch;
    }

    public void setYjpch(String yjpch) {
        this.yjpch = yjpch;
    }

    public String getJspch() {
        return jspch;
    }

    public void setJspch(String jspch) {
        this.jspch = jspch;
    }

    public Date getYjsj() {
        return yjsj;
    }

    public void setYjsj(Date yjsj) {
        this.yjsj = yjsj;
    }

    public Date getJssj() {
        return jssj;
    }

    public void setJssj(Date jssj) {
        this.jssj = jssj;
    }

    public String getJsr() {
        return jsr;
    }

    public void setJsr(String jsr) {
        this.jsr = jsr;
    }

    public String getLsh() {
        return lsh;
    }

    public void setLsh(String lsh) {
        this.lsh = lsh;
    }

    public Integer getOpen() {
        return open;
    }

    public void setOpen(Integer open) {
        this.open = open;
    }

    public static boolean isArchiveModelName(String modelName) {
        return !modelName.endsWith(Archive.DOCUMENT_SUFFIX) && !Document.MODEL_NAME.endsWith(modelName);
    }

    public static String toDocumentModelName(String archiveModelName) {
        if (archiveModelName.endsWith(Archive.DOCUMENT_SUFFIX)) {
            return archiveModelName;
        } else if (Archive.MODEL_NAME.equals(archiveModelName) || Document.MODEL_NAME.equals(archiveModelName)) {
            return Document.MODEL_NAME;
        } else {
            return archiveModelName + Archive.DOCUMENT_SUFFIX;
        }
    }
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("modelName", modelName)
                .add("dh", dh)
                .add("dwdm", dwdm)
                .add("qzh", qzh)
                .add("mlh", mlh)
                .add("ajh", ajh)
                .add("tm", tm)
                .add("flh", flh)
                .add("nd", nd)
                .add("qrq", qrq)
                .add("zrq", zrq)
                .add("zrz", zrz)
                .add("js", js)
                .add("ys", ys)
                .add("bgqx", bgqx)
                .add("mj", mj)
                .add("xh", xh)
                .add("cfwz", cfwz)
                .add("bz", bz)
                .add("gdsj", gdsj)
                .add("gdr", gdr)
                .add("gdrId", gdrId)
                .add("lrsj", lrsj)
                .add("lrr", lrr)
                .add("lrrId", lrrId)
                .add("resourceId", resourceId)
                .add("state", state)
                .add("sqrq", sqrq)
                .add("szrq", szrq)
                .add("hasOriginal", hasOriginal)
                .add("roomId", roomId)
                .add("cabinetSno", cabinetSno)
                .add("sideId", sideId)
                .add("rowId", rowId)
                .add("columnId", columnId)
                .add("cellId", cellId)
                .add("boxId", boxId)
                .add("proId", proId)
                .add("sjsj", sjsj)
                .add("yjdh", yjdh)
                .add("jsdh", jsdh)
                .add("yjpch", yjpch)
                .add("jspch", jspch)
                .add("yjsj", yjsj)
                .add("jssj", jssj)
                .add("jsr", jsr)
                .add("lsh", lsh)
                .toString();
    }
}
