package com.gtis.archive.core.web;

import com.gtis.archive.core.ModelService;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-2
 */
public class ModelClassLoaderFilter extends SpringSecurityFilter {
    private ModelService modelService;

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    @Override
    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(modelService.getClassLoader());
            chain.doFilter(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public int getOrder() {
        return FilterChainOrder.FILTER_CHAIN_FIRST;
    }
}
