package com.gtis.archive.core.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.service.sv.SqlServerServiceImpl;
import com.gtis.archive.util.SearchUtils;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.struts2.interceptor.SessionAware;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import javax.servlet.http.HttpServletRequest;
import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;
import java.util.List;

/**
 * 模型实体对象集合基础action.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-1
 */
public class BaseModelAction<T> extends BaseAction implements SessionAware {
    protected static final String DIR_ASC = "asc";
    public static final String DIR_DESC = "desc";
    protected static final Map<String, String[]> idsCaches = Collections.synchronizedMap(new LRUMap(500));
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    protected ArchiveService archiveService;
    @Autowired
    protected OriginalService originalService;
    @Autowired
    protected DictService dictService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SqlServerServiceImpl sqlServerService;
    /**
     * 分页位置
     */
    protected int start = 0;

    /**
     * session
     */
    protected Map<String, Object> session;
    /**
     * 分页大小
     */
    protected int limit = Constants.DEFAULT_PAGE_SIZE;
    /**
     * 排序字段
     */
    protected String sort;
    /**
     * 排序方向
     */
    protected String dir;
    /**
     * 打印排序目录号
     */
    private String mlhorder;
    /**
     * 打印排序案卷号
     */
    private String ajhorder;
    /**
     * 打印排序年度
     */
    private String ndorder;
    /**
     * 模型名
     */
    protected String modelName;
    /**
     * 打印类型
     */
    protected String printType;
    /**
     * 模糊检索关键字
     */
    protected String query;
    /**
     * 高级检索关键字
     */
    protected String condition;
    /**
     * id列表
     */
    protected String[] ids;
    /**
     * 数据
     */
    protected String idsKey;
    /**
     * 实体对象列表
     */
    protected List<T> entities;
    /**
     * 列表要显示的字段
     */
    private Map showFields;
    /**
     * 移交列表列表要显示的字段
     */
    private Map yjShowFields;
    /**
     * 接收列表列表要显示的字段
     */
    private Map jsShowFields;
    /**
     * 当前是否为打印状态
     */
    protected boolean isPrint;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 当前用户
     */
    private String curUsername;

    /**
     * 当前系统时间
     */
    private String curSystemTime;

    /**
     * 当前用户单位代码
     */
    private String curRegionCode;

    /**
     * 当前用户角色
     */
    private String curUserRole;

    /**
     * 当前用户部门
     */
    private String curUserRegion;

    /**
     * 二维码图片URL
     */
    private String qrcodePath;

    /**
     * 搜索框字段提示
     */
    private String queryFieldsReminder;

    /**
     * 通过扫描获取档案的id
     */
    private String archiveKeys;

    /** 原文的路径列表 */
    private List<String> ogPaths;

    public String getArchiveKeys() {
        return archiveKeys;
    }

    public void setArchiveKeys(String archiveKeys) {
        this.archiveKeys = archiveKeys;
    }

    @Override
    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public void setOgPaths(List<String> ogPaths) {
        this.ogPaths = ogPaths;
    }

    public List<String> getOgPaths() {
        if (entities != null) {
            ogPaths = new ArrayList<String>();
            for (Object o : entities) {
                List<Original> list = null;
                try {
                    HttpServletRequest request = ServletActionContext.getRequest();
                    Object id = PropertyUtils.getProperty(o, "id");
                    if (id != null) {
                        list = originalService.getOriginals(id.toString());
                        if (list != null && !list.isEmpty()) {
                            StringBuilder strB = new StringBuilder();
                            String filePath = request.getRequestURL().toString().replace(request.getRequestURI(), "");
                            for (int i = 0;i < filePath.length();i++){
                                strB.append(list.get(i).getId());
                            }
                            filePath = "/archive/og!get.action?id=" + strB.toString();
                            logger.info("filePath = {}", filePath);
                            ogPaths.add(filePath);
                        } else {
                            ogPaths.add("");
                        }
                    } else {
                        ogPaths.add("");
                    }
                } catch (Exception e) {
                    logger.error("获取原文失败", e.getMessage(),e);
                    logger.error("获取原文路径失败");
                }
            }
        }
        return ogPaths;
    }

    public String getQueryFieldsReminder() {
        String[] fields = getQueryFields();
        StringBuilder sb = new StringBuilder();
        for (String s : fields) {
            if ("id".equals(s)) {
                continue;
            }

            if (getFields().get(s) == null) {
                sb.append(s).append("/");
            } else {
                sb.append(getFields().get(s).getTitle()).append("/");
            }
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public void setQueryFieldsReminder(String queryFieldsReminder) {
        this.queryFieldsReminder = queryFieldsReminder;
    }

    public String getQrcodePath() {
        if (idsKey == null || StringUtils.isEmpty(idsKey)) {
            return "";
        }

        if (StringUtils.isNotEmpty(idsKey)) {
            ids = idsCaches.get(idsKey);
            if (StringUtils.isNotBlank(idsKey) && (ids == null || ids.length == 0)) {
                ids = new String[]{idsKey};
            }
        }

        String path = "";
        StringBuilder sBuilder = new StringBuilder();
        String content;
        String field = EnvHolder.getAppEnv().get(Switch.QRCODE_FIELD_NAME);
        String fixModelName;


        if (field == null) {
            logger.error("qrCode.Field.Name为空");
            throw new RuntimeException("qrCode.Field.Name为空");
        } else {
            try {
                for (String id : ids) {
                    if (StringUtils.isNotBlank(id)) {
                        if (!modelName.contains("_jn")) {
                            fixModelName = modelName;
                        } else {
                            fixModelName = modelName.replaceAll("_jn", "");
                        }
                        Archive entity = entityService.load(fixModelName, id);

                        if (entity != null) {
                            String[] fields = StringUtils.split(field, ";");
                            for (String s : fields) {
                                if (PropertyUtils.getProperty(entity, s) != null) {

                                    sBuilder.append(PropertyUtils.getProperty(entity, s).toString()).append(";");
                                }
                            }
                            content = sBuilder.toString().trim().substring(0, sBuilder.toString().length() - 1);

                            if (StringUtils.isBlank(content)) {
                                logger.error("{}字段值为空字符串", field);
                                logger.error("字段值为空");
                            } else {
                                HttpServletRequest request = ServletActionContext.getRequest();
                                String basePath = request.getSession().getServletContext().getRealPath("/");
                                File parentFile = new File(basePath + File.separator + "tmp");

                                if (!parentFile.exists()) {
                                    parentFile.mkdirs();
                                } else {
                                    //文件夹大于1MB时删除
                                    if (FileUtils.sizeOfDirectory(parentFile) > FileUtils.ONE_MB) {
                                        FileUtils.cleanDirectory(parentFile);
                                    }
                                }

                                File file = new File(basePath + File.separator + "tmp" + File.separator + "qrcode" + File.separator + fixModelName);
                                if (!file.exists()) {
                                    file.mkdirs();
                                }
                                String filename = entity.getId() + ".jpg";
                                //二维码文件
                                File tmp = new File(file.getPath() + File.separator + filename);
                                if (tmp.exists() && !tmp.delete()) {
                                    logger.error("删除文件[{}]出错！",tmp.getPath());
                                }
                                //生成二维码图
                                BitMatrix bitMatrix = new MultiFormatWriter().encode(new String(content.getBytes("UTF-8"), "ISO-8859-1"), BarcodeFormat.QR_CODE, 200, 100);
                                //将二维码写入文件
                                MatrixToImageWriter.writeToFile(bitMatrix, "jpg", tmp);
                                logger.info(tmp.getPath());
                                path = request.getRequestURL().toString().replace(request.getRequestURI(), "");
                                StringBuilder strB = new StringBuilder();
                                strB.append(path).append(File.separator).append("archive").append(File.separator).append("tmp").append(File.separator).append("qrcode").append(File.separator).append(fixModelName).append(File.separator).append(filename);
                                path = strB.toString();
                            }
                        }
                    }
                }
                return path;
            } catch (WriterException e) {
                logger.error("生成二维码图错误:{}", e.getMessage());
                throw new RuntimeException("生成二维码图错误");
            } catch (IOException e) {
                logger.error("生成文件错误:{}", e.getMessage());
                throw new RuntimeException("生成文件错误");
            } catch (Exception e) {
                logger.error("获取案卷字段值错误:{}", e.getMessage());
                throw new RuntimeException("获取案卷字段值错误");

            }
        }
    }

    public void setQrcodePath(String qrcodePath) {
        this.qrcodePath = qrcodePath;
    }

    public String getUserName() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCurUsername(String curUsername) {
        this.curUsername = curUsername;
    }

    /**
     * 获取当前用户
     *
     * @return
     */
    public String getCurUsername() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setCurSystemTime(String curSystemTime) {
        this.curSystemTime = curSystemTime;
    }

    public String getCurSystemTime() {
        return SessionUtil.getCurTime();
    }

    public void setCurRegionCode(String curRegionCode) {
        this.curRegionCode = curRegionCode;
    }

    public String getCurRegionCode() {
        return SessionUtil.getCurrentUser().getRegionCode();
    }

    public void setCurUserRole(String curUserRole) {
        this.curUserRole = curUserRole;
    }
    /**
     * 系统权限列表
     */
    public Map<String, Boolean> getSysPerms() {
        Map<String, Boolean> sysPerms = new HashMap<String, Boolean>();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (!EnvHolder.isEnable(Switch.isNewPermission) || userInfo.isAdmin()) {
            for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
                if (securityService.isPermitted("sys", item.getName())) {
                    sysPerms.put(item.getName(), true);
                }
            }
        }else {
            sysPerms = securityService.getUserPermMap(userInfo,"sys");
        }
        return sysPerms;
    }

    /**
     * 获取角色名称
     *
     * @return
     */
    public String getCurUserRole() {
        List<PfRoleVo> roles = SessionUtil.getCurrentUser().getLstRole();
        List<String> rolenames = new ArrayList<String>();
        if (roles == null) {
            return "无角色";
        } else {
            for (PfRoleVo prv : roles) {
                rolenames.add(prv.getRoleName());
            }
            return rolenames.toString().substring(1, rolenames.toString().length() - 1);
        }
    }

    public void setCurUserRegion(String curUserRegion) {
        this.curUserRegion = curUserRegion;
    }

    /**
     * 获取部门名称
     */
    public String getCurUserRegion() {
        List<PfOrganVo> organs = SessionUtil.getCurrentUser().getLstOragn();
        List<String> organNames = new ArrayList<String>();
        for (PfOrganVo pov : organs) {
            organNames.add(pov.getOrganName());
        }
        return organNames.toString().substring(1, organNames.toString().length() - 1);
    }

    public BaseModelAction() {
        Type genType = getClass().getGenericSuperclass();
        if (genType instanceof ParameterizedType) {
            Type params = (((ParameterizedType) genType).getActualTypeArguments())[0];
            if (params instanceof Class) {
                setModelName(((Class) params).getSimpleName());
            }
        }
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setMlhorder(String mlhorder) {
        this.mlhorder = mlhorder;
    }

    public void setAjhorder(String ajhorder) {
        this.ajhorder = ajhorder;
    }

    public void setNdorder(String ndorder) {
        this.ndorder = ndorder;
    }

    public void setModelName(String modelName) {
        if (modelName.startsWith(Constants.ARCHIVE_PREFIX)) {
            this.modelName = modelName.substring(2);
        } else {
            this.modelName = modelName;
        }
    }

    public void setPrintType(String printType) {
        this.printType = printType;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setId(String[] ids) {
        this.ids = ids;
    }

    public void setIdsKey(String idsKey) {
        this.idsKey = idsKey;
    }

    public int getLimit() {
        if (limit == Constants.DEFAULT_PAGE_SIZE) {
            String pageSize = getEntityModel().getEnv().get("pageSize");
            if (StringUtils.isNotBlank(pageSize)) {
                limit = Integer.parseInt(pageSize);
            }
        }
        return limit;
    }

    public String getModelName() {
        return modelName;
    }

    public List<T> getEntities() {
        if (entities == null) {
            entities = getEntityPage().getItems();
            if ("ythsw".equalsIgnoreCase(modelName) && EnvHolder.isEnable(Switch.JIANGYIN) && isPrint) {
                try {
                    PropertyUtils.setProperty(entities.get(0), "oragn", getRagon());
                } catch (Exception ex) {
                    logger.error(ex.toString());
                }
            }
        }
        return entities;
    }

    /**
     * 获取实体对象模型
     *
     * @return 实体对象模型
     */
    public Model getEntityModel() {
        return modelService.getModel(modelName);
    }

    /**
     * 获取字段列表
     *
     * @return 字段列表
     */
    public Map<String, Field> getFields() {
        return getEntityModel().getInheritfieldsMap();
    }

    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    /**
     * 获取移交清单显示字段
     *
     * @return 字段列表
     */
    public Map getYjShowFields() {
        if (yjShowFields == null) {
            yjShowFields = JSON.parseObject(getEntityTemplate("yjShowFields"), LinkedHashMap.class);
        }
        return yjShowFields == null ? Collections.emptyMap() : yjShowFields;
    }

    /**
     * 获取接收清单显示字段
     *s
     * @return 字段列表
     */
    public Map getJsShowFields() {
        if (jsShowFields == null) {
            jsShowFields = JSON.parseObject(getEntityTemplate("jsShowFields"), LinkedHashMap.class);
        }
        return jsShowFields == null ? Collections.emptyMap() : jsShowFields;
    }

    public Map getConfigCondition() {
        Map map = new HashMap();
        try {
            String fields = getEntityTemplate("configCondition");
            map.put("num", fields.split(",").length);
            map.put("fields", JSONArray.toJSON(Arrays.asList(fields.split(","))));
        } catch (Exception ex) {
            map.put("num", 0);
        }
        return map;
    }

    public String getId() {
        return ids == null ? null : ids[0];
    }

    public void list(){
        try {
            if(EnvHolder.isEnable(Switch.WSD_DATA_SQL) && "Kfwsd".equals(modelName)){
                renderJson(getWsd());
            }else{
                renderJson(getEntityPage());
            }
        } catch (Exception e) {
            renderJson(new Page());
        }
    }

    public String cacheIds() {
        String key = UUIDHexGenerator.generate();
        idsCaches.put(key, ids);
        return renderJson(Collections.singletonMap("idsKey", key));
    }

    public String print() throws Exception {
        isPrint = true;
        return renderTemplate(getEntityModel().getTemplate("print"));
    }

    public String fr3() throws Exception {
        sendFile(getEntityModel().getPrintFr3(printType));
        return null;
    }

    public String export() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=" + modelName + "-export.xls");
        entities = getEntityPage().getItems();
        return renderModelTemplate("export");
    }

    public String remove() throws Exception {
        Archive archive = null;
        for (String id : ids) {
            archive = archiveService.getSimpleArchive(id);
            List<Document> docs = archiveService.getArchiveDocuments(archive);
            String[] dids = new String[docs.size()];
            for (int i = 0, size = docs.size(); i < size; i++) {
                dids[i] = docs.get(i).getId();
            }
            archiveService.removeDocument(modelName, dids);
            List<Original> ogs = originalService.getOriginals(id);
            String[] oids = new String[ogs.size()];
            for (int i = 0, size = ogs.size(); i < size; i++) {
                oids[i] = ogs.get(i).getId();
            }
            originalService.removeOriginal(oids);
        }
        logger.debug("remove archive [{}] ids [{}]", modelName, ids);
        entityService.remove(modelName, ids);
        return null;
    }

    protected Page<T> getEntityPage() {
        if (StringUtils.isNotEmpty(this.idsKey)) {
            if (idsKey.contains(";")) {
                String[] idKeys = idsKey.split(";");
                if (idKeys != null && idKeys.length > 0) {
                    for (int i = 0; i < idKeys.length; i++) {
                        logger.info("i is {}", i);
                    }
                }
            } else {
                ids = idsCaches.get(idsKey);
            }
        }
        //通过扫描获取的档案的id
        if (archiveKeys != null) {
            if (archiveKeys.contains(",")) {
                ids = archiveKeys.split(",");
            } else {
                ids = new String[]{archiveKeys};
            }
        }
        if (EnvHolder.isEnable(Switch.SIHONG)) {
            if (ids != null && !(isPrint && modelName.contains("_jn"))) {
                entities = new ArrayList<T>(ids.length);
                for (String id : ids) {
                    entities.add(entityService.<T>load(modelName, id));
                }

                isPrint = false;
                return new Page<T>(entities);
            }
            if (ids != null && isPrint && modelName.contains("_jn")) {
                entities = new ArrayList<T>();
                for (String id : ids) {
                    List<T> en;
                    List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
                    List<Order> orders = createOrders(new ArrayList<Order>());
                    en = searchDocentity(criterions, orders, id).getItems();
                    for (int i = 0; i < en.size(); i++) {
                        entities.add(en.get(i));
                    }
                    int j = 0;
                    if ((en.size() % 18) != 0) {
                        j = 18 - (en.size() % 18);
                    }
                    for (int i = 0; i < j; i++) {
                        Document document = entityService.newInstance(modelName);
                        document.setArchiveId(id);
                        try {
                            entities.add((T) document);
                        } catch (Exception e) {
                            logger.error("插入空白信息异常" + e.toString(),e);
                        }
                    }
                }

                isPrint = false;
                return new Page<T>(entities);
            }
        } else {
            if (ids != null) {
                entities = new ArrayList<T>(ids.length);
                for (String id : ids) {
                    entities.add(entityService.<T>load(modelName, id));
                }

                return new Page<T>(entities);
            }
        }

        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        return searchEntity(criterions, orders);
    }

    protected Page<Map<String,Object>> getWsd() {
        Page<Map<String,Object>> page = new Page<Map<String, Object>>();
        String sqlQuery = null;
        if (StringUtils.isNotBlank(condition)){
            String[] stringList= condition.split(";");
            sqlQuery = getSql(stringList);
        }

        page = sqlServerService.getDate(page,sqlQuery);

        Page<Map<String,Object>> archivePage1 = null;

        int count = start + limit;
        if(count > page.getTotalCount()){
            count = page.getTotalCount();
        }

        List<Map<String,Object>> archiveListPa = new ArrayList<Map<String,Object>>();
        for(int i=start;i < count;i++){
            archiveListPa.add(page.getItem(i));
        }
        archivePage1 = new Page<Map<String,Object>>(archiveListPa);
        archivePage1.setTotalCount(page.getTotalCount());
        archivePage1.setStart(start);
        archivePage1.setSize(limit);
        return archivePage1;
    }

    private String getSql(String[] stringList){
        String sql = null;
        StringBuilder strB = new StringBuilder();
        for(int i=0;i<stringList.length;i=i+3){
            String[] strings = stringList[i].split(",");
            String[] strings1 = stringList[i+1].split(",");
            String[] strings2 = stringList[i+2].split(",");
            if(strings1.length>1 && strings2.length>1){
                if(i == 0){
                    sql = getQuery(strings[1],strings1[1],strings2[1]);
                }else {
                    strB.append(getQuery(strings[1],strings1[1],strings2[1]));
                }
            }
        }
        sql = sql + strB.toString();
        return sql;
    }

    private String getQuery(String string, String string1, String string2){
        String sql = " and ";
        if ("like".equals(string1)) {
            sql = sql + string + " like '%" + string2 + "%'";
        } else if ("eq".equals(string1)) {
            sql = sql + string + " = " + string2;
        } else if ("ne".equals(string1)) {
            sql = sql + string + " != " + string2;
        } else if ("gt".equals(string1)) {
            sql = sql + string + " > " + string2;
        } else if ("lt".equals(string1)) {
            sql = sql + string + " < " + string2;
        } else if ("notNull".equals(string1)) {
            sql = sql + string + " is not null";
        } else if ("isNull".equals(string1)) {
            sql = sql + string + " is null";
        }
        return sql;
    }

    protected Page<T> searchEntity(List<Criterion> criterions, List<Order> orders) {
        return entityService.search(modelName, criterions, orders, start, limit);
    }

    protected Page<T> searchDocentity(List<Criterion> criterions, List<Order> orders, String archiveid) {
        return entityService.search(modelName, criterions, orders, start, limit);
    }

    protected List<Order> createOrders(final ArrayList<Order> orders) {
        if (StringUtils.isNotEmpty(sort)) {
            if (DIR_ASC.equalsIgnoreCase(dir)) {
                orders.add(Order.asc(sort));
            } else {
                orders.add(Order.desc(sort));
            }
        }

        if(StringUtils.isNotBlank(mlhorder)){
            if (DIR_ASC.equalsIgnoreCase(mlhorder)) {
                orders.add(Order.asc("mlh"));
            } else {
                orders.add(Order.desc("mlh"));
            }
        }
        if(StringUtils.isNotBlank(ajhorder)){
            if (DIR_ASC.equalsIgnoreCase(ajhorder)) {
                orders.add(Order.asc("ajh"));
            } else {
                orders.add(Order.desc("ajh"));
            }
        }
        if(StringUtils.isNotBlank(ndorder)){
            if (DIR_ASC.equalsIgnoreCase(ndorder)) {
                orders.add(Order.asc("nd"));
            } else {
                orders.add(Order.desc("nd"));
            }
        }

        if (orders.isEmpty()) {
            for (Map.Entry<String, String> entry : getOrderFields().entrySet()) {
                orders.add(entry.getValue().equalsIgnoreCase(DIR_ASC) ? Order.asc(entry.getKey()) : Order.desc(entry.getKey()));
            }
        }
        return orders;
    }

    protected List<Criterion> createCriterions(final ArrayList<Criterion> criterions) {
        if (StringUtils.isNotBlank(condition)) {
            criterions.addAll(SearchUtils.conditionToCriterion(getFields(), condition));
        }
        if (StringUtils.isNotBlank(query)) {
            query = query.trim();
            if (query.contains("_")) {
                query = query.replace("_", "\\_");
            } else if (query.contains("%")) {
                query = query.replace("%", "\\%");
            }
            String[] fields = getQueryFields();
            Model model = modelService.getModel(modelName);
            Model modelParent = modelService.getModel(modelName).getParent();
            Set<Field> fieldSet = model.getFields();
            Set<Field> parentFieldSet = modelParent.getFields();
            ArrayList<Field> fieldList = new ArrayList<Field>();
            fieldList.addAll(fieldSet);
            fieldList.addAll(parentFieldSet);
            ArrayList<String> containDateTimeTypeField = new ArrayList<String>();
            ArrayList<String> containDateTypeField = new ArrayList<String>();
            for (Field f : fieldList) {
                String temp = f.getName();
                if (f.getType() == Field.Type.DATE || f.getType() == Field.Type.DATETIME) {
                    if (!temp.matches("^[a-z]$")) {
                        String[] sArr = temp.split("(?=[A-Z])");
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < sArr.length - 1; i++) {
                            builder.append(sArr[i]).append("_");
                        }
                        builder.append(sArr[sArr.length - 1]);
                        temp = builder.toString().toLowerCase();
                    }
                    if (f.getType() == Field.Type.DATE) {
                        containDateTypeField.add(temp);
                    } else {
                        containDateTimeTypeField.add(temp);
                    }
                }
            }
            if (fields != null) {
                Criterion cr = null;
                for (String field : fields) {
                    if (!field.matches("^[a-z]$")) {
                        String[] sArr = field.split("(?=[A-Z])");
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < sArr.length - 1; i++) {
                            builder.append(sArr[i]).append("_");
                        }
                        builder.append(sArr[sArr.length - 1]);
                        field = builder.toString().toLowerCase();
                    }
                    String toChar = "to_char(";
                    if (!containDateTimeTypeField.contains(field) && !containDateTypeField.contains(field)) {
                        if ("id".equals(field)) {
                            cr = cr == null ? Restrictions.like(field, "%" + query + "%") : Restrictions.or(cr, Restrictions.like(field, "%" + query + "%"));
                        } else {
                            cr = cr == null ? Restrictions.sqlRestriction(toChar + field + ") like '%" + query + "%' escape '\\'") : Restrictions.or(cr, Restrictions.sqlRestriction(toChar + field + ") like '%" + query + "%' escape '\\'"));
                        }
                    } else if (containDateTypeField.contains(field)) {
                        cr = cr == null ? Restrictions.sqlRestriction(toChar + field + ",'yyyy-mm-dd') like '%" + query + "%'") : Restrictions.or(cr, Restrictions.sqlRestriction(toChar + field + ",'yyyy-mm-dd') like '%" + query + "%'"));
                    } else if (containDateTimeTypeField.contains(field)) {
                        cr = cr == null ? Restrictions.sqlRestriction(toChar + field + ",'yyyy-mm-dd hh24:mi:ss') like '%" + query + "%'") : Restrictions.or(cr, Restrictions.sqlRestriction(toChar + field + ",'yyyy-mm-dd hh24:mi:ss') like '%" + query + "%'"));
                    }
                }
                if (cr != null) {
                    criterions.add(cr);
                }
            }
        }
        return criterions;
    }

    /**
     * 高级查询字段过滤
     */
    public Map<String, Field> getAdvSearchFields() {
        Map<String, Field> allFields = getFields();
        Map<String, Field> fields = new LinkedHashMap<String, Field>();
        try {
            String[] filters = StringUtils.split(getEntityTemplate("advSearchFields"), ",");
            if (filters.length == 0) {
                return fields;
            }
            for (String name : filters) {
                if (allFields.containsKey(name)) {
                    fields.put(name, allFields.get(name));
                }
            }
        } catch (TemplateNotFoundException e) {
            return allFields;
        }
        return fields;
    }

    /**
     * 接收查询字段过滤
     */
    public Map<String, Field> getJsSearchFields() {
        Map<String, Field> allFields = getFields();
        Map<String, Field> fields = new LinkedHashMap<String, Field>();
        try {
            String[] filters = StringUtils.split(getEntityTemplate("jsSearchFields"), ",");
            if (filters.length == 0) {
                return fields;
            }
            for (String name : filters) {
                if (allFields.containsKey(name)) {
                    fields.put(name, allFields.get(name));
                }
            }
        } catch (TemplateNotFoundException e) {
            return allFields;
        }
        return fields;
    }
    @SuppressWarnings("unchecked")
    protected LinkedHashMap<String, String> getOrderFields() {
        try {
            if (isPrint) {
                return JSON.parseObject(getEntityTemplate("printOrderFields"), LinkedHashMap.class);
            } else {
                return JSON.parseObject(getEntityTemplate("orderFields"), LinkedHashMap.class);
            }
        } catch (TemplateNotFoundException ex) {
            return JSON.parseObject(getEntityTemplate("orderFields"), LinkedHashMap.class);
        }
    }

    protected String[] getQueryFields() {
        return StringUtils.split(getEntityTemplate("queryFields"), ",");
    }

    protected String getEntityTemplate(String name) {
        return getEntityModel().getTemplate(name);
    }

    protected String renderModelTemplate(String name) throws Exception {
        return renderTemplate(getEntityTemplate(name));
    }


    //暨办单组织机构
    private String getRagon() {
        String oragn = "";
        String dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
        try {
            List<Item> items = dictService.getItems(Constants.ORAGN);
            for (Item item : items) {
                if (dwdm.equals(item.getName())) {
                    oragn = item.getValue();
                    break;
                }
            }
        } catch (Exception ex) {
            logger.info("未配置[{}]组织机构字典项", Constants.ORAGN);
        }
        return oragn;
    }

    protected String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            ////单位代码用部门代码进行替换
            if (EnvHolder.isEnable(Switch.ORAGAN_NO)) {
                String oraganNo = null;
                List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (pfOrganVoList != null && !pfOrganVoList.isEmpty()) {
                    PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                    oraganNo = pfOrganVo.getOraganNo();
                }
                dwdm = oraganNo;
            } else {
                dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            }
        }

        return dwdm;
    }

    /**
     * 获取当前用户+用户Id用于水印
     *
     * @return
     */
    public String getName() throws Exception {
        userName = SessionUtil.getCurrentUser().getUsername();
        String userId = SessionUtil.getCurrentUser().getId();
        String userLogin = null;
        List<PfUserVo> list = userService.getAllUsers();

        for (PfUserVo user : list) {
            if (user.getUserId().equals(userId) && user.getUserNo() != null) {
                    userLogin = user.getLoginName();
            }
        }

        HttpServletRequest request = ServletActionContext.getRequest();
        String basePath = request.getSession().getServletContext().getRealPath("/");
        File parentFile = new File(basePath + File.separator+"tmp");

        if (!parentFile.exists()) {
            parentFile.mkdirs();
        } else {
            //文件夹大于1MB时删除
            if(FileUtils.sizeOfDirectory(parentFile) > FileUtils.ONE_MB) {
                FileUtils.cleanDirectory(parentFile);
            }
        }

        File file = new File(basePath + File.separator + "tmp" + File.separator + "waterMarked");
        if (!file.exists()) {
            file.mkdirs();
        }
        String filename = userLogin + ".png";
        File tmp = new File(file.getPath() + File.separator + filename);
        if (!tmp.exists()) {
            createImage(userName, new Font("宋体", Font.BOLD, 32), tmp, 200, 200);
        }

        return renderJson(userLogin);
    }

    // 根据str,font的样式以及输出文件目录
    private static void createImage(String str, Font font, File outFile,
                                   Integer width, Integer height) throws IOException{
        // 创建图片
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
        Graphics2D g = image.createGraphics();

        g.setClip(0, 0, width, height);
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);// 先用黑色填充整张图片,也就是背景
        g.setColor(Color.gray);// 在换成黑色
        g.setFont(font);// 设置画笔字体


        //设置旋转角度及旋转中心
        //Math.toDegrees():将用弧度表示的角转换为近似相等的用角度表示的角
        //Math.toRadians():将用角度表示的角转换为近似相等的用弧度表示的角，rotate的第一个参数是用弧度表示的，所以使用toRadians方法
        //相同的设置成30，结果为:toDegrees方法添加倒置的水印，toRadians添加正置的水印
        g.rotate(Math.toRadians(-30),image.getWidth()/(double)2, image.getHeight()/(double)2);

        /** 设置文字居中 */
        FontMetrics fm = g.getFontMetrics(font);

        int stringWidth = fm.stringWidth(str);
        int stringAscent = fm.getAscent();

        int xCoordinate = width/2 - stringWidth/2;
        int yCoordinate = height/2 +stringAscent/2;

        g.drawString(str, xCoordinate, yCoordinate);// 画出字符串
        g.dispose();
        ImageIO.write(image, "png", outFile);// 输出png图片
    }

    public UserInfo getUser(){
        UserInfo user = new UserInfo();
        SecurityContext context = (SecurityContext)session.get("SPRING_SECURITY_CONTEXT");
        if (context != null) {
            Authentication authentication = context.getAuthentication();

            user =(UserInfo) authentication.getPrincipal();
        }
        return user;
    }
}
