package com.gtis.archive.core.web;

import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.Action;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import javax.script.*;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-17
 */
public abstract class BaseAction extends FreemarkerRenderSupport implements Action {
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    protected void sendFile(File file) throws IOException {
        HttpServletResponse response = ServletActionContext.getResponse();
        if (file != null && file.exists()) {
            long modified = file.lastModified();
            long modifiedSince = ServletActionContext.getRequest().getDateHeader("If-Modified-Since");
            if (modifiedSince > 0L) {
                long modDate = (modified / 1000L) * 1000L;
                if (modDate <= modifiedSince) {
                    response.setStatus(HttpServletResponse.SC_NOT_MODIFIED);
                    return;
                }
                response.setDateHeader("Last-Modified", modified);
            }
            response.setContentLength((int) file.length());
            FileCopyUtils.copy(new FileInputStream(file), response.getOutputStream());
        } else {
            response.sendError(HttpServletResponse.SC_NOT_FOUND, "file not found");
        }
    }

    protected String renderJson(Object obj) {
        Struts2Utils.renderJson(obj);
        return null;
    }

    protected String renderSuccess() {
        renderJson(Collections.singletonMap("success", true));
        return null;
    }

    protected String renderFailure(String message) {
        Map<String, Serializable> map = new HashMap<String, Serializable>(2);
        map.put("msg", message);
        map.put("success", false);
        renderJson(map);
        return null;
    }

    protected String renderJs(Runner runner, String successMessage, String failuremessage, String fn) {
        if (fn == null) {
            fn = "onComplete";
        }
        try {
            runner.run();
            if (successMessage == null) {
                successMessage = "";
            }
            Struts2Utils.renderJs("(opener||parent||self||top)." + fn + "(true,'" + successMessage + "');");
        } catch (Exception e) {
            logger.error("error", e);
            if (failuremessage == null) {
                failuremessage = "失败 " + e.getMessage();
            }
            Struts2Utils.renderJs("(opener||parent)." + fn + "(false,'" + failuremessage + "');");
        }
        return null;
    }

    protected String renderJs(Runner runner, String fn) {
        return renderJs(runner, null, null, fn);
    }

    protected String renderJs(Runner runner) {
        return renderJs(runner, null);
    }

    protected static interface Runner {
        void run();
    }
}
