package com.gtis.archive.core.support.xstream;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.Dom4JDriver;
import org.dom4j.io.XMLWriter;

import java.io.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-11-3
 */
public class CDATASupportDom4JDriver extends Dom4JDriver {
    @Override
    public HierarchicalStreamWriter createWriter(final Writer out) {
        final HierarchicalStreamWriter[] writer = new HierarchicalStreamWriter[1];
        final FilterWriter filter = new FilterWriter(out) {
            @Override
            public void close() {
                writer[0].close();
            }
        };
        writer[0] = new CDATASupportDom4JXmlWriter(new XMLWriter(filter, getOutputFormat()), getNameCoder());
        return writer[0];
    }

    @Override
    public HierarchicalStreamWriter createWriter(OutputStream out) {
        Writer writer;
        try {
            writer = new OutputStreamWriter(out, getOutputFormat().getEncoding());
        } catch (UnsupportedEncodingException e) {
            writer = new OutputStreamWriter(out);
        }
        return createWriter(writer);
    }
}
