package com.gtis.archive.core.support.spring;

import com.gtis.archive.core.AppPropsManager;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.environment.Environment;
import com.gtis.config.AppConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

import javax.servlet.ServletContext;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-5
 */
public class EnvHolderConfigurer implements InitializingBean, ServletContextAware {
    private AppPropsManager appPropsService;
    private String webroot="./";

    /*
     * note：
     *
     * 不能在此注入configPropService
     * @Autowired
     * private ConfigPropService configPropService;
     *
     * 在此注入configPropService会引发ConfigPropService的初始化
     * 而ConfigPropService继承自HibernateTemplate，而HibernateTemplate继承自HibernateDao
     * 也会引发这两个类的初始化，spring为了注入sessionFactory会触发hibernate的配置，而这发生在
     * 档案配置的动态类（具体的档案业务实体类）加载之前，这会造成数据不会显示，因为这些类并未
     * 被hibernate扫描
     *
     * 相关日志：
     * Found injected field on class [com.gtis.archive.core.support.spring.EnvHolderConfigurer]: AutowiredFieldElement for private com.gtis.archive.service.ConfigPropService com.gtis.archive.core.support.spring.EnvHolderConfigurer.configPropService
     * Eagerly caching bean 'envHolderConfigurer' to allow for resolving potential circular references
     * Processing injected field of bean 'envHolderConfigurer': AutowiredFieldElement for private com.gtis.archive.service.ConfigPropService com.gtis.archive.core.support.spring.EnvHolderConfigurer.configPropService
     * Creating shared instance of singleton bean 'configPropServiceImpl'
     * Creating instance of bean 'configPropServiceImpl'
     * Found injected method on class [com.gtis.archive.service.impl.ConfigPropServiceImpl]: AutowiredMethodElement for public void com.gtis.support.hibernate.HibernateDao.setSessionFactory(org.hibernate.SessionFactory)*
     * Eagerly caching bean 'configPropServiceImpl' to allow for resolving potential circular references
     * Processing injected method of bean 'configPropServiceImpl': AutowiredMethodElement for public void com.gtis.support.hibernate.HibernateDao.setSessionFactory(org.hibernate.SessionFactory)
     * Creating shared instance of singleton bean 'sessionFactory'
     * Creating instance of bean 'sessionFactory'
     * Eagerly caching bean 'sessionFactory' to allow for resolving potential circular references
     */

    @Override
    @SuppressWarnings("unchecked")
    public void afterPropertiesSet() throws Exception {
        Environment env = EnvHolder.getSysProps();
        Environment dbEnv = null;
        Map props = AppConfig.getProperties();
        props.put("web.root", webroot);
        if (props.size() > 0) {
            env = new Environment(props, env);
        }
        env = new Environment(appPropsService.getAppProps(), env);

        EnvHolder.setAppEnv(env);
        EnvHolder.setDbEnv(env);
    }

    public Environment getAppEnv() {
        return EnvHolder.getAppEnv();
    }

    public void setAppEnvService(AppPropsManager appPropsService) {
        this.appPropsService = appPropsService;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        webroot = servletContext.getRealPath("/");
    }
}
