package com.gtis.archive.core.support.hibernate;

import org.hibernate.*;
import org.hibernate.classic.Session;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.NamingException;
import javax.naming.Reference;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-7-29
 */
public class ReloadableSessionFactory implements SessionFactory {
    private static final long serialVersionUID = 1590291600523676145L;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private SessionFactory sessionFactory;
    private ReloadableLocalSessionFactoryBean fb;

    public ReloadableSessionFactory(SessionFactory sessionFactory, ReloadableLocalSessionFactoryBean reloadableLocalSessionFactoryBean) {
        this.sessionFactory = sessionFactory;
        this.fb = reloadableLocalSessionFactoryBean;
    }

    @Override
    public Reference getReference() throws NamingException {
        return sessionFactory.getReference();
    }

    @Override
    public Session openSession(Connection connection) {
        return sessionFactory.openSession(connection);
    }

    @Override
    public Session openSession(Interceptor sessionLocalInterceptor) throws HibernateException {
        return sessionFactory.openSession(sessionLocalInterceptor);
    }

    @Override
    public Session openSession(Connection connection, Interceptor sessionLocalInterceptor) {
        return sessionFactory.openSession(connection, sessionLocalInterceptor);
    }

    @Override
    public Session openSession() throws HibernateException {
        return sessionFactory.openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        return sessionFactory.getCurrentSession();
    }

    @Override
    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return sessionFactory.getClassMetadata(persistentClass);
    }

    @Override
    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return sessionFactory.getClassMetadata(entityName);
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return sessionFactory.getCollectionMetadata(roleName);
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return sessionFactory.getAllClassMetadata();
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return sessionFactory.getAllCollectionMetadata();
    }

    @Override
    public Statistics getStatistics() {
        return sessionFactory.getStatistics();
    }

    @Override
    public void close() throws HibernateException {
        sessionFactory.close();
    }

    @Override
    public boolean isClosed() {
        return sessionFactory.isClosed();
    }

    @Override
    public Cache getCache() {
        return sessionFactory.getCache();
    }

    @Override
    public void evict(Class persistentClass) throws HibernateException {
        sessionFactory.evict(persistentClass);
    }

    @Override
    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        sessionFactory.evict(persistentClass, id);
    }

    @Override
    public void evictEntity(String entityName) throws HibernateException {
        sessionFactory.evictEntity(entityName);
    }

    @Override
    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        sessionFactory.evictEntity(entityName, id);
    }

    @Override
    public void evictCollection(String roleName) throws HibernateException {
        sessionFactory.evictCollection(roleName);
    }

    @Override
    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        sessionFactory.evictCollection(roleName, id);
    }

    @Override
    public void evictQueries() throws HibernateException {
        sessionFactory.evictQueries();
    }

    @Override
    public void evictQueries(String cacheRegion) throws HibernateException {
        sessionFactory.evictQueries(cacheRegion);
    }

    @Override
    public StatelessSession openStatelessSession() {
        return sessionFactory.openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return sessionFactory.openStatelessSession(connection);
    }

    @Override
    public Set getDefinedFilterNames() {
        return sessionFactory.getDefinedFilterNames();
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return sessionFactory.getFilterDefinition(filterName);
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return sessionFactory.containsFetchProfileDefinition(name);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return sessionFactory.getTypeHelper();
    }

    @SuppressWarnings("unchecked")
    public synchronized void reload() {
        SessionFactory newSessionFactory = null;
        try {
            newSessionFactory = fb.rebuildSessionFactory();
        } catch (Exception e) {
            logger.error("reload hibernate error", e);
            logger.error("reload hibernate error:{}", e);
        } finally {
            SessionFactory oldSessionFactory = sessionFactory;
            if (newSessionFactory != null) {
                sessionFactory = newSessionFactory;
                logger.info("reload hibernate successed:{}", sessionFactory.getAllClassMetadata());
                try {
                    oldSessionFactory.close();
                } catch (HibernateException e) {
                    logger.error("close hibernate error", e);
                }
            }
        }
    }
}
