package com.gtis.archive.core.support.freemarker;

import com.gtis.archive.core.dict.DictService;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.WrappingTemplateModel;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-27
 */
public class DictModel extends WrappingTemplateModel implements TemplateHashModel {
    private DictService dictService;

    public DictModel(DictService dictService) {
        this.dictService = dictService;
    }

    @Override
    public TemplateModel get(String key) throws TemplateModelException {
        return wrap(dictService.getItems(key));
    }

    @Override
    public boolean isEmpty() throws TemplateModelException {
        return dictService == null;
    }
}
