package com.gtis.archive.core.impl;

import com.gtis.archive.core.AppPropsManager;
import com.gtis.archive.core.support.xstream.CDATASupportDom4JDriver;
import com.thoughtworks.xstream.XStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-5
 */
public class AppPropsManagerImpl implements AppPropsManager {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private Resource location;
    private Map<String, String> props;
    private XStream sm;

    public void setLocation(Resource location) {
        this.location = location;
    }

    @Override
    public Map<String, String> getAppProps() {
        return props;
    }

    @Override
    public synchronized void saveAppProps() {
        OutputStream os = null;
        try {
            os = new FileOutputStream(location.getFile());
            sm.toXML(props, os);
        } catch (IOException e) {
            logger.error("store props [" + props + "],error:{}", e);
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException ignored) {
                    logger.error(ignored.getMessage());
                }
            }
        }
    }

    @SuppressWarnings("unchecked")
    public void init() {
        sm = new XStream(new CDATASupportDom4JDriver());
        InputStream is = null;
        try {
            is = location.getInputStream();
            props = (Map<String, String>) sm.fromXML(is);
        } catch (Exception e) {
            props = new LinkedHashMap<String, String>();
            logger.error("load props file [" + location + "],error:{}", e);
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException ignored) {
                    logger.error(ignored.getMessage());
                }
            }
        }
    }
}
