package com.gtis.archive.core.ex;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-1
 */
public class TemplateNotFoundException extends RuntimeException {
    private static final long serialVersionUID = 5901565440241904604L;
    private final String modelName;
    private final String tplName;

    public TemplateNotFoundException(String tplName, String modelName) {
        this.tplName = tplName;
        this.modelName = modelName;
    }

    public String getModelName() {
        return modelName;
    }

    public String getTplName() {
        return tplName;
    }

    @Override
    public String getMessage() {
        return "模型[" + modelName + "]的[" + tplName + "]模板未找到,请检查您的模型模板配置";
    }
}
