package com.gtis.archive.core.ex;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-1
 */
public class EntityNotFoundException extends RuntimeException {
    private static final long serialVersionUID = -4225025426214105490L;
    private Class clazz;
    private String id;

    public EntityNotFoundException(String message) {
        super(message);
    }

    public EntityNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }

    public EntityNotFoundException(Class clazz, String id) {
        this.clazz = clazz;
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public Class getClazz() {
        return clazz;
    }

    @Override
    public String getMessage() {
        String msg=super.getMessage();
        if (msg != null) {
            return msg;
        }
        return "对象类[" + clazz.getSimpleName() + "],id[" + id + "]未找到";
    }
}
