package com.gtis.archive.core.environment;

import freemarker.ext.beans.BeanModel;
import freemarker.template.*;
/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-5
 */
public class EnvironmentModel extends WrappingTemplateModel implements TemplateHashModel {
    private Environment env;

    public EnvironmentModel(Environment environment) {
        this.env = environment;
    }

    @Override
    public TemplateModel get(String key) throws TemplateModelException {
        String value = env.get(key);
        if (value == null) {
            if (env.getValueObject() != null) {
                return new BeanModel(env.getValueObject(), (DefaultObjectWrapper) getDefaultObjectWrapper()).get(key);
            }
        } else {
            return wrap(value);
        }
        return null;
    }

    @Override
    public boolean isEmpty() throws TemplateModelException {
        return env.isEmpty();
    }
}
