package com.gtis.archive.core.environment;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-4
 */
public class EnvHolder {
    private static Environment sysEnv;
    private static Environment sysProps;
    private static Environment appEnv;
    /** 保存在数据库中的配置项 */
    private static Environment dbEnv;
    private EnvHolder(){
    }
    public static Environment getSysEnv() {
        if (sysEnv == null) {
            sysEnv = new Environment(System.getenv());
        }
        return sysEnv;
    }

    public static Environment getSysProps() {
        if (sysProps == null) {
            sysProps = new Environment(System.getProperties(), getSysEnv());
        }
        return sysProps;
    }

    public static Environment getAppEnv() {
        return appEnv;
    }

    public static void setAppEnv(Environment env) {
        appEnv = env;
    }

    public static Environment getDbEnv() {
        return dbEnv;
    }

    public static void setDbEnv(Environment dbEnv) {
        EnvHolder.dbEnv = dbEnv;
    }

    public static boolean isEnable(String key) {
        return "true".equalsIgnoreCase(appEnv.get(key));
    }
}

