package com.gtis.archive.core;

import com.gtis.archive.Constants;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-3
 */
public class Model {
    public static final String PACKAGE_NAME = "com.gtis.archive.entity";
    private static final Logger logger = LoggerFactory.getLogger(Model.class);

    private String name;
    private String title;
    private String remark;
    private String parentName;
    private boolean constant;
    private boolean hidden;
    private Set<Field> fields;
    private Map<String, String> templates;
    private Environment env;
    @XStreamOmitField
    private Model parent;
    @XStreamOmitField
    private Map<String, Field> fieldCache;
    @XStreamOmitField
    private Map<String, Field> inheritFieldCache;

    public Environment getEnv() {
        return env;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public Set<Field> getFields() {
        return fields;
    }

    public void setFields(Set<Field> fields) {
        fieldCache = null;
        inheritFieldCache = null;
        this.fields = fields;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Model getParent() {
        return parent;
    }

    public void setParent(Model parent) {
        this.parent = parent;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        fieldCache = null;
        inheritFieldCache = null;
        this.parentName = parentName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Map<String, String> getTemplates() {
        return templates;
    }

    public void setTemplates(Map<String, String> templates) {
        this.templates = templates;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isConstant() {
        return constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public boolean isHidden() {
        return hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Model && name != null && name.equals(((Model) obj).getName());
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + name + "," + title + "]";
    }

    public Field getField(String fieldName) {
        if (fieldCache == null) {
            initFieldsMap();
        }
        return fieldCache.get(fieldName);
    }

    public Field getInheritField(String fieldName) {
        if (inheritFieldCache == null) {
            initFieldsMap();
        }
        return inheritFieldCache.get(fieldName);
    }

    public Map<String, Field> getInheritfieldsMap() {
        if (inheritFieldCache == null) {
            initFieldsMap();
        }
        return inheritFieldCache;
    }

    public String getTemplate(String tplName) {
        String tpl = null;
        for (Model model = this; model != null; model = model.getParent()) {
            if (model.getTemplates() != null) {
                tpl = model.getTemplates().get(tplName);
                if (StringUtils.isNotBlank(tpl)) {
                    return tpl;
                }
            }
            String fileName = model.getName() + "-" + tplName + ".ftl";
            String basePath = env.getExpr("${.vars['web.root']}/tpls");
            File file = new File(basePath, fileName);
            if (!file.exists()) {
                basePath = env.getExpr("${.vars['egov.conf']}/archive/tpls");
                try {
                    file = ResourceUtils.getFile(basePath + "/" + fileName);
                    if (file.exists()) {
                        file.getPath();
                    }
                } catch (FileNotFoundException ignored) {
                    logger.error(ignored.getMessage());
                }
            }else {
                try {
                    return FileUtils.readFileToString(file, Constants.DEFAULT_CHARSET);
                } catch (IOException e) {
                    logger.error("read file error", e);
                }
            }
        }
        if (tpl == null) {
            try {
                File file = ResourceUtils.getFile(env.getExpr("${.vars['web.root']}/tpls/") + tplName + ".ftl");
                if (file.exists()) {
                    return FileUtils.readFileToString(file, Constants.DEFAULT_CHARSET);
                }
            } catch (IOException ignored) {
                logger.error(ignored.getMessage());
            }
            throw new TemplateNotFoundException(tplName, name);
        }
        return tpl;
    }

    public File getPrintFr3(String printType) {
        for (Model model = this; model != null; model = model.getParent()) {
            String fileName = model.getName() + (printType == null ? "" : "-" + printType) + ".fr3";
            String basePath = env.getExpr("${.vars['web.root']}/print");
            File file = new File(basePath, fileName);
            if (file.exists()) {
                return file;
            }
            basePath = env.getExpr("${.vars['egov.conf']}/archive/print");
            try {
                file = ResourceUtils.getFile(basePath + "/" + fileName);
                if (file.exists()) {
                    return file;
                }
            } catch (FileNotFoundException ignored) {
                logger.error(ignored.getMessage());
            }
        }
        return null;
    }

    private synchronized void initFieldsMap() {
        fieldCache = new LinkedHashMap<String, Field>();
        inheritFieldCache = new LinkedHashMap<String, Field>();
        for (Field f : getFields()) {
            fieldCache.put(f.getName(), f);
        }
        for (Model model = this; model != null; model = model.getParent()) {
            for (Field f : model.getFields()) {
                if (!inheritFieldCache.containsKey(f.getName())) {
                    inheritFieldCache.put(f.getName(), new InheritField(f.getName(), model));
                }
            }
        }
    }
}
