package com.gtis.archive.core;

/**
 * 继承的Field对象，可以从field的parent中取值.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-27
 */
public class InheritField extends Field {
    private String fieldName;
    private Model model;

    public InheritField(String fieldName, Model model) {
        this.fieldName = fieldName;
        this.model = model;
    }

    @Override
    public String getName() {
        return fieldName;
    }

    public Model getModel() {
        return model;
    }

    @Override
    public String getDefaultValue() {
        return new InheritFieldValueGetter<String>(this) {
            @Override
            protected String getValue(Field f) {
                return f.getDefaultValue();
            }
        }.getValue();
    }

    @Override
    public Integer getLength() {
        return new InheritFieldValueGetter<Integer>(this) {
            @Override
            protected Integer getValue(Field f) {
                return f.getLength();
            }
        }.getValue();
    }

    @Override
    public Boolean getNullable() {
        return new InheritFieldValueGetter<Boolean>(this) {
            @Override
            protected Boolean getValue(Field f) {
                return f.getNullable();
            }
        }.getValue();
    }

    @Override
    public String getRemark() {
        return new InheritFieldValueGetter<String>(this) {
            @Override
            protected String getValue(Field f) {
                return f.getRemark();
            }
        }.getValue();
    }

    @Override
    public String getTitle() {
        return new InheritFieldValueGetter<String>(this) {
            @Override
            protected String getValue(Field f) {
                return f.getTitle();
            }
        }.getValue();
    }

    @Override
    public Type getType() {
        return new InheritFieldValueGetter<Type>(this) {
            @Override
            protected Type getValue(Field f) {
                return f.getType();
            }
        }.getValue();
    }

    @Override
    public String getValidation() {
        return new InheritFieldValueGetter<String>(this) {
            @Override
            protected String getValue(Field f) {
                return f.getValidation();
            }
        }.getValue();

    }

    @Override
    public Object getValue(final String value) {
        return new InheritFieldValueGetter<Object>(this) {
            @Override
            protected Object getValue(Field f) {
                return f.getValue(value);
            }
        }.getValue();
    }

    @Override
    public String getValueDict() {
        return new InheritFieldValueGetter<String>(this) {
            @Override
            protected String getValue(Field f) {
                return f.getValueDict();
            }
        }.getValue();
    }

    abstract class InheritFieldValueGetter<T> {
        private InheritField field;

        InheritFieldValueGetter(InheritField field) {
            this.field = field;
        }

        public T getValue() {
            for (Model m = field.getModel(); m != null; m = m.getParent()) {
                Field f = m.getField(field.getName());
                if (f != null) {
                    T value = getValue(f);
                    if (value != null) {
                        return value;
                    }
                }
            }
            return null;
        }

        protected abstract T getValue(Field f);
    }

}
