package com.gtis.archive.core;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-3
 */

public class Field {
    protected final Logger logger = LoggerFactory.getLogger(getClass());
    private String name;
    private String title;
    private String remark;
    private Type type;
    private Integer length;
    private Boolean nullable;
    private String valueDict;
    private String validation;
    private String defaultValue;
    private SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getNullable() {
        return nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getValidation() {
        return validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public String getValueDict() {
        return valueDict;
    }

    public void setValueDict(String valueDict) {
        this.valueDict = valueDict;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Field && name != null && name.equals(((Field) obj).getName());
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Object getValue(String value) {
        Object v = null;
        try {
            switch (getType()) {
                case TEXT:
                    v = value;
                    break;
                case NUMBER:
                    if(getLength() == null || getLength() <= 10){
                        v = Integer.valueOf(value);
                    }
                    else {
                        v = Long.valueOf(value);
                    }
                    break;
                case BOOLEAN:
                    v = Boolean.valueOf(value);
                    break;
                case DATE:
                    v = DATE_FORMAT.parse(value);
                    break;
                case DATETIME:
                    v = DATETIME_FORMAT.parse(value);
                    break;
                case FLOAT:
                    v = Double.valueOf(value);
                    break;
                default:
                    break;
            }
        } catch (ParseException ignored) {
            logger.error(ignored.getMessage());
        }
        return v;
    }

    public enum Type {
        TEXT, NUMBER, FLOAT, DATE, DATETIME, BOOLEAN
    }
}
