<@layout.html title="档案编辑接口" import="ext,jquery,base,main">
<style type="text/css">
    .add {
        background: url(/archive/img/add.gif) no-repeat 0 0 !important;
    }
    .delete {
        background: url(/archive/img/delete.gif) no-repeat 0 0 !important;
    }

    .edit {
        background: url(/archive/img/edit.gif) no-repeat 0 0 !important;
    }
    .printer {
        background: url(/archive/img/printer.gif) no-repeat 0 0 !important;
    }
    .archive {
        background: url(/archive/img/archive.png) no-repeat 0 0 !important;
    }
</style>
<div id="documentTpl">
</div>
<textarea style="display: none;" id="listContainerTpl">
    <table style="width:100%;" class="a-doc" cellpadding="0" cellspacing="0" >
        <caption>
            <a class="a-btn" href="#" onclick="return delDocument();">删除卷内</a>
            <a class="a-btn" href="#" onclick="return printDocumentList();">列表打印</a>
            <a class="a-btn" href="#" onclick="return editDocument();">修改卷内</a>
            <a class="a-btn" href="#" onclick="return showOriginal('','document');">原文管理</a>
            <a class="a-btn" href="#" onclick="return showDocument('','{archiveId}');">添加卷内</a>
        </caption>
        <tr>
            <th style="width:1px;"><input type="checkbox" onclick="changeSelect(this);" value=""></th>
            <#if docShowFields??>
                <#list docShowFields?keys as name>
                    <#assign width=docShowFields[name]['width']!-1/>
                    <th<#if width!=-1> style="width:${width}px;"</#if>>${(docFields[name].title)!}</th>
                </#list>
            <#else>
                <th>题名</th>
                <th>页号</th>
                <th>责任者</th>
                <th style="width:120px;">日期</th>
            </#if>
        </tr>
        <tpl for=".">
            <tr class='{[xindex%2==0?"even":"odd"]}'>
                <td style="width:1px;"><input type="checkbox" value="{id}"></td>
                <#if docShowFields??>
                    <#list docShowFields?keys as name>
                        <#assign fd=docShowFields[name]/>
                        <#assign max=fd['max']!-1/>
                        <td>
                            <#if name=='tm'>
                                <a href="#" onclick="return showDocument('{id}','{archiveId}');" >{tm:def("无题名"<#if max!=-1>,${max}</#if>)}</a>
                            <#else>
                                {${name}:<#if fd['date']??>renderDate("${fd['date']}")<#else>def<#if max!=-1>("",${max})</#if></#if>}
                            </#if>
                        </td>
                    </#list>
                <#else>
                    <td><a href="#" onclick="return showDocument('{id}','{archiveId}');">{tm:def("无题名",20)}</a></td>
                    <td>{yh:def}</td>
                    <td>{zrz:def}</td>
                    <td>{rq:def}</td>
                </#if>
            </tr>
        </tpl>
    </table>
</textarea>
<#--<div id="panelHolder"></div>-->
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript" src="js/ext/ux/ComboPageSize.js"></script>
<script type="text/javascript">
var _jsessionid = '${sessionId}',modelName = '${modelName}',jnModelName = '${modelName}_jn';
var id='${id}';
var docShowFields=getFileds('${docShowFields!}');
var docCols='${docColumns}';
var  docColumns=[];
var docWin,win;
var store;
function getJsessionidUrl(url) {
    var index = url.indexOf('?');
    if (index > -1) {
        return url.substring(0, index) + ';jsessionid=' + _jsessionid + url.substr(index);
    } else {
        return url + ';jsessionid=' + _jsessionid;
    }
}

    store= new Ext.data.JsonStore({
        url:'doc!list.action',
        totalProperty:'totalCount',
        root:'items',
        fields:docShowFields,
        baseParams:{modelName:jnModelName,archiveId:id}
    });
    store.load();

    var docOgSm = new Ext.grid.CheckboxSelectionModel();

//    var pageBar = new Ext.PagingToolbar({
//        plugins:new Ext.ux.ComboPageSize({ addToItem:false, prefixText:'每页', postfixText:'条'}),
//        pageSize:20,
//        store:store,
//        displayInfo:true,
//        displayMsg:'{0} - {1} 共 {2} 条',
//        emptyMsg:"没有记录返回"
//    });
    getColumn(docCols);
    var cols = new Ext.grid.ColumnModel(docColumns);

    var documnetGrid = new Ext.grid.EditorGridPanel({
        ds:store,
        autoHeight:true,
        layout:'fit',
        clicksToEdit : 1,
        sm:docOgSm,
//        bbar:pageBar,
        viewConfig:{
            forceFit:true
        },
        cm:cols,
        tbar:[
            {
                text:'添加',
                iconCls:'add',
                handler:function () {
                    showDocument('',id);
                }
            },
            {
                text:'修改',
                iconCls:'edit',
                handler:function () {
                    editDocument();
                }
            },
            {
                text:'删除',
                iconCls:'delete',
                handler:function () {
                    delDocument();
                }
            } ,
            {
                text:'列表打印',
                iconCls:'printer',
                handler:function(){
                    printDocumentList();
                }
            },
            {
                text:'插入卷内',
                iconCls:'edit',
                handler:function(){
                    insertDocument(id);
                }
            },
            {
                text:'原文管理',
                iconCls:'archive',
                handler:function(){
                    showOriginal('','document');
                }
            }
        ],
        listeners:{
//            rowdblclick:function (g, index, e) {
//            },
//            rowclick:function (g, index, e) {
//            },
//            isEditor:function(value,record){
//            },
            afterEdit:function(obj){
                updateCell(obj);
            }
},
        renderTo:"documentTpl"
    });


    function updateCell (obj){
        debugger;
        var changedField=obj.field;
        var changedValue=obj.value;
        var oldValue=obj.originalValue;
        var id=obj.record.id;
        Ext.Ajax.request({
            url:'gateway!updateDoc.action',
            params:{id:id,field:changedField,value:changedValue,modelName:modelName},
            success:function(r){
                var result=r.responseText;
                if(result!="success"){
                    alert(result);
                }
                //当修改成功之后只刷新这个单元格的值
                var index = store.find(changedField,changedValue);
                if(index == -1){
                    return;
                }
                var record = store.getAt(index);
                //修改值
                record.set(changedField,changedValue);
                record.commit();
                //store.reload() ;
            }
        });
    }

//Ext.onReady(function(){
    var viewPort = new Ext.Viewport({
        layout:'border',
        items:[
            {
                xtype:'panel',
                region:'center',
                margins:'5',
                split:true,
                layout:'accordion',
                items:[
                    {
                        xtype:'panel',
                        title:'档案信息',
                        buttons:[ {
                            text:'添加卷内',
                            handler:function(){
                                showDocument('',id);
                            }
                        },
                            {
                                text:'原文',
                                handler:function () {
//                                    showOriginal($('#archiveFrame')[0].contentWindow.getArchiveId(),'archive');
                                    showOriginal('${id}','archive');
                                }
                            },
                            {
                                text:'保存',
                                handler:function () {
                                   debugger;
                                    $('#archiveFrame')[0].contentWindow.doSubmit();
                                }
                            },{
                                text:'备考表',
                                handler:function(){
                                    showNote();
                                }
                            },{
                                text:'打印备考表',
                                handler:function(){
                                    printNote();
                                }
                            },{
                                text:'打印档案封面',
                                handler:function(){
                                    printArchiveCover();
                                }
                            }
                        ],
                        html:'<iframe name="archiveFrame" id="archiveFrame" src="archive-entity!render.action?template=template&modelName=${modelName}&id=${id}&state=${state}" scrolling="auto" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;"/>'
                    },
                    {
                        xtype:'panel',
                        title:'卷内信息',
                        region:'center',
                        margins:'5',
                        split:true,
                        layout:'accordion',
                        contentEl: 'documentTpl'
                    }
                ]
            }
        ]
    });


//    var tpl = Ext.XTemplate.from('listContainerTpl');

//    var dataView = new Ext.DataView({
//        store:store,
//        tpl:tpl,
//        autoHeight:true,
//        overClass:'x-view-over',
//        emptyText:'暂无记录',
//        itemSelector:'tr._item',
//        renderTo:'documentTpl'
//    });
//    store.load();

//});
function getColumn(rp){
    var showFields = Ext.decode(rp);
    var  result= showFields.result;

    if (docColumns != null) {
        docColumns = [];
    }
    docColumns.push(docOgSm);
    for (var i = 0; i < result.length; i++) {
        var column;
        if (result[i].fieldName == "state") {
            column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName, renderer:stateFormat};
        } else if (result[i].date != null) {
            column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName,editor:new Ext.form.TextField({
                allowBlank : true}), renderer:dateFormate};
        } else if (result[i].fieldName == "archiveId") {
            column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName, renderer:archvieFormate};
        } else {
            column = {header:result[i].title, sortable:true, width:result[i].width, dataIndex:result[i].fieldName,editor:new Ext.form.TextField({
                allowBlank : true})};
        }
        docColumns.push(column);
    }
}

    var dateFormate = function (date, o, p) {
        if (date == "") {
            return "----";
        } else {
            if (typeof  date == "string") {
                var d = new Date(Date.parse(date.replace(/-/g, "/")));
            } else {
                var d = new Date(date);
            }
            return Ext.util.Format.date(d.toString(), "Y年m月d日");
        }
    };

    var stateFormat = function (v, o, p) {
        if (v == 1) return "<img src=\"/archive/img/ygd.png\" alt=\"已归档\" title=\"已归档\" class='img' />";
        else return "<img src=\"/archive/img/wgd.png\" alt=\"未归档\" title=\"未归档\" class='img' />";
    }

    var archvieFormate = function (v, o, p) {
        if (v != null && v != "") return "<img src=\"/archive/img/ygd.png\" alt=\"已立卷\" title=\"已立卷\" class='img' />";
        else return "<img src=\"/archive/img/wgd.png\" alt=\"未立卷\" title=\"未立卷\" class='img' />";

    }




var ogDs, linkWin;

function showOriginal(archiveId,type) {
    var modelname=modelName;
    var ids;
    if(type=="document"){
        modelname=jnModelName;
        ids=getSelectIds();
        if (ids.length > 1 || ids.length == 0) {
            alert('请选择一个项目!');
            return false;
        }
        archiveId=ids;
    }

    ogDs = new Ext.data.JsonStore({
        url:'og!list.action?ownerId=' + archiveId,
        autoLoad:true,
        totalProperty:'totalCount',
        root:'items',
        fields:[
            'id', 'name', 'fileSize', 'updateTime'
        ]
    });
    var ogSm = new Ext.grid.CheckboxSelectionModel();
    var formatSize = function (size, p, record) {
        return Ext.util.Format.fileSize(size);
    };
    var ogGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:ogDs,
        height:250,
        sm:ogSm,
        loadMask:true,
        stripeRows:true,
        region:'center',
        bbar:new Ext.PagingToolbar({
            pageSize:20, //每页显示几条数据
            store:ogDs,
            displayInfo:true,
            displayMsg:'{0} - {1} 共 {2} 条',
            emptyMsg:"没有记录返回" }),
        cm:new Ext.grid.ColumnModel([
            //new Ext.grid.RowNumberer(),//显示行号
            ogSm,
            {header:"名称", width:400, sortable:true, dataIndex:'name'},
            {header:"大小", width:100, sortable:true, dataIndex:'fileSize', renderer:formatSize},
            {header:"上传时间", width:150, sortable:true, dataIndex:'updateTime'}
        ]),
        tbar:[
            {
                text:'查看',
                iconCls:'preview',
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    }
                    var nids = [];
                    for (var i = 0; i < ogSm.getSelections().length; i++) {
                        nids.push(ogSm.getSelections()[i].data.id);
                    }
                    showPreview(nids);
                }
            },
            {
                text:'上传',
                iconCls:'upload',
                handler:function () {
                    var getUrl = function (url) {
                        return getJsessionidUrl(url + '?modelName=' + modelname);
                    };
                    var uploadDialog = new UploadDialog({
                        getUrl:getUrl,
                        maxSize:5368709120,
                        typeDescription:'所有文件',
                        autoClose:this.autoClose || true,
                        fileTypes:'*.*'
                    });
                    uploadDialog.on('close', function () {
                        ogDs.reload();
                    });
                    uploadDialog.show(archiveId);
                }
            },
            {
                text:'打印',
                iconCls:'print',
                handler:function () {
                    var ssl = ogSm.getSelections().length;
                    if (ssl == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    } else if (ssl > 1) {
                        Ext.MessageBox.alert('提示', '　　只能选择一个原文!　　');
                        return;
                    }
                    showPrint(ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'下载',
                iconCls:'download',
                handler:function () {
                    var ssl = ogSm.getSelections().length;
                    if (ssl == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    } else if (ssl > 1) {
                        Ext.MessageBox.alert('提示', '　　只能选择一个原文!　　');
                        return;
                    }
                    window.open('og!get.action?preview=false&id=' + ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'权限',
                iconCls:'edit',
            hidden:true,
                handler:function () {
//                    if (ogSm.getSelections().length == 0) {
//                        Ext.MessageBox.alert('提示', '　没有原文被选择!　');
//                        return;
//                    }
//                    setPermission(ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'删除',
                iconCls:'delete',
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        alert('　　没有原文被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(ogSm.getSelections(), function (s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url:'og!remove.action',
                        params:{id:p},
                        success:function (r) {
                            ogDs.reload();
                        }
                    });
                }
            },
            '->'/*,
            new Ext.ux.form.SearchField({
                id:'searchBox1',
                style:{'margin':'0,0,0,150px'},
                store:ogDs,
                width:150,
                renderTo:'searchBox'
            })*/
        ],
        listeners:{
            rowdblclick:function (g, index, e) {
                if (true) {
                    var id = ogDs.getAt(index).id;
                    showPreview([id]);
                }
            },
            render:function (g) {
                var store = g.getStore();
                var view = g.getView();
                g.tip = new Archive.OgTip({
                    dismissDelay:0,
                    target:view.mainBody,
                    delegate:'.x-grid3-row',
                    autoWidth:!Ext.isIE6,
                    renderTo:document.body,
                    listeners:{
                        beforeshow:function (tip) {
                            var rowIndex = view.findRowIndex(tip.triggerElement);
                            tip.body.update('<img src="' + 'og!thumb.action?modelName=' + modelName + '&id=' + store.getAt(rowIndex).id + '"/>');
                        }
                    }
                });
            }
        }
    });
    var ogWin = new Ext.Window({
        title:'原文',
        closable:false,
        modal:true,
        width:700,
        height:500,
        layout:'fit',
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    ogWin.close();
//                    $('#archiveFrame')[0].contentWindow.doSubmit();
                }
            }
        ],
        items:ogGrid
    });
    ogWin.show();
    return false;
}


function showPreview(nids) {
    if (!Ext.isDefined(window.hasEPreOcx)) {
        try {
            new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
            window.hasEPreOcx = true;
        } catch (e) {
            window.hasEPreOcx = false;
        }
    }
    if (window.hasEPreOcx) {
        var base = location.href.substring(0, location.href.lastIndexOf('/'));
        var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
        link = link.substr(link.indexOf('//') + 2);
        Ext.Ajax.request({
            url:'archive!cacheIds.action',
            params:{id:nids},
            success:function (r) {
                var json = Ext.decode(r.responseText);
                location.href = 'epre://'+link + json['idsKey'];
            }
        });
    } else {
        window.open('og!get.action?preview=true&id=' + nids[0]);
    }
}

function showPrint(id) {
    var width = 0, height = 0, srcWidth, srcHeight;
    var win = new Ext.Window({
        cls:'og',
        title:'打印原文',
        closable:true,
        modal:true,
        width:Ext.lib.Dom.getViewWidth() * .9,
        height:Ext.lib.Dom.getViewHeight() * .9,
        border:false,
        resizable:false,
        tbar:[
            {
                text:'打印',
                iconCls:'print',
                handler:function () {
                    var print = Ext.getDom('printFrame').contentWindow.webPrint;
                    var link = location.href;
                    print.ContentURL = getJsessionidUrl(link.substring(0, link.lastIndexOf('/')) + '/og!print.action?id=' + id + (width > 0 ? '&width=' + width : '') + (height ? '&height=' + height : ''));
                    print.marginBottom = print.marginLeft = print.marginRight = print.marginTop = 0;
                    print.Preview();
                }
            },
            {
                text:'放大',
                iconCls:'zoom-out',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 1.2;
                    img.height = height = height * 1.2;
                }
            },
            {
                text:'缩小',
                iconCls:'zoom-in',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 0.8;
                    img.height = height = height * 0.8;
                }
            },
            {
                text:'默认大小',
                iconCls:'reset',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    img.width = width = srcWidth;
                    img.height = height = srcHeight;
                }
            }
        ],
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="auto" frameborder="0" style="width:100%;height:100%;" src="og!print.action?id=' + id + '" id="printFrame"></iframe>'
    });
    win.show();
    return false;
}
function getSelectIds() {
    var nids = [];
    for (var i = 0; i < docOgSm.getSelections().length; i++) {
        nids.push(docOgSm.getSelections()[i].data.id);
    }
    return nids;
//    var ids = [];
//    var ct ="#documentTpl";
//    $(ct + ' [type="checkbox"]').each(function () {
//        if ($(this).attr("checked")) {
//            if (this.value)
//                ids.push(this.value);
//        }
//    });
//    return ids;
}

function getFileds(value){
    var files=[];
    if(!value==""&&value!=null){
        var temp=value.split("=");
        for(var i=0;i<temp.length-1;i++){
            if(i==0){
                files.push(temp[i].substring(1,temp[i].length).trim());
            }else{
                files.push(temp[i].substring(temp[i].lastIndexOf(",")+1,temp[i].length).trim());
            }
        }
        files.push('id');
    } else{
        files=['id','tm','yh','zrz','rq'];
    }
    return files;
}

function delDocument() {
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个卷内!');
    }
    else {
        if (confirm('确定要删除吗？')) {
            Ext.Ajax.request({
                url:'doc!remove.action?modelName=' + jnModelName,
                params:{id:ids},
                success:function (r) {
                    store.load();
                }
            });
        }
    }
}

function printDocumentList() {
    var printType= window.localStorage.printType;
    var localPath=window.localStorage.localPath;
    var base = location.href.substring(0, location.href.lastIndexOf('/'));
    var  printUrl;
    var dataUrl = getJsessionidUrl(base + '/doc!print.action?modelName=' + jnModelName + '&archiveId=' + id);
    if(printType=="Local"&&localPath==null) return alert("未设置本地模板路径，请检查!");
    if(printType==null||printType=="Local"){
        if(fileExist(localPath+jnModelName+".fr3")){
            printUrl = localPath+jnModelName+".fr3";
        }else if(fileExist(localPath+"document.fr3")){
            printUrl = localPath+"document.fr3";
        }else{
            return alert("请检查本地模版是否存在");
        }
    }else{
        printUrl = getJsessionidUrl(base + '/doc!fr3.action?modelName=' + jnModelName);
    }

//    var printUrl = getJsessionidUrl(base + '/doc!fr3.action?modelName=' + jnModelName);
    location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
//    }
}

function editDocument() {
    var ids = getSelectIds();
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个卷内!');
    }
    else {
        showDocument(ids.pop(), id);
    }
}

function showDocument(documentId, archiveId) {
    if(archiveId==""||archiveId==null)
        archiveId=id;
    docWin = new Ext.Window({
        title:documentId ? '编辑卷内' : '添加卷内',
        closable:true,
        modal:true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'保存',
                handler:function () {
                    window.archiveId = archiveId;
                    $('#documentFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    docWin.close();
                    store.load();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="doc-entity.action?modelName=' + jnModelName + (documentId ? '&id=' + documentId : '') + (archiveId ? '&archiveId=' + archiveId : '') + '" id="documentFrame"></iframe>'
    });
    docWin.show();
    return false;
}

/**
 * 打印封皮
 */
function printArchiveCover(){
    var base = location.href.substring(0, location.href.lastIndexOf('/'));
    var  printUrl;
    var printType= window.localStorage.printType;
    var localPath=window.localStorage.localPath;
    if(printType=="Local"&&localPath==null) return alert("未设置本地模板路径请检查！");
    if(printType==null||printType=="Local"){
        if(fileExist(localPath+modelName+"-cover.fr3")){
            printUrl =localPath+modelName+"-cover.fr3";
        }else if(fileExist(localPath+"archive-cover.fr3")){
            printUrl = localPath+"archive-cover.fr3";
        }else{
            return alert("请检查本地模版是否存在");
        }
    }else{
        printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);
    }
//    var printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);
    var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName )+'&idsKey=';
    Ext.Ajax.request({
        url:'archive!cacheIds.action',
        params:{id:id},
        success:function (r) {
            var key = Ext.decode(r.responseText);
            location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl+key['idsKey'];
        }
    });
}

function showNote() {
    win = new Ext.Window({
        title: '编辑备考表',
        closable:true,
        modal:true,
        width:400,
        height:280,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'保存',
                handler:function () {

                    window.archiveId = id;
                    $('#noteFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="note-entity.action?modelName=Note' + ( '&archiveId=' + id ) + '" id="noteFrame"></iframe>'
    });
    win.show();
    return false;

}

function printNote(){
    var printType= window.localStorage.printType;
    var localPath=window.localStorage.localPath;
    var printUrl;
    var base = location.href.substring(0, location.href.lastIndexOf('/'));
    if(printType=="Local"&&localPath==null) return alert("未设置本地打印模板的路径请检查！");
    if(printType==null||printType=="Local"){
        printUrl = localPath+"note.fr3";
    }else{
        printUrl = getJsessionidUrl(base + '/note!fr3.action?modelName=Note');
    }
    var param = {start:0,limit:1,archiveId:id};
//    var printUrl = getJsessionidUrl(base + '/note!fr3.action?modelName=Note');
    var dataUrl = getJsessionidUrl(base + '/note!print.action?modelName=Note&' + Ext.urlEncode(param));
    location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
}




function onComplete(result, msg) {
    win.close();
    if (!result) {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    } else {
        Ext.MessageBox.alert('成功', '　　' + msg + '　　');
    }
}

/**
 *  插入卷内
 * @param archiveId
 */
function insertDocument(archiveId){
    var ids = getSelectIds(archiveId);
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择在何处插入!');
    }else {
        docWin = new Ext.Window({
            title: '插入卷内',
            closable:true,
            modal:true,
            width:400,
            height:320,
            border:false,
            resizable:false,
            buttons:[
                {
                    text:'保存',
                    handler:function () {
                        window.archiveId = archiveId;
                        $('#documentFrame')[0].contentWindow.doSubmit();
                    }
                },
                {
                    text:'关闭',
                    handler:function () {
                        docWin.close();
                    }
                }
            ],
            html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="doc-entity.action?modelName=' + jnModelName  + (archiveId ? '&archiveId=' + archiveId : '')+'&insertId='+ids[0] + '" id="documentFrame"></iframe>'
        });
        docWin.show();
        return false;
    }
}

function onDocumentComplete(result, msg) {
    docWin.close();
    if (result) {
            store.reload();
        Ext.MessageBox.alert('成功', '　　' + msg + '　　');
    } else {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    }
}



function onResize(w, h ) {
    if(docWin!=null){
     docWin.setWidth(w + 40);
     docWin.setHeight(h + 90);
     docWin.center();
    }
}

function onArchiveComplete(result, msg) {
    if (result) {

        Ext.MessageBox.alert('提示','保存成功');
        setTimeout(function () {
            archiveFrame.window.location.href="archive-entity!render.action?template=template&modelName=${modelName}&id=${id}&state=${state}";
        }, 500);
    } else {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    }
}

/**
 * 验证本地文件是否存在
 */
function fileExist(filePath){
    var fso =new ActiveXObject("Scripting.FileSystemObject");
    if (fso.FileExists(filePath))
        return true;
    return false;
}
</script>
</@layout.html>