/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web.admin;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MlhAction
extends ActionSupport {
    private Logger logger = LoggerFactory.getLogger(MlhAction.class);
    @Autowired
    private SysUserService userService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private ModelService modelService;
    private int start = 0;
    private int limit = 30;
    private AjhRange ajhRange;
    private String msg;
    private Map<String, String> modelsMap;

    public String execute() throws Exception {
        this.modelsMap = new HashMap();
        for (Model model : this.modelService.getModels()) {
            this.modelsMap.put(model.getName(), model.getTitle());
        }
        return super.execute();
    }

    public String list() {
        Order[] orders = new Order[]{Order.asc((String)"dwdm"), Order.asc((String)"modelName"), Order.asc((String)"mlh")};
        try {
            if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                Page ajhRanges = this.ajhRangeService.getAjhRangesOrderMlh(this.start, this.limit, "asc");
                Struts2Utils.renderJson((Object)ajhRanges, (String[])new String[0]);
            } else {
                Page ajhRanges = this.ajhRangeService.getAjhRanges(this.start, this.limit, orders);
                Struts2Utils.renderJson((Object)ajhRanges, (String[])new String[0]);
            }
        }
        catch (Exception ex) {
            Struts2Utils.renderJson((Object)new Page(), (String[])new String[0]);
        }
        return null;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public AjhRange getAjhRange() {
        return this.ajhRange;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getTab() {
        return "mlh";
    }

    public List<String> getModels() {
        ArrayList<String> list = new ArrayList<String>();
        for (Model model : this.modelService.getModels()) {
            list.add(model.getName());
        }
        return list;
    }

    public String getModelsMap() {
        return JSON.toJSON((Object)this.modelsMap).toString();
    }

    public String edit() throws Exception {
        if (this.ajhRange != null) {
            if (this.ajhRange.getCurrentValue() < this.ajhRange.getMinValue()) {
                this.ajhRange.setCurrentValue(this.ajhRange.getMinValue());
            }
            if (StringUtils.isBlank((String)this.ajhRange.getId())) {
                this.ajhRange.setId(null);
            }
            if (this.ajhRange.getModelName().indexOf(",") == 0) {
                this.ajhRange.setModelName(this.ajhRange.getModelName().substring(1, this.ajhRange.getModelName().length()));
            }
            StringBuilder sb = new StringBuilder();
            String[] models = this.ajhRange.getModelName().split(",");
            LinkedList<String> list = new LinkedList<String>();
            for (String model : models) {
                if (list.contains(model.trim())) continue;
                list.add(model.trim());
            }
            for (int i = 0; i < list.size(); ++i) {
                if (i == list.size() - 1) {
                    sb.append((String)list.get(i));
                    continue;
                }
                sb.append((String)list.get(i) + ",");
            }
            this.ajhRange.setModelName(sb.toString());
            this.ajhRangeService.saveAjhRange(this.ajhRange);
            this.msg = "successed";
        }
        return "edit";
    }

    public String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }
}

