/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.OriginalPermission;
import com.gtis.archive.service.OriginalPermissionService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;

@InterceptorRefs(value={@InterceptorRef(value="fileUpload", params={"maximumSize", "5368709120"}), @InterceptorRef(value="defaultStack")})
public class OgAction
extends BaseModelAction<Original> {
    private static final Logger logger = LoggerFactory.getLogger(OgAction.class);
    @Autowired
    private OriginalService originalService;
    @Autowired
    private OriginalPermissionService originalPermissionService;
    @Autowired
    private SysUserService sysUserService;
    private String ownerId;
    private boolean preview;
    private File filedata;
    private String filename;
    private OriginalPermission op;
    private String action = "download";

    public void setNid(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setFiledata(File filedata) {
        this.filedata = filedata;
    }

    public void setFile(File filedata) {
        this.filedata = filedata;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFileFileName(String filename) {
        this.filename = filename;
    }

    public void setOp(OriginalPermission op) {
        this.op = op;
    }

    public OriginalPermission getOp() {
        return this.op;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String remove() throws Exception {
        this.originalService.removeOriginal(this.ids);
        return null;
    }

    public String check() {
        Struts2Utils.renderHtml((String)"{}", (String[])new String[0]);
        return null;
    }

    public String get() throws Exception {
        try {
            String id = this.getId();
            if (!this.originalPermissionService.hasOriginalPermission(id) && !this.preview) {
                return null;
            }
            HttpServletResponse response = ServletActionContext.getResponse();
            Original original = this.originalService.getOriginal(id);
            if (original.isImage()) {
                response.setContentType("image/" + original.getExtension());
            } else if (original.isXOffice()) {
                response.setContentType("application/vnd.openxmlformats");
            } else if (original.isPDF()) {
                response.setContentType("application/pdf");
            } else {
                response.setContentType("application/octet-stream");
            }
            response.setHeader("Content-Disposition", (this.preview ? "inline" : "attachment") + "; filename=\"" + new String(original.getName().getBytes("gbk"), "iso8859-1") + "\"");
            this.sendFile(this.originalService.getOriginalFile(id, this.action));
        }
        catch (Throwable e) {
            logger.error("Get error", e);
        }
        return null;
    }

    public String getBatch() throws Exception {
        byte[] buffer = new byte[1024];
        String fileName = System.currentTimeMillis() + ".zip";
        String mapKey = "originalRoot";
        Map map = EnvHolder.getAppEnv().getProps();
        for (String key : map.keySet()) {
            if (!key.contains("originalRoot") || EnvHolder.getAppEnv().getProps().get(key) == null) continue;
            mapKey = key;
            break;
        }
        String zipPath = EnvHolder.getAppEnv().getExpr(EnvHolder.getAppEnv().getProps().get(mapKey).toString()) + "/tempZip/" + fileName;
        String zipRootPath = EnvHolder.getAppEnv().getExpr(EnvHolder.getAppEnv().getProps().get(mapKey).toString()) + "/tempZip/";
        File tempFile = new File(zipRootPath);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipPath));
        for (String id : this.ids[0].split(",")) {
            int len;
            File file = this.originalService.getOriginalFile(id, this.action);
            FileInputStream fis = new FileInputStream(file);
            zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
            while ((len = fis.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, len);
            }
            zipOutputStream.closeEntry();
            fis.close();
        }
        zipOutputStream.close();
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", (this.preview ? "inline" : "attachment") + "; filename=\"" + new String(fileName.getBytes("gbk"), "iso8859-1") + "\"");
        this.sendFile(new File(zipPath));
        File file = new File(zipPath);
        if (file.exists()) {
            file.delete();
        }
        return null;
    }

    public String preview() throws Exception {
        List ogs = this.getEntities();
        Document doc = DocumentHelper.createDocument();
        Element files = doc.addElement("files");
        String id = this.getId();
        String baseUrl = "${.vars['archive.url']}/og!get.action;jsessionid=" + ServletActionContext.getRequest().getSession().getId() + "?preview=true&id=";
        for (Original og : ogs) {
            String url = EnvHolder.getAppEnv().getExpr(baseUrl + og.getId());
            Element file = files.addElement("file").addAttribute("name", og.getName()).addAttribute("url", url);
            if (!og.getId().equals(id)) continue;
            file.addAttribute("iscurrent", "true");
        }
        Struts2Utils.renderXml((String)doc.asXML(), (String[])new String[0]);
        return null;
    }

    public String upload() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            if (this.filename == null) {
                throw new RuntimeException("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u540d\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            Original original = new Original();
            original.setOwnerId(this.ownerId);
            original.setName(URLDecoder.decode(this.filename, "UTF-8"));
            this.originalService.saveOriginalFile(original, this.filedata, false, this.modelName);
            this.originalService.saveOriginal(original);
            map.put("type", 0);
        }
        catch (Exception e) {
            map.put("type", 5);
            logger.error("upload error", (Throwable)e);
        }
        if (this.filedata != null) {
            this.filedata.delete();
        }
        this.renderJson(map);
        return null;
    }

    public String thumb() throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        Original original = this.originalService.getOriginal(this.getId());
        response.setContentType("image/" + original.getExtension());
        File file = this.originalService.getOriginalThumbFile(original.getId());
        if (file != null && file.exists()) {
            this.sendFile(file);
        } else {
            response.sendRedirect("img/no-thumb.gif");
        }
        return null;
    }

    public String print() throws Exception {
        return "print";
    }

    public String listPermission() {
        List ops = this.originalPermissionService.getOriginalPermissions(this.getId());
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("items", ops);
        Struts2Utils.renderJson(map, (String[])new String[0]);
        return null;
    }

    public String listUsers() {
        List list = this.sysUserService.getAllUsers();
        ArrayList users = new ArrayList(list.size());
        for (PfUserVo user : list) {
            if (StringUtils.isNotBlank((String)this.query) && !user.getUserName().contains(this.query)) continue;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("userId", user.getUserId());
            map.put("userName", user.getUserName());
            users.add(map);
        }
        Struts2Utils.renderJson(users, (String[])new String[0]);
        return null;
    }

    public String addPermission() {
        this.originalPermissionService.saveOriginalPermission(this.op);
        return this.renderSuccess();
    }

    public String removePermission() {
        for (String id : this.ids) {
            this.originalPermissionService.removeOriginalPermission(id);
        }
        return this.renderSuccess();
    }

    public String link() {
        String id = this.getId();
        ArrayList list = new ArrayList();
        try {
            File root = ResourceUtils.getFile((String)EnvHolder.getAppEnv().get((Object)"myOriginalPath"));
            File path = ResourceUtils.getFile((String)(root.getAbsolutePath() + "/" + ("root".equals(id) ? "" : id)));
            for (File f : path.listFiles()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", f.getAbsolutePath().substring(root.getAbsolutePath().length() + 1));
                map.put("text", f.getName());
                map.put("leaf", !f.isDirectory());
                map.put("checked", false);
                list.add(map);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u9519\u8bef,linkOriginalPath\u6ca1\u6709\u8bbe\u7f6e,\u65e0\u6cd5\u5173\u8054\u6587\u4ef6", (Object)e.getMessage());
        }
        Struts2Utils.renderJson(list, (String[])new String[0]);
        return null;
    }

    public String saveLink() {
        List originals = this.originalService.getOriginals(this.ownerId);
        HashSet<String> ogNames = new HashSet<String>();
        for (Original og : this.originalService.getOriginals(this.ownerId)) {
            ogNames.add(og.getPath());
        }
        try {
            File root = ResourceUtils.getFile((String)EnvHolder.getAppEnv().get((Object)"myOriginalPath"));
            for (String id : this.ids) {
                String path;
                File file = new File(root, id);
                if (file.isDirectory() || ogNames.contains(path = "${myOriginalPath}/" + file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1))) continue;
                Original original = new Original();
                original.setName(file.getName());
                original.setPath(path);
                original.setFileSize(file.length());
                original.setOwnerId(this.ownerId);
                this.originalService.saveOriginal(original);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected Page<Original> searchEntity(List<Criterion> criterions, List<Order> orders) {
        return this.originalService.searchOriginal(this.ownerId, this.query, this.start, this.limit);
    }

    public String allIds() {
        if (StringUtils.isBlank((String)this.ownerId)) {
            return null;
        }
        Struts2Utils.renderJson((Object)this.originalService.getIds(this.ownerId), (String[])new String[0]);
        return null;
    }
}

