/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.CheckLog;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.CheckLogService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CheckAction
extends BaseModelAction<Object> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    @Autowired
    private CheckLogService checkLogService;
    private AjhRange ajhRange;
    private Integer sbjh;
    private String linkField;
    private String nd;
    private String archiveId;
    private String modelName;
    private String treeId;
    private String tplName;
    private String status;
    private String printType;
    private Boolean isPrint = false;
    private String itemId;
    private List<Item> operations;
    private List<Map<String, Object>> tree;

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setTplName(String tplName) {
        this.tplName = tplName;
    }

    public String getTreeJson() throws JSONException {
        List listTree = this.treeService.getTree(this.treeId);
        List newTree = null;
        Item item = this.dictService.getItem(this.itemId);
        if (item != null && item.getRemark() != null && StringUtils.isNotBlank((String)item.getRemark().toString())) {
            String remark = item.getRemark().toString();
            JSONObject job = JSON.parseObject((String)remark);
            JSONArray array = job.getJSONArray("items");
            ArrayList<String> resIds = new ArrayList<String>();
            for (int i = 0; i < array.size(); ++i) {
                String resId = ((JSONObject)array.get(i)).get((Object)"id").toString();
                if (resIds.contains(resId)) continue;
                resIds.add(resId);
            }
            newTree = this.rewriteMap(listTree, resIds);
        }
        return JSON.toJSONString(newTree);
    }

    private List<Map<String, Object>> rewriteMap(List<Map<String, Object>> listTree, List<String> resIds) {
        ArrayList<Map<String, Object>> parentList = new ArrayList<Map<String, Object>>();
        if (listTree != null) {
            for (Map<String, Object> tree : listTree) {
                List childrenList = this.rewriteMap((List)tree.get("children"), resIds);
                String id = (String)tree.get("id");
                if (!resIds.contains(id) && childrenList.size() == 0) continue;
                tree.put("children", childrenList);
                parentList.add(tree);
            }
        }
        return parentList;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getPrintType() {
        return this.printType;
    }

    public void setPrintType(String printType) {
        this.printType = printType;
    }

    public void setId(String[] ids) {
        this.ids = ids;
    }

    public void setStart(int start) {
        super.setStart(start);
    }

    public String getNd() {
        return this.nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public String getArchiveId() {
        return this.archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Map getShowFields() {
        Map showFields = null;
        try {
            showFields = super.getShowFields();
        }
        catch (TemplateNotFoundException ex) {
            this.logger.error(ex.getMessage());
        }
        return showFields;
    }

    protected String[] getQueryFields() {
        String[] qFields = null;
        try {
            qFields = super.getQueryFields();
        }
        catch (TemplateNotFoundException ex) {
            this.logger.error(ex.getMessage());
        }
        return qFields;
    }

    public List<Map<String, Object>> getTree() {
        if (this.tree == null) {
            List listTree = this.treeService.getTree(null, new String[]{"model"});
            for (Map item : listTree) {
                this.logger.debug(item.toString());
                if (!item.get("name").equals("generic")) continue;
                listTree.remove(item);
                break;
            }
            this.tree = listTree;
        }
        return this.tree;
    }

    public String execute() {
        if (this.treeId == null) {
            Resource res = this.resourceService.findChildResource(null, "generic", new String[]{"model"});
            this.treeId = res.getId();
        }
        this.operations = this.dictService.getItems("hcPerm");
        return "success";
    }

    public String tpl() {
        try {
            if (this.tplName.indexOf("list") > -1) {
                try {
                    this.renderModelTemplate(this.tplName);
                }
                catch (TemplateNotFoundException e) {
                    this.renderModelTemplate("Generic-list");
                }
            } else {
                this.renderModelTemplate(this.tplName);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    private List orderEntities() {
        ArrayList<Object> entities = new ArrayList<Object>();
        for (String id : this.ids) {
            Object entity = this.entityService.load(this.modelName, id);
            entities.add(entity);
        }
        return this.addAll(entities, null, null);
    }

    private Page<Object> searchEntityAll(List<Criterion> criterions, List<Order> orders) {
        ArrayList<Criterion> list = new ArrayList<Criterion>(criterions);
        if (EnvHolder.isEnable((String)"dwdm.enable") && !SessionUtil.getCurrentUser().isAdmin()) {
            try {
                boolean hasDwdm = PropertyUtils.getProperty((Object)this.entityService.newInstance(this.modelName), (String)"dwdm") == null;
                list.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"dwdm"), (Criterion)Restrictions.eq((String)"dwdm", (Object)this.getDwdm())));
            }
            catch (Exception ex) {
                this.logger.error(ex.toString() + "{\u8be5\u4e1a\u52a1\u6ca1\u6709\u8bbe\u7f6e\u5355\u4f4d\u4ee3\u7801}");
            }
        }
        Page page = new Page();
        List all = this.addAll(this.entityService.search("ythsw", list, orders, this.start, this.limit).getItems(), this.entityService.search("ythfw", list, orders, this.start, this.limit).getItems(), this.entityService.search("ythnw", list, orders, this.start, this.limit).getItems());
        int totalCount = all.size();
        page.setItems(all);
        page.setTotalCount(totalCount);
        return page;
    }

    private String getCheckDwdm() {
        if (StringUtils.isNotBlank((String)this.itemId)) {
            Item item = this.dictService.getItem(this.itemId);
            return item.getValue();
        }
        return null;
    }

    protected Page<Object> searchEntity(List<Criterion> criterions, List<Order> orders) {
        ArrayList<Criterion> list = new ArrayList<Criterion>(criterions);
        if (EnvHolder.isEnable((String)"dwdm.enable") && !SessionUtil.getCurrentUser().isAdmin()) {
            try {
                list.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"dwdm"), (Criterion)Restrictions.eq((String)"dwdm", (Object)this.getCheckDwdm())));
            }
            catch (Exception ex) {
                this.logger.error(ex.toString() + "{\u8be5\u4e1a\u52a1\u6ca1\u6709\u8bbe\u7f6e\u5355\u4f4d\u4ee3\u7801}");
            }
        }
        if (this.modelName.equals("ygd") || this.modelName.equals("pgd")) {
            list.add((Criterion)Restrictions.eq((String)"status", (Object)this.modelName));
            Page page = new Page();
            List all = this.ygdSort(this.entityService.search("ythsw", list, orders, this.start, this.limit).getItems(), this.entityService.search("ythfw", list, orders, this.start, this.limit).getItems(), this.entityService.search("ythnw", list, orders, this.start, this.limit).getItems());
            int totalCount = all.size();
            page.setItems(all);
            page.setTotalCount(totalCount);
            return page;
        }
        if (this.isPrint.booleanValue()) {
            return this.entityService.search(this.modelName, list, orders, this.start, this.limit);
        }
        Page page = this.entityService.search(this.modelName, list, orders, this.start, this.limit);
        List lists = page.getItems();
        for (Object object : lists) {
            try {
                String id = PropertyUtils.getProperty(object, (String)"id").toString();
                PropertyUtils.setProperty(object, (String)"hasOriginal", (Object)this.originalService.hasOriginal(id));
            }
            catch (Exception e) {
                break;
            }
        }
        return page;
    }

    private List ygdSort(List ythSw, List ythFw, List ythNw) {
        ArrayList tempList = new ArrayList();
        if (ythSw != null) {
            tempList.addAll(ythSw);
        }
        if (ythFw != null) {
            tempList.addAll(ythFw);
        }
        if (ythNw != null) {
            tempList.addAll(ythNw);
        }
        Collections.sort(tempList, new /* Unavailable Anonymous Inner Class!! */);
        return tempList;
    }

    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (StringUtils.isNotBlank((String)this.status)) {
            criterions.add((Criterion)Restrictions.eq((String)"status", (Object)this.status));
        }
        return super.createCriterions(criterions);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Model getEntityModel() {
        if (this.modelName.equals("ygd") || this.modelName.equals("pgd")) {
            return this.modelService.getModel("ythsw");
        }
        return this.modelService.getModel(this.modelName);
    }

    public String getLinkField() {
        if (this.linkField == null) {
            try {
                this.linkField = this.archiveService.getArchiveModel(this.modelName).getTemplate("linkField");
            }
            catch (Exception ex) {
                this.linkField = "tm";
            }
        }
        return this.linkField;
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    private List addAll(List ythSw, List ythFw, List ythNw) {
        ArrayList tempList = new ArrayList();
        if (ythSw != null) {
            tempList.addAll(ythSw);
        }
        if (ythFw != null) {
            tempList.addAll(ythFw);
        }
        if (ythNw != null) {
            tempList.addAll(ythNw);
        }
        Collections.sort(tempList, new /* Unavailable Anonymous Inner Class!! */);
        return tempList;
    }

    public String searchIds() {
        List criterions = this.createCriterions(new ArrayList());
        List orders = this.createOrders(new ArrayList());
        List items = this.entityService.search(this.modelName, criterions, orders, this.start, this.limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), (String)"id") + ",");
                continue;
            }
            catch (Exception e) {
                this.logger.error(e.toString());
            }
        }
        this.ids = sb.toString().split(",");
        return this.cacheIds();
    }

    public String getPermJson() {
        Item huchaItem;
        HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
        if (StringUtils.isNotBlank((String)this.itemId) && StringUtils.isNotBlank((String)(huchaItem = this.dictService.getItem(this.itemId)).getRemark())) {
            String remark = huchaItem.getRemark().toString();
            JSONObject jsonObject = JSON.parseObject((String)remark);
            JSONArray items = (JSONArray)jsonObject.get((Object)"items");
            for (int i = 0; i < items.size(); ++i) {
                String id = ((JSONObject)items.get(i)).get((Object)"id").toString();
                String huchaPerm = ((JSONObject)items.get(i)).get((Object)"perm").toString();
                if (!id.equals(this.treeId)) continue;
                if (this.operations == null) {
                    this.operations = this.dictService.getItems("hcPerm");
                }
                for (Item item : this.operations) {
                    if (!item.getName().equals(huchaPerm)) continue;
                    perm.put(item.getName(), true);
                }
            }
        }
        this.renderJson(perm);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addCheckLog() {
        CheckLog checkLog = new CheckLog();
        String qlr = "";
        Archive archive = null;
        if ("ythsw".equals(this.modelName)) {
            Object entity = this.entityService.load(this.modelName, this.archiveId);
            checkLog.setUserName(this.userService.getUserVo(SessionUtil.getCurrentUserId()).getUserName());
            checkLog.setModelName(this.modelName);
            checkLog.setArchiveId(this.archiveId);
            checkLog.setCreateAt(new Date());
            try {
                checkLog.setQzh((String)PropertyUtils.getProperty((Object)entity, (String)"qzh"));
                checkLog.setTm((String)PropertyUtils.getProperty((Object)entity, (String)"tm"));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        } else {
            archive = this.archiveService.getArchive(this.modelName, this.archiveId);
            checkLog.setUserName(this.userService.getUserVo(SessionUtil.getCurrentUserId()).getUserName());
            checkLog.setModelName(this.modelName);
            checkLog.setArchiveId(this.archiveId);
            checkLog.setCreateAt(new Date());
            checkLog.setQzh(archive.getQzh());
            checkLog.setMlh(archive.getMlh());
            checkLog.setAjh(String.valueOf(archive.getAjh()));
            checkLog.setTm(archive.getTm());
            try {
                qlr = !"".equals(PropertyUtils.getProperty((Object)archive, (String)"qlrmc")) ? (String)PropertyUtils.getProperty((Object)archive, (String)"qlrmc") : "";
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException e) {
            }
            finally {
                checkLog.setQlr(qlr);
            }
        }
        this.checkLogService.saveCheckLog(checkLog);
        return this.renderJson((Object)"");
    }

    static /* synthetic */ Logger access$000(CheckAction x0) {
        return x0.logger;
    }
}

