/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

public class BorrowAction
extends BaseModelAction<Archive> {
    @Autowired
    private LoanService loanService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private SysUserService userService;
    private String archiveType;
    private String idString;
    private String id;
    private String archiveIds;

    public String getArchiveType() {
        return this.archiveType;
    }

    public void setArchiveType(String archiveType) {
        this.archiveType = archiveType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public String getArchiveIds() {
        return this.archiveIds;
    }

    public void setArchiveIds(String archiveIds) {
        this.archiveIds = archiveIds;
    }

    public List<LoanCart> getLoanCar() {
        ArrayList<LoanCart> entities = new ArrayList<LoanCart>();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (!"".equals(this.idString)) {
            Date date = new Date();
            for (String id : this.idString.split(",")) {
                String tmValue;
                String loanTm;
                LoanCart lc = new LoanCart();
                lc.setArchiveId(id.trim());
                lc.setUserId(userInfo.getId());
                lc.setArchiveType(this.archiveType);
                lc.setInDate(date);
                lc.setDwdm(this.getDwdm());
                if (this.archiveType.indexOf("_jn") != -1) {
                    Document document = (Document)this.entityService.load(this.archiveType, id.trim());
                    lc.setSxh(document.getSxh());
                    if (document.getArchive() != null || document.getArchiveId() != null) {
                        Archive archive;
                        Archive archive2 = archive = document.getArchive() == null ? (Archive)this.entityService.load(Archive.class, document.getArchiveId()) : document.getArchive();
                        if (archive != null) {
                            lc.setAjh(String.valueOf(archive.getAjh()));
                            lc.setMlh(archive.getMlh());
                            lc.setDh(archive.getDh());
                        }
                    }
                    loanTm = this.getDocLoanTm(this.archiveType);
                    tmValue = "";
                    try {
                        tmValue = PropertyUtils.getProperty((Object)document, (String)loanTm).toString();
                    }
                    catch (Exception ex) {
                        tmValue = document.getTm();
                    }
                    lc.setTm(tmValue);
                } else if (!(this.archiveType.equals("ythsw") || this.archiveType.equals("ythfw") || this.archiveType.equals("ythnw"))) {
                    Archive arvhice = (Archive)this.entityService.load(this.archiveType, id.trim());
                    loanTm = this.getLoanTm(this.archiveType);
                    tmValue = "";
                    try {
                        tmValue = PropertyUtils.getProperty((Object)arvhice, (String)loanTm).toString();
                    }
                    catch (Exception ex) {
                        tmValue = arvhice.getTm();
                    }
                    lc.setTm(tmValue);
                    lc.setMlh(arvhice.getMlh());
                    lc.setAjh(arvhice.getAjh().toString());
                    lc.setDh(arvhice.getDh());
                }
                entities.add(lc);
            }
        }
        return entities;
    }

    public String borrows() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List criterions = this.createCriterions(new ArrayList());
        if (userInfo.isAdmin()) {
            this.renderJson((Object)this.sortPage(this.loanService.getPages(this.start, this.limit, criterions)));
        } else {
            SimpleExpression cr = Restrictions.eq((String)"userId", (Object)userInfo.getId());
            criterions.add(cr);
            this.renderJson((Object)this.sortPage(this.loanService.getPages(this.start, this.limit, criterions)));
        }
        return null;
    }

    private String getLoanTm(String modelName) {
        String tm = "tm";
        try {
            tm = this.archiveService.getArchiveModel(modelName).getTemplate("loanField");
        }
        catch (Exception ex) {
            tm = "tm";
        }
        return tm;
    }

    private String getDocLoanTm(String modelName) {
        String tm = "tm";
        try {
            tm = this.archiveService.getDocumentModel(modelName).getTemplate("loanField");
        }
        catch (Exception ex) {
            tm = "tm";
        }
        return tm;
    }

    public String addLoanCar() {
        List loanCarts = this.getLoanCar();
        String message = "";
        ArrayList<SimpleExpression> wghlist = new ArrayList<SimpleExpression>();
        HashMap<String, LoanCart> map1 = new HashMap<String, LoanCart>();
        ArrayList<String> archiveIdList = new ArrayList<String>();
        for (LoanCart loanCart : loanCarts) {
            wghlist.add(Restrictions.eq((String)"archiveId", (Object)loanCart.getArchiveId()));
            wghlist.add(Restrictions.eq((String)"state", (Object)0));
            Page wghPage = this.entityService.search(Loan.class, wghlist, null, 0, -1);
            List wghLists = wghPage.getItems();
            if (wghLists != null && wghLists.size() != 0) {
                archiveIdList.add(loanCart.getArchiveId());
            }
            if (map1.containsKey(loanCart.getArchiveId())) continue;
            map1.put(loanCart.getArchiveId(), loanCart);
        }
        for (String string : archiveIdList) {
            if (!map1.containsKey(string)) continue;
            map1.remove(string);
        }
        for (Map.Entry entry : map1.entrySet()) {
            this.loanService.addToCart(entry.getValue());
        }
        if (archiveIdList.size() == 0) {
            message = "success";
        } else if (loanCarts.size() == 1 && archiveIdList.size() == 1 && ((LoanCart)loanCarts.get(0)).getArchiveId().equals(archiveIdList.get(0))) {
            Archive archive = this.archiveService.getSimpleArchive((String)archiveIdList.get(0));
            message = "\u76ee\u5f55\u53f7\u4e3a" + archive.getMlh() + "\u6848\u5377\u53f7\u4e3a" + archive.getAjh() + "\u7684\u6863\u6848\u5df2\u88ab\u501f\u9605\uff0c\u672a\u5f52\u8fd8";
        } else if (map1.entrySet().size() < loanCarts.size() && map1.entrySet().size() > 0) {
            message = "\u5df2\u501f\u51fa\u672a\u5f52\u8fd8\u6863\u6848\u65e0\u6cd5\u6dfb\u52a0\u5230\u501f\u9605\u8f66";
        }
        Struts2Utils.renderJson((String)message, (String[])new String[0]);
        return null;
    }

    public String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    public String remove() {
        this.loanService.removeFromCart(this.entityService.load(LoanCart.class, this.id));
        Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        return null;
    }

    public Model getEntityModel() {
        return this.modelService.getModel("LoanCart");
    }

    public List getEntities() {
        this.entities = super.getEntities();
        return this.sortPage(new Page(this.entities)).getItems();
    }

    public Page<LoanCart> sortPage(Page entityPage) {
        List loanCarts = entityPage.getItems();
        Collections.sort(loanCarts, new /* Unavailable Anonymous Inner Class!! */);
        entityPage.setItems(loanCarts);
        return entityPage;
    }

    public void checkIsBorrowNow() {
        String[] ids = this.getArchiveIds().split(",");
        StringBuffer message = new StringBuffer();
        ArrayList<SimpleExpression> wghlist = new ArrayList<SimpleExpression>();
        for (String archiveId : ids) {
            wghlist.add(Restrictions.eq((String)"archiveId", (Object)archiveId));
            wghlist.add(Restrictions.eq((String)"state", (Object)0));
            Page wghPage = this.entityService.search(Loan.class, wghlist, null, 0, -1);
            List wghLists = wghPage.getItems();
            if (wghLists.size() == 0) continue;
            Archive archive = this.archiveService.getSimpleArchive(archiveId);
            message.append("\u5168\u5b97\u53f7\u4e3a" + archive.getQzh() + "\u76ee\u5f55\u53f7\u4e3a" + archive.getMlh() + "\u6848\u5377\u53f7\u4e3a" + archive.getAjh() + "\u7684\u6863\u6848\u5df2\u88ab\u501f\u9605\uff0c\u672a\u5f52\u8fd8,\u8bf7\u7b49\u5f85\u5f52\u8fd8\u540e\u518d\u767b\u8bb0\uff01").append("\n");
        }
        Struts2Utils.renderJson((String)message.toString(), (String[])new String[0]);
    }

    public void checkIsAddTwo() {
        String[] ids = this.archiveIds.split(",");
        ArrayList<SimpleExpression> lists = null;
        String message = "";
        for (String id : ids) {
            lists = new ArrayList<SimpleExpression>();
            lists.add(Restrictions.eq((String)"archiveId", (Object)id.trim()));
            lists.add(Restrictions.eq((String)"userId", (Object)SessionUtil.getCurrentUserId()));
            Page wghPage = this.entityService.search(LoanCart.class, lists, null, 0, -1);
            List addLists = wghPage.getItems();
            if (addLists.size() <= 0) continue;
            Archive archive = this.archiveService.getSimpleArchive(((LoanCart)addLists.get(0)).getArchiveId());
            message = "\u5168\u5b97\u53f7\u4e3a" + archive.getQzh() + "\u76ee\u5f55\u53f7\u4e3a" + archive.getMlh() + "\u6848\u5377\u53f7\u4e3a" + archive.getAjh() + "\u7684\u6863\u6848\u4e0d\u53ef\u88ab\u91cd\u590d\u6dfb\u52a0\u501f\u9605\u8f66\uff01";
            break;
        }
        this.renderJson((Object)message);
    }
}

