/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.ArchiveInfo;
import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.RecordAjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.archive.util.Base64Utils;
import com.gtis.common.Page;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.WrongClassException;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;

@Service
public class GatewayServiceImpl
implements GatewayService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private EntityService entityService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;
    @Autowired
    protected DictService dictService;
    @Autowired
    private ModelService modelService;
    private HttpClient httpClient;

    public GatewayServiceImpl() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(20);
        connectionManager.getParams().setConnectionTimeout(30000);
        connectionManager.getParams().setSoTimeout(30000);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
    }

    public String in(String content) throws Exception {
        Document xmlDoc;
        this.logger.debug("gateway in:[\n{}\n]", (Object)content);
        try {
            Element el;
            String modelName;
            Element element;
            SAXReader reader = new SAXReader();
            xmlDoc = reader.read((Reader)new StringReader(content)).getDocument();
            for (Object node : xmlDoc.selectNodes("/list/archive")) {
                element = (Element)node;
                Archive archive = this.saveArchive(element, modelName = element.attributeValue("type"));
                if (archive == null) continue;
                for (Object node1 : element.selectNodes("doc")) {
                    el = (Element)node1;
                    this.saveDoc2(el, archive, modelName);
                }
                for (Object node1 : element.selectNodes("file")) {
                    el = (Element)node1;
                    this.saveOriginal(el, archive.getId(), modelName);
                }
                for (Object node1 : element.selectNodes("archiveinfo")) {
                    el = (Element)node1;
                    this.saveArchiveInfo(el, archive.getId(), modelName);
                }
            }
            for (Object node : xmlDoc.selectNodes("/list/doc")) {
                element = (Element)node;
                modelName = element.attributeValue("type");
                com.gtis.archive.entity.Document doc = this.saveDoc(element, null, modelName);
                for (Object node1 : element.selectNodes("file")) {
                    el = (Element)node1;
                    this.saveOriginal(el, doc.getId(), modelName);
                }
            }
            xmlDoc.getRootElement().addAttribute("result", "succeed");
        }
        catch (Exception e) {
            xmlDoc = DocumentHelper.createDocument();
            Element result = xmlDoc.addElement("list");
            result.addAttribute("result", "fail");
            result.addAttribute("msg", e.getMessage());
        }
        String ret = xmlDoc.asXML();
        this.logger.debug("gateway ret:[\n{}\n]", (Object)ret);
        return ret;
    }

    public String out(String key) {
        Archive archive = this.archiveService.getSimpleArchive(key);
        StringBuilder sb = new StringBuilder();
        if (archive != null) {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<archive>\n");
            List archiveFields = this.getFieldNames("Archive");
            for (String archiveField : archiveFields) {
                try {
                    sb.append("<field name=\"" + archiveField + "\">" + PropertyUtils.getProperty((Object)archive, (String)archiveField) + "</field>\n");
                }
                catch (Exception e) {
                    this.logger.error(e.toString());
                }
            }
            List originalList = this.originalService.getOriginals(archive.getId());
            for (Original original : originalList) {
                sb.append("<file id=\"" + original.getId() + "\"/>\n");
            }
            List documentList = this.archiveService.getArchiveDocuments(archive);
            List documentFields = new ArrayList();
            if (documentList.size() != 0) {
                documentFields = this.getFieldNames("Document");
            }
            for (com.gtis.archive.entity.Document document : documentList) {
                sb.append("<document>\n");
                for (String documentField : documentFields) {
                    try {
                        sb.append("<field name=\"" + documentField + "\">" + PropertyUtils.getProperty((Object)document, (String)documentField) + "</field>\n");
                    }
                    catch (Exception e) {
                        this.logger.error(e.toString());
                    }
                }
                List originals = this.originalService.getOriginals(document.getId());
                for (Original original : originals) {
                    sb.append("<file id=\"" + original.getId() + "\"/>\n");
                }
                sb.append("</document>\n");
            }
            sb.append("</archive>");
            return sb.toString();
        }
        return null;
    }

    public String update(String content) {
        Document xmlDoc;
        this.logger.debug("gateway before update: [\n{}\n]", (Object)content);
        try {
            SAXReader reader = new SAXReader();
            xmlDoc = reader.read((Reader)new StringReader(content)).getDocument();
            for (Object node : xmlDoc.selectNodes("/list/archive")) {
                String id;
                Element element = (Element)node;
                String modelName = element.attributeValue("type");
                Archive archive = this.archiveService.getArchive(modelName, id = this.getIdKey(element));
                if (archive == null) continue;
                this.archiveService.saveArchive((Archive)this.parseXmlField2Entity((Object)archive, element));
                for (Object docNode : element.selectNodes("doc")) {
                    Element doc = (Element)docNode;
                    if (StringUtils.isNotBlank((String)this.getIdKey(doc))) {
                        String docId = this.getIdKey(doc);
                        com.gtis.archive.entity.Document document = this.archiveService.getDocument(modelName, docId);
                        this.parseXmlField2Entity((Object)document, doc);
                        document = this.archiveService.saveDocument(document);
                        for (Object docOg : doc.selectNodes("file")) {
                            this.saveOriginal((Element)docOg, document.getId(), modelName);
                        }
                        continue;
                    }
                    this.saveDoc2(doc, archive, modelName);
                }
                for (Object ogNode : element.selectNodes("file")) {
                    Element og = (Element)ogNode;
                    this.saveOriginal(og, archive.getId(), modelName);
                }
                element.addAttribute("result", "succeed");
            }
        }
        catch (Exception ex) {
            this.logger.error("\u66f4\u65b0\u6863\u6848\u5f02\u5e38\u3010{}\u3011", (Object)ex.getLocalizedMessage());
            xmlDoc = DocumentHelper.createDocument();
            Element result = xmlDoc.addElement("list");
            result.addAttribute("result", "fail");
            result.addAttribute("msg", ex.getMessage());
        }
        String res = xmlDoc.asXML();
        this.logger.debug("gateway after update: [\n{}\n]", (Object)res);
        return res;
    }

    public String preIn(String content) throws Exception {
        Document xmlDoc;
        this.logger.debug("gateway in:[\n{}\n]", (Object)content);
        try {
            Element el;
            String modelName;
            Element element;
            SAXReader reader = new SAXReader();
            xmlDoc = reader.read((Reader)new StringReader(content)).getDocument();
            for (Object node : xmlDoc.selectNodes("/list/archive")) {
                element = (Element)node;
                Archive archive = this.saveDGDArchive(element, modelName = element.attributeValue("type"));
                if (archive == null) continue;
                for (Object node1 : element.selectNodes("doc")) {
                    el = (Element)node1;
                    this.saveDoc2(el, archive, modelName);
                }
                for (Object node1 : element.selectNodes("file")) {
                    el = (Element)node1;
                    this.saveOriginal(el, archive.getId(), modelName);
                }
                for (Object node1 : element.selectNodes("archiveinfo")) {
                    el = (Element)node1;
                    this.saveArchiveInfo(el, archive.getId(), modelName);
                }
            }
            for (Object node : xmlDoc.selectNodes("/list/doc")) {
                element = (Element)node;
                modelName = element.attributeValue("type");
                com.gtis.archive.entity.Document doc = this.saveDoc(element, null, modelName);
                for (Object node1 : element.selectNodes("file")) {
                    el = (Element)node1;
                    this.saveOriginal(el, doc.getId(), modelName);
                }
            }
            xmlDoc.getRootElement().addAttribute("result", "succeed");
        }
        catch (Exception e) {
            xmlDoc = DocumentHelper.createDocument();
            Element result = xmlDoc.addElement("list");
            result.addAttribute("result", "fail");
            result.addAttribute("msg", e.getMessage());
        }
        String ret = xmlDoc.asXML();
        this.logger.debug("gateway ret:[\n{}\n]", (Object)ret);
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String preDispose(String modelName, String id, String mlh) throws Exception {
        if (StringUtils.isBlank((String)modelName) || StringUtils.isBlank((String)id)) {
            return null;
        }
        Archive archive = this.archiveService.getArchive(modelName, id);
        if (archive == null) {
            return null;
        }
        if (archive.getState() == 3 && archive.getMlh() != null && archive.getAjh() != null) {
            archive.setState(2);
            this.archiveService.saveArchive(archive);
            return null;
        } else {
            archive.setState(2);
            RecordAjhRange recordAjhRange = this.recordAjhRangeService.getAvailable(mlh, modelName, archive.getDwdm());
            if (recordAjhRange != null) {
                archive.setAjh(Integer.valueOf(recordAjhRange.getAjh()));
                archive.setMlh(recordAjhRange.getMlh());
                this.archiveService.saveArchive(archive);
                this.recordAjhRangeService.remove(recordAjhRange.getId());
                return null;
            } else if (StringUtils.isBlank((String)mlh)) {
                AjhRange ajhRange = this.getAvailAjhRange(archive, modelName);
                if (ajhRange == null) throw new RuntimeException("ajh not available");
                int ajh = ajhRange.getNextValue();
                archive.setMlh(ajhRange.getMlh());
                archive.setAjh(Integer.valueOf(ajh));
                ajhRange.setCurrentValue(ajh);
                this.archiveService.saveArchive(archive);
                this.ajhRangeService.saveAjhRange(ajhRange);
                return null;
            } else {
                AjhRange ajhRange = this.ajhRangeService.getAvailableAjhRange(modelName, mlh);
                if (ajhRange == null) throw new RuntimeException("ajh not available");
                int ajh = ajhRange.getNextValue();
                archive.setMlh(ajhRange.getMlh());
                archive.setAjh(Integer.valueOf(ajh));
                ajhRange.setCurrentValue(ajh);
                this.archiveService.saveArchive(archive);
                this.ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return null;
    }

    public String cancelDispose(String modelName, String id) throws Exception {
        if (StringUtils.isBlank((String)modelName) || StringUtils.isBlank((String)id)) {
            return null;
        }
        Archive archive = this.archiveService.getArchive(modelName, id);
        if (archive == null) {
            return null;
        }
        RecordAjhRange recordAjhRange = new RecordAjhRange();
        recordAjhRange.setAjh(archive.getAjh().intValue());
        recordAjhRange.setMlh(archive.getMlh());
        recordAjhRange.setDwdm(archive.getDwdm());
        recordAjhRange.setModelName(archive.getModelName());
        archive.setState(3);
        archive.setAjh(null);
        archive.setMlh(null);
        this.archiveService.saveArchive(archive);
        this.recordAjhRangeService.saveRecordAjh(recordAjhRange);
        return null;
    }

    public String dispose(String modelName, String id) throws Exception {
        if (StringUtils.isBlank((String)modelName) || StringUtils.isBlank((String)id)) {
            return null;
        }
        Archive archive = this.archiveService.getArchive(modelName, id);
        if (archive == null) {
            return null;
        }
        if (archive.getState() == 2) {
            archive.setState(0);
            this.archiveService.saveArchive(archive);
            List documentList = this.archiveService.getArchiveDocuments(modelName, id);
            for (com.gtis.archive.entity.Document document : documentList) {
                document.setDwdm(archive.getDwdm());
                this.archiveService.saveDocument(document);
            }
        } else {
            return "\u6539\u6761\u6863\u6848\u8bb0\u5f55\u4e0d\u5904\u4e8e\u9884\u5904\u7406\u72b6\u6001";
        }
        return "success";
    }

    public String out(String key, String modelName) {
        Archive archive = this.archiveService.getArchive(modelName, key);
        StringBuilder sb = new StringBuilder();
        if (archive != null) {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<archive>\n");
            List ownerFields = this.getFieldsName((Object)archive);
            List archiveFields = this.getFieldNames("Archive");
            for (String archiveField : archiveFields) {
                try {
                    sb.append("<field name=\"" + archiveField + "\">" + PropertyUtils.getProperty((Object)archive, (String)archiveField) + "</field>\n");
                }
                catch (Exception e) {
                    this.logger.error(e.toString());
                }
            }
            for (String ownerField : ownerFields) {
                try {
                    sb.append("<field name=\"" + ownerField + "\">" + PropertyUtils.getProperty((Object)archive, (String)ownerField) + "</field>\n");
                }
                catch (Exception e) {
                    this.logger.error(e.toString());
                }
            }
            List originalList = this.originalService.getOriginals(archive.getId());
            for (Original original : originalList) {
                sb.append("<file id=\"" + original.getId() + "\"/>\n");
            }
            List documentList = this.archiveService.getArchiveDocuments(archive);
            List documentFields = new ArrayList();
            List ownerDocumentFields = new ArrayList();
            if (documentList.size() != 0) {
                documentFields = this.getFieldNames("Document");
                ownerDocumentFields = this.getFieldsName(documentList.get(0));
            }
            for (com.gtis.archive.entity.Document document : documentList) {
                sb.append("<document>\n");
                for (String documentField : documentFields) {
                    try {
                        sb.append("<field name=\"" + documentField + "\">" + PropertyUtils.getProperty((Object)document, (String)documentField) + "</field>\n");
                    }
                    catch (Exception e) {
                        this.logger.error(e.toString());
                    }
                }
                for (String ownerDocumentField : ownerDocumentFields) {
                    try {
                        sb.append("<field name=\"" + ownerDocumentField + "\">" + PropertyUtils.getProperty((Object)document, (String)ownerDocumentField) + "</field>\n");
                    }
                    catch (Exception e) {
                        this.logger.error(e.toString());
                    }
                }
                List originals = this.originalService.getOriginals(document.getId());
                for (Original original : originals) {
                    sb.append("<file id=\"" + original.getId() + "\"/>\n");
                }
                sb.append("</document>\n");
            }
            sb.append("</archive>");
            return sb.toString();
        }
        return null;
    }

    private Archive saveDGDArchive(Element el, String modelName) {
        try {
            Archive archive = this.readArchive(el, modelName);
            archive.setDh(null);
            archive.setState(3);
            boolean returnId = StringUtils.isBlank((String)archive.getId());
            this.archiveService.saveArchive(archive);
            el.addAttribute("result", "succeed");
            if (returnId) {
                Element idField = el.addElement("field");
                idField.addAttribute("name", "id");
                idField.setText(archive.getId());
            }
            return archive;
        }
        catch (Exception e) {
            el.addAttribute("result", "fail");
            el.addAttribute("msg", e.getMessage());
            return null;
        }
    }

    @Transactional
    public Map getSendSwData(String[] ids, String modelName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        HashMap rootMap = new HashMap();
        ArrayList result = new ArrayList();
        for (String id : ids) {
            id = id.trim();
            Object ythswObj = this.entityService.load(modelName, id);
            HashMap<String, Object> objMap = new HashMap<String, Object>();
            objMap.put("id", id);
            objMap.put("tm", PropertyUtils.getProperty((Object)ythswObj, (String)"tm"));
            objMap.put("wh", PropertyUtils.getProperty((Object)ythswObj, (String)"wh"));
            objMap.put("zrz", PropertyUtils.getProperty((Object)ythswObj, (String)"zrr"));
            objMap.put("zw", this.getOriginal("zw", id).get("zw"));
            objMap.put("fj", this.getOriginal("fj", id).get("fj"));
            result.add(objMap);
        }
        rootMap.put("result", result);
        return rootMap;
    }

    public Map httpToOAInterface(Map data) {
        String URL2 = EnvHolder.getAppEnv().get((Object)"recevieDataUrl");
        String responseData = "";
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod();
        postMethod.addParameter("events", "XMLService");
        postMethod.addParameter("SessionID", "5gvMBR03C1Kf7wDhRZp212nTvfJUgc4s2bpUN2WHz896pj6KIx1Fa9kdIqOx2fSN2bV");
        postMethod.addParameter("p0", JSON.toJSONString((Object)data));
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            responseData = postMethod.getResponseBodyAsString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (Map)JSON.parse((String)responseData);
    }

    public Map encodeToFile(String basePath, String data) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean flag = false;
        JSONArray receivedDatas = (JSONArray)JSON.parseObject((String)data).get((Object)"result");
        for (Object receivedData : receivedDatas) {
            Map receivedData1 = (Map)receivedData;
            JSONArray fjs = (JSONArray)receivedData1.get("fj");
            for (Object fj : fjs) {
                Map fj1 = (Map)fj;
                String code = (String)fj1.get("fileCode");
                String path = basePath + fj1.get("fileName");
                try {
                    Base64Utils.string2File((String)code, (String)path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        result.put("success", true);
        return null;
    }

    private Map getOriginal(String type, String archiveId) {
        List originals = this.originalService.getOriginals(archiveId);
        ArrayList<Original> zwList = new ArrayList<Original>();
        ArrayList<Original> fjList = new ArrayList<Original>();
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        for (Original original : originals) {
            String name = original.getName();
            if (name.startsWith("\u9644\u4ef6")) {
                fjList.add(original);
                continue;
            }
            if (name.endsWith(".doc")) continue;
            zwList.add(original);
        }
        if ("zw".equals(type)) {
            if (zwList.size() > 0) {
                Collections.sort(zwList, new /* Unavailable Anonymous Inner Class!! */);
                Original original = (Original)zwList.get(0);
                HashMap<String, String> propMap = new HashMap<String, String>();
                propMap.put("fileName", original.getName());
                propMap.put("fileCode", this.ecodeFileByBase64(this.originalService.getOriginalFile(original.getId(), "push")));
                map.put("zw", propMap);
            } else {
                map.put("zw", new HashMap());
            }
        } else if ("fj".equals(type)) {
            ArrayList fjs = new ArrayList();
            for (Original original : fjList) {
                HashMap<String, String> propMap = new HashMap<String, String>();
                propMap.put("fileName", original.getName());
                propMap.put("fileCode", this.ecodeFileByBase64(this.originalService.getOriginalFile(original.getId(), "push")));
                fjs.add(propMap);
            }
            map.put("fj", fjs);
        }
        return map;
    }

    private String ecodeFileByBase64(File file) {
        String result = null;
        try {
            result = Base64Utils.file2String((File)file);
        }
        catch (Exception e) {
            if (result == null) {
                return "";
            }
            this.logger.error(e.getMessage());
        }
        return result;
    }

    private String getIdKey(Element element) {
        for (Object node : element.selectNodes("field")) {
            Element el = (Element)node;
            if (!el.attributeValue("name").equals("id")) continue;
            return el.getTextTrim();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Archive saveArchive(Element el, String modelName) {
        try {
            Archive archive = this.readArchive(el, modelName);
            archive.setDh(null);
            boolean returnId = StringUtils.isBlank((String)archive.getId());
            if (archive.getAjh() == null && !EnvHolder.isEnable((String)"allowNullDh.enable") || archive.getMlh() != null) {
                AjhRange ajhRange = this.getAvailAjhRange(archive, modelName);
                if (ajhRange == null) throw new RuntimeException("ajh not available");
                int ajh = ajhRange.getNextValue();
                archive.setMlh(ajhRange.getMlh());
                archive.setAjh(Integer.valueOf(ajh));
                ajhRange.setCurrentValue(ajh);
                this.archiveService.saveArchive(archive);
                this.ajhRangeService.saveAjhRange(ajhRange);
            } else {
                this.archiveService.saveArchive(archive);
            }
            el.addAttribute("result", "succeed");
            if (returnId) {
                Element idField = el.addElement("field");
                idField.addAttribute("name", "id");
                idField.setText(archive.getId());
            }
            if (archive.getMlh() != null) {
                Element mlhField = el.addElement("field");
                mlhField.addAttribute("name", "mlh");
                mlhField.setText(archive.getMlh());
            }
            Element ajhField = el.addElement("field");
            ajhField.addAttribute("name", "ajh");
            ajhField.setText(String.valueOf(archive.getAjh()));
            return archive;
        }
        catch (Exception e) {
            el.addAttribute("result", "fail");
            el.addAttribute("msg", e.getMessage());
            return null;
        }
    }

    private AjhRange getAvailAjhRange(Archive archive, String modelName) {
        String defaultDwdm = this.archiveService.newArchive(modelName).getDwdm();
        AjhRange ajhRange = null;
        ajhRange = StringUtils.isNotBlank((String)archive.getDwdm()) && StringUtils.isNotBlank((String)archive.getMlh()) ? (archive.getDwdm() == defaultDwdm ? this.ajhRangeService.getAvailableAjhRange(modelName, archive.getMlh()) : this.ajhRangeService.getAvailableAjhRange(modelName, archive.getDwdm(), archive.getMlh())) : (StringUtils.isNotBlank((String)archive.getMlh()) ? this.ajhRangeService.getAvailableAjhRange(modelName, archive.getMlh()) : (StringUtils.isNotBlank((String)archive.getDwdm()) ? (archive.getDwdm() == defaultDwdm ? this.ajhRangeService.getAvailableAjhRange(modelName) : this.ajhRangeService.getAvailableAjhRangeByDwdm(modelName, archive.getDwdm())) : this.ajhRangeService.getAvailableAjhRange(modelName)));
        return ajhRange;
    }

    private Object parseXmlField2Entity(Object entity, Element el) {
        if (entity == null) {
            return null;
        }
        for (Object node : el.selectNodes("field")) {
            Element field = (Element)node;
            String name = field.attributeValue("name");
            if (StringUtils.isBlank((String)name)) continue;
            try {
                BeanUtils.setProperty((Object)entity, (String)name, (Object)field.getTextTrim());
            }
            catch (Exception e) {
                this.logger.debug(e.getLocalizedMessage() + "\u5b57\u6bb5\u503c[{}]\u6709\u8bef", (Object)name);
            }
        }
        return entity;
    }

    private Archive readArchive(Element el, String modelName) throws Exception {
        String dwdm;
        String qzh;
        Archive archive = this.archiveService.newArchive(modelName);
        if (archive != null) {
            for (Object node : el.selectNodes("field")) {
                Element field = (Element)node;
                String name = field.attributeValue("name");
                if (StringUtils.isBlank((String)name)) continue;
                try {
                    BeanUtils.setProperty((Object)archive, (String)name, (Object)field.getTextTrim());
                }
                catch (Exception e) {
                    this.logger.debug(e.getLocalizedMessage() + "\u5b57\u6bb5\u503c[{}]\u6709\u8bef", (Object)name);
                }
            }
        }
        if ((StringUtils.isBlank((String)(qzh = archive.getQzh())) || "default".equals(qzh)) && !StringUtils.isBlank((String)(dwdm = archive.getDwdm()))) {
            qzh = this.getQzh(dwdm);
            archive.setQzh(qzh);
        }
        return archive;
    }

    private String getQzh(String dwdm) {
        String qzh = "";
        try {
            List items = this.dictService.getItems("qzhdwdm");
            for (Item item : items) {
                if (!dwdm.equals(item.getName())) continue;
                qzh = item.getValue();
                break;
            }
        }
        catch (Exception ex) {
            this.logger.info("\u672a\u914d\u7f6e[{}]\u5355\u4f4d\u4ee3\u7801\u5168\u5b97\u53f7\u5b57\u5178\u9879", (Object)"qzhdwdm");
        }
        return qzh;
    }

    private com.gtis.archive.entity.Document saveDoc2(Element el, Archive archive, String modelName) {
        try {
            com.gtis.archive.entity.Document doc = this.readDoc(el, modelName);
            boolean returnId = StringUtils.isBlank((String)doc.getId());
            if (archive != null) {
                doc.setArchiveId(archive.getId());
                doc.setMlh(archive.getMlh());
                if (archive.getAjh() != null) {
                    doc.setAjh(archive.getAjh());
                }
            }
            this.archiveService.saveDocument(doc);
            el.addAttribute("result", "succeed");
            if (returnId) {
                Element idField = el.addElement("field");
                idField.addAttribute("name", "id");
                idField.setText(doc.getId());
            }
            return doc;
        }
        catch (Exception e) {
            el.addAttribute("result", "fail");
            el.addAttribute("msg", e.getMessage());
            return null;
        }
    }

    private com.gtis.archive.entity.Document saveDoc(Element el, String archiveId, String modelName) {
        try {
            com.gtis.archive.entity.Document doc = this.readDoc(el, modelName);
            boolean returnId = StringUtils.isBlank((String)doc.getId());
            if (archiveId != null) {
                doc.setArchiveId(archiveId);
            }
            this.archiveService.saveDocument(doc);
            el.addAttribute("result", "succeed");
            if (returnId) {
                Element idField = el.addElement("field");
                idField.addAttribute("name", "id");
                idField.setText(doc.getId());
            }
            return doc;
        }
        catch (Exception e) {
            el.addAttribute("result", "fail");
            el.addAttribute("msg", e.getMessage());
            return null;
        }
    }

    private com.gtis.archive.entity.Document readDoc(Element el, String modelName) throws Exception {
        com.gtis.archive.entity.Document entity = this.archiveService.newDocument(modelName);
        if (entity != null) {
            for (Object node : el.selectNodes("field")) {
                Element field = (Element)node;
                String name = field.attributeValue("name");
                if (StringUtils.isBlank((String)name)) continue;
                try {
                    BeanUtils.setProperty((Object)entity, (String)name, (Object)field.getTextTrim());
                }
                catch (Exception e) {
                    this.logger.debug(e.getLocalizedMessage() + "\u5b57\u6bb5\u503c[{}]\u6709\u8bef", (Object)name);
                }
            }
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Original saveOriginal(Element el, String ownerId, String modelName) {
        String url = el.attributeValue("url");
        String id = el.attributeValue("id");
        String status = el.attributeValue("status");
        GetMethod get = null;
        try {
            get = new GetMethod(url);
            get.getParams().setHttpElementCharset("iso-8859-1");
            this.httpClient.executeMethod((HttpMethod)get);
            String fileName = new String(get.getResponseHeader("Content-Disposition").getValue().getBytes("iso-8859-1"));
            fileName = fileName.substring(fileName.indexOf("\"") + 1, fileName.lastIndexOf("\""));
            Original original = new Original();
            original.setName(fileName);
            original.setOwnerId(ownerId);
            if (StringUtils.isNotBlank((String)id)) {
                original.setId(id);
            }
            if (StringUtils.isNotBlank((String)status)) {
                original.setStatus(status);
            }
            File tmpFile = File.createTempFile("archive_gw", null);
            FileCopyUtils.copy((InputStream)get.getResponseBodyAsStream(), (OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)));
            this.originalService.saveOriginalFile(original, tmpFile, StringUtils.isNotBlank((String)id));
            tmpFile.delete();
            this.originalService.saveOriginal(original);
            Element idField = el.addElement("field");
            idField.addAttribute("name", "id");
            idField.setText(original.getId());
        }
        catch (Exception e) {
            el.addAttribute("result", "fail");
            el.addAttribute("msg", e.getMessage());
            this.logger.error("Save original error", (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    private ArchiveInfo saveArchiveInfo(Element e, String ownerId, String modelName) {
        ArchiveInfo archiveInfo = null;
        String aiModelName = modelName.concat("_ai");
        try {
            archiveInfo = (ArchiveInfo)this.entityService.newInstance(aiModelName);
        }
        catch (Exception e1) {
            this.logger.error("\u5b9e\u4f8b\u5316[{}]\u6a21\u578b\u51fa\u9519,\u68c0\u67e5\u8be5\u5377\u5185\u6a21\u578b\u662f\u5426\u914d\u7f6e\uff01".concat(e1.getLocalizedMessage()), (Object)aiModelName);
        }
        if (archiveInfo == null) {
            return null;
        }
        archiveInfo.setArchiveId(ownerId);
        archiveInfo.setArchiveModel(modelName);
        for (Object node : e.selectNodes("field")) {
            Element field = (Element)node;
            String name = field.attributeValue("name");
            if (StringUtils.isBlank((String)name)) continue;
            try {
                BeanUtils.setProperty((Object)archiveInfo, (String)name, (Object)field.getTextTrim());
            }
            catch (Exception e1) {
                this.logger.debug(e1.getLocalizedMessage() + "\u5b57\u6bb5\u503c[{}]\u6709\u8bef", (Object)name);
            }
        }
        this.entityService.save((Object)archiveInfo);
        return archiveInfo;
    }

    private Object doUpdate(Object ob, String content, String modelName) {
        try {
            SAXReader reader = new SAXReader();
            Document xmlDoc = reader.read((Reader)new StringReader(content)).getDocument();
            for (Object node : xmlDoc.selectNodes("/" + modelName)) {
                Element element = (Element)node;
                for (Object node1 : element.selectNodes("field")) {
                    Element field = (Element)node1;
                    String name = field.attributeValue("name");
                    if (StringUtils.isBlank((String)name)) continue;
                    PropertyUtils.setProperty((Object)ob, (String)name, (Object)field.getTextTrim());
                }
            }
            return ob;
        }
        catch (Exception ex) {
            this.logger.debug(ex.toString());
            return null;
        }
    }

    private List<String> getFieldsName(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        ArrayList<String> fieldsName = new ArrayList<String>();
        for (Field field : fields) {
            if (field.getModifiers() != 2) continue;
            fieldsName.add(field.getName());
        }
        return fieldsName;
    }

    private List<String> getFieldNames(String modelName) {
        Field[] fields;
        ArrayList<String> fieldsName = new ArrayList<String>();
        if (modelName == "Archive") {
            fields = Archive.class.getDeclaredFields();
        } else if (modelName == "Document") {
            fields = com.gtis.archive.entity.Document.class.getDeclaredFields();
        } else {
            return null;
        }
        for (Field field : fields) {
            if (field.getModifiers() != 2) continue;
            fieldsName.add(field.getName());
        }
        return fieldsName;
    }

    private AjhRange checkAjh(AjhRange ajhRange, String qzh, String mlh, int ajh, String id, String modelName, String dwdm) {
        Page archivePage;
        ArrayList<SimpleExpression> list = new ArrayList<SimpleExpression>();
        list.add(Restrictions.eq((String)"qzh", (Object)qzh));
        list.add(Restrictions.eq((String)"mlh", (Object)mlh));
        list.add(Restrictions.eq((String)"ajh", (Object)ajh));
        ArrayList ordes = new ArrayList();
        try {
            archivePage = this.archiveService.searchArchive(modelName, list, null, 0, 1);
        }
        catch (WrongClassException wrongClassException) {
            archivePage = this.archiveService.searchArchive("Archive", list, null, 0, 1);
        }
        if (!archivePage.isEmpty() && !((Archive)archivePage.getItem(0)).getId().equals(id)) {
            ajhRange.setCurrentValue(ajh);
            this.ajhRangeService.saveAjhRange(ajhRange);
            ajhRange = this.checkAjh(ajhRange, qzh, mlh, ajhRange.getCurrentValue() + 1, id, modelName, dwdm);
        }
        return ajhRange;
    }
}

