/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.support.xstream;

import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import java.io.IOException;
import java.util.regex.Pattern;
import org.dom4j.CDATA;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CDATASupportDom4JXmlWriter
extends AbstractXmlWriter {
    private final XMLWriter writer;
    private final FastStack elementStack;
    private AttributesImpl attributes;
    private boolean started;
    private boolean children;
    private Pattern escapePattern = Pattern.compile("[<>&]");

    public CDATASupportDom4JXmlWriter(XMLWriter writer) {
        this(writer, (NameCoder)new XmlFriendlyNameCoder());
    }

    public CDATASupportDom4JXmlWriter(XMLWriter writer, NameCoder nameCoder) {
        super(nameCoder);
        this.writer = writer;
        this.elementStack = new FastStack(16);
        this.attributes = new AttributesImpl();
        try {
            writer.startDocument();
        }
        catch (SAXException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public CDATASupportDom4JXmlWriter(XMLWriter writer, XmlFriendlyReplacer replacer) {
        this(writer, (NameCoder)replacer);
    }

    public void startNode(String name) {
        if (this.elementStack.size() > 0) {
            try {
                this.startElement();
            }
            catch (SAXException e) {
                throw new StreamException((Throwable)e);
            }
            this.started = false;
        }
        this.elementStack.push((Object)this.encodeNode(name));
        this.children = false;
    }

    public void setValue(String text) {
        if ((text = text.replaceAll("\\t", "")).length() > 0) {
            try {
                this.startElement();
                if (text.length() > 10 && this.escapePattern.matcher(text).find()) {
                    DefaultCDATA cdata = new DefaultCDATA(text);
                    this.writer.write((CDATA)cdata);
                } else {
                    this.writer.characters(text.toCharArray(), 0, text.length());
                }
            }
            catch (SAXException e) {
                throw new StreamException((Throwable)e);
            }
            catch (IOException e) {
                throw new StreamException((Throwable)e);
            }
            this.children = true;
        }
    }

    public void addAttribute(String key, String value) {
        this.attributes.addAttribute("", "", this.encodeAttribute(key), "string", value);
    }

    public void endNode() {
        try {
            if (!this.children) {
                DefaultElement element = new DefaultElement((String)this.elementStack.pop());
                for (int i = 0; i < this.attributes.getLength(); ++i) {
                    element.addAttribute(this.attributes.getQName(i), this.attributes.getValue(i));
                }
                this.writer.write((Element)element);
                this.attributes.clear();
                this.children = true;
                this.started = true;
            } else {
                this.startElement();
                this.writer.endElement("", "", (String)this.elementStack.pop());
            }
        }
        catch (SAXException e) {
            throw new StreamException((Throwable)e);
        }
        catch (IOException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public void close() {
        try {
            this.writer.endDocument();
        }
        catch (SAXException e) {
            throw new StreamException((Throwable)e);
        }
    }

    private void startElement() throws SAXException {
        if (!this.started) {
            this.writer.startElement("", "", (String)this.elementStack.peek(), (Attributes)this.attributes);
            this.attributes.clear();
            this.started = true;
        }
    }
}

