/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.support.spring;

import com.gtis.archive.core.AppPropsManager;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.environment.Environment;
import com.gtis.config.AppConfig;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

public class EnvHolderConfigurer
implements InitializingBean,
ServletContextAware {
    private AppPropsManager appPropsService;
    private String webroot = "./";

    public void afterPropertiesSet() throws Exception {
        Environment env = EnvHolder.getSysProps();
        Map props = AppConfig.getProperties();
        props.put("web.root", this.webroot);
        if (props.size() > 0) {
            env = new Environment(props, env);
        }
        env = new Environment(this.appPropsService.getAppProps(), env);
        EnvHolder.setAppEnv((Environment)env);
    }

    public Environment getAppEnv() {
        return EnvHolder.getAppEnv();
    }

    public void setAppEnvService(AppPropsManager appPropsService) {
        this.appPropsService = appPropsService;
    }

    public void setServletContext(ServletContext servletContext) {
        this.webroot = servletContext.getRealPath("/");
    }
}

