<@layout.main import="jquery,ext">
<style type="text/css">

    * {
        margin: 0;
        padding: 0;
    }

    #page-wrap {
        width: 750px;
        margin: 0px auto;
        position: relative;
        background-color: #f5f5f5;
    }

    #nav-bar {
        width: 191px;
        background: url('img/navbar-bg.png') repeat-y;
        position: absolute;
        border-top-left-radius: 18px;
        border-bottom-left-radius: 18px;
    }

    #nav-bar ul {
        list-style: none;
        margin: 40px 0 40px 0;
    }

    #nav-bar ul li {
        font-size: 14px;
        text-align: right;
    }

    #nav-bar ul li.active a {
        position: relative;
        background: #eeeeee;
        z-index: 300;
        border-bottom-color: #eeeeee;
        border-top-color: #eeeeee;
    }

    #nav-bar ul li.active a:hover {
        background: #eeeeee;
    }

    #nav-bar ul li a {
        text-decoration: none;
        display: block;
        padding: 10px 40px 10px 5px;
        border-top: 1px solid rgba(0, 0, 0, 0.2);
        border-bottom: 1px solid rgba(255, 255, 255, 0.2);
        color: #444;
        text-shadow: 1px 1px 1px white;
        font-weight: bold;
    }

    #nav-bar ul li:first-child a {
        border-top: 0;
    }

    #nav-bar ul li:last-child a {
        border-bottom: 0;
    }

    #nav-bar ul li a:hover {
        background: rgba(0, 0, 0, 0.07);
    }

    #main-content {
        position: relative;
        z-index: 200;
        margin: 0 0 0 180px;
        background: #eeeeee;
        border-radius: 18px;
        box-shadow: 0px 0px 18px rgba(0, 0, 0, 0.6);
        filter: progid:DXImageTransform.Microsoft.Shadow(Strength = 8, Direction = 135, Color = '#aaaaaa');
        -ms-filter: "progid:DXImageTransform.Microsoft.Shadow(Strength=8, Direction=135, Color='#aaaaaa')";
        padding: 30px;
        min-height: 500px;
    }

    #nav-bar .search {
        text-align: left;
        display: block;
        margin: 25px 25px 2px 12px;
        padding: 0px 0px 10px 0px;
        border-bottom: 1px solid #1E4F66;
    }

    #nav-bar .search h4 {
        font-size: 16px;
        color: #1E4F66;
        margin: 0px 0px 0px 4px;
    }

    #nav-bar .search ul {
        margin: 8px 2px 8px 2px;
    }

    #nav-bar .search ul li {
        display: block;
    }

    #nav-bar .search ul li .searchInput {
        background: #eeeeee;
        margin: 0px;
        padding: 0px;
        width: 108px;
        height: 20px;
        float: left;
        position: relative;
    }

    #nav-bar .search ul li .searchBtn {
        font-size: 14px;
        margin: 0px;
        padding: 0px;
        width: 38px;
    }

    .warningInfo {
        padding-left: 20px;
        color: red;
        font-size: 14px
    }

    .archiveInfoDisable {
        display: none;
    }

    .archiveInfoEnable {
        margin: 10px 2px;
        display: block;
    }

    .archiveInfoEnable li {
        font-size: 15px;
        color: #3581ff;
        list-style: none;
        margin: 2px;
    }

    .archiveInfoEnable li span {
        color: #000011;
        font-size: 14px;
        padding: 1px 20px;
    }


</style>
<div class="a-box">
    <div class="a-box-frame">
        <div class="a-box-inner">
            <div class="a-box-inner-frame" style="min-height:500px;_height:500px;padding-top:10px;">
                <form method="post" style="padding:20px;" id="gd-form">
                    <input type="hidden" name="condition" value="name,dh;cd,like;value,"/>

                    <div id="page-wrap">
                        <div id="nav-bar">
                            <div class="search">
                                <h4>输入档号</h4>
                                <ul>
                                    <li><input name="keyword" class="searchInput" value="${Parameters.keyword!}"/></li>
                                    <li><input class="searchBtn" type="submit" value="检索"
                                               onclick="return searchArchive(this.form);"/></li>
                                </ul>
                            </div>
                            <ul id="main-nav">
                                <#if entities?? && entities?size gt 0>
                                    <#list entities as archive>
                                        <li><a href="#" aid="${archive.id!}">${archive.dh!"空档号"}
                                            <ul class="archiveInfoDisable">
                                                <li><span><@a.title name="tm"/></span>${archive.tm!}</li>
                                                <li><span><@a.title name="ajh"/></span>${archive.ajh!}</li>
                                                <li><span><@a.title name="mlh"/></span>${archive.mlh!}</li>
                                                <li><span><@a.title name="js"/></span>${archive.js!}</li>
                                                <li><span><@a.title name="ys"/></span>${archive.ys!}</li>
                                                <li><span><@a.title name="bgqx"/></span>${archive.bgqx!}</li>
                                                <li><span><@a.title name="mj"/></span>${archive.mj!}</li>
                                                <li><span><@a.title name="nd"/></span>${archive.nd!}</li>
                                                <li><span><@a.title name="bz"/></span>${archive.bz!}</li>
                                            </ul>
                                        </a></li>
                                        <#if archive_index gt 6>
                                            <div class="warningInfo">记录大于8条，<br/>请细化检索条件</div>
                                            <#break >
                                        </#if>
                                    </#list>
                                <#else >
                                    <#if Parameters.keyword??>
                                        <div class="warningInfo">未找到满足条件的档案</div>
                                    </#if>
                                </#if>
                            </ul>
                        </div>
                        <div id="main-content">
                            <div id="inside-content">
                                <#--<div id="archive_info"/>-->
                                <div id="original_list"/>
                            </div>
                        </div>
                    </div>


                </form>

            </div>
        </div>
    </div>
</div>
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript">

    var ogDS, aId, jsessionId = '${sessionId}', modelName = '${modelName}';

    function reloadDS(aid){
        aId = aid;
        ogDS.reload({params:{ownerId:aId}});
    }

    ogDS = new Ext.data.JsonStore({
        url:'og!list.action',
        autoLoad:true,
        baseParams:{ownerId:aId},
        totalProperty:'totalCount',
        root:'items',
        fields:[
            'id','name','filesize','updateTime'
        ]
    });

    var ogCbSm = new Ext.grid.CheckboxSelectionModel();

    var formateSize = function(s,p,r){
        return Ext.util.Formate.fileSize(s);
    }

    var ogGridPanel = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:ogDS,
        height:350,
        sm:ogCbSm,
        loadMask:true,
        stripeRows:true,
        region:'center',
        renderTo:'original_list',
        bbar:new Ext.PagingToolbar({
            pageSize:20,
            store:ogDS,
            displayInfo:true,
            displayMsg:'{0}-{1}共{2}条',
            emptyMsg:"尚未检测到原文数据"
        }),
        cm:new Ext.grid.ColumnModel([
            ogCbSm,
            {header:"名称",width:250,sortable:true,dataIndex:'name'},
            {header:"大小",width:96,sortable:true,dataIndex:'fileSize',render:formateSize},
            {header:"上传时间",width:130,sortable:true,dataIndex:'updateTime'}
        ]),
        tbar:[
            {
                text:"上传",
                iconCls:'upload',
                handler:function(){
                    var upUrl = function(url){return getUrlWidthSessionId(url+'?modelName='+modelName)};
                    var upLoadDialog = new UploadDialog({
                        getUrl:upUrl,
                        maxSize:5368709120,
                        typeDescription:"所有文件",
                        autoClose:this.autoClose||true,
                        fileTypes:'*.*'
                    });
                    upLoadDialog.on('close',function(){
                        ogDS.reload();
                    });
                    upLoadDialog.show(_aId);
                }
            },
            {
                text:"删除",
                iconCls:'delete',
                handler:function(){
                    if(ogCbSm.getSelections().length==0)
                    {
                        alert('未选择原文！');
                        return;
                    }
                    if(!confirm('确定删除选中原文？')) return;
                    var s = [];
                    Ext.each(ogCbSm.getSelections(),function(e){
                        s.push(e.data.id);
                    });
                    Ext.Ajax.request({
                        url:'og!remove.action',
                        params:{id:s},
                        success:function(m){
                            ogDS.reload();
                        }
                    });

                }
            }
        ],
        listeners:{
            render:function(g){
                var store = g.getStore();
                var view = g.getView();
                g.tip = new Archive.OgTip({
                    dismissDelay:0,
                    target:view.mainBody,
                    delegate:'.x-grid3-row',
                    autoWidth:!Ext.isIE6,
                    renderTo:document.body,
                    listeners:{
                        beforeShow:function(tip){
                            var rowIndex = view.findRowIndex(tip.triggerElement);
                            tip.body.update('<img src="og!thumb.action?modelName='+modelName+'&id='+store.getAt(rowIndex).id+'"/>');

                        }
                    }
                })
            },
            rowdblclick:function(g,index,e){
                var id = ogDS.getAt(index).id;
                showPreview([id]);
            }
        }

    });

    function showPreview(nids) {
        if (!Ext.isDefined(window.hasEPreOcx)) {
            try {
                new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
                window.hasEPreOcx = true;
            } catch (e) {
                window.hasEPreOcx = false;
            }
        }
        if (window.hasEPreOcx) {
            var base = location.href.substring(0, location.href.lastIndexOf('/'));
            var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
            link = link.substr(link.indexOf('//') + 2);
            Ext.Ajax.request({
                url:'archive!cacheIds.action',
                params:{id:nids},
                success:function (r) {
                    var json = Ext.decode(r.responseText);
                    location.href = 'epre://'+link + json['idsKey'];
                }
            });
        } else {
            window.open('og!get.action?preview=true&id=' + nids[0]);
        }
    }

    function getUrlWidthSessionId(url)
    {
        var index = url.indexOf('?');
        var _jpart = ';jsessionid='+jsessionId;
        if (index > -1)
            return url.substring(0,index)+_jpart+url.substring(index);
        else
            return url+_jpart;
    }


    $(function () {

        var $el = $(), $mainContent = $("#main-content");
        $mainContent.wrapInner("<div id='fade-wrapper' />");
        $mainContent.append('<div id="ajax-loader" />');
        var $fadeWrapper = $("#fade-wrapper"),
                $allNav = $("#main-nav a"),
                $allListItems = $("#main-nav li"),
                $ajaxLoader = $("#ajax-loader"),
                $insideContent = $("#inside-content");
        $insideContent.append("<div id='archive_info'/>");


        $("#main-nav li:first").addClass("active");
        var $aInfo = $("#main-nav li:first").find("ul").clone();
        $aInfo.removeClass("archiveInfoDisable");
        $('#archive_info').append($aInfo.addClass("archiveInfoEnable"));

        $allNav.click(function (e) {
            $el = $(this);
            if (!$el.parent().hasClass("active")) {
                $(window).scrollTop(0);

                $fadeWrapper.animate({ opacity:0.1 });
                $ajaxLoader.fadeIn(120, function () {

                    reloadDS($el.attr('aid'));

                    $('#archive_info').contents().remove();
                    var $aInfo = $el.find("ul").clone();
                    $aInfo.removeClass("archiveInfoDisable");
                    $('#archive_info').append($aInfo.addClass("archiveInfoEnable"));

                    $fadeWrapper.animate({ opacity:1 });
                    $ajaxLoader.fadeOut();
                    $allListItems.removeClass("active");
                    $el.parent().addClass("active");
                });
            }
            e.preventDefault();

        });

    });


</script>
</@layout.main>