<#-- @ftlvariable name="modelName" type="java.lang.String" -->
<#-- @ftlvariable name="topMenu" type="java.util.Map<java.lang.String, java.lang.String>" -->
<#-- @ftlvariable name="treeId" type="java.lang.String" -->
<#-- @ftlvariable name="fields" type="java.util.Map<java.lang.String, com.gtis.archive.core.Field>" -->
<#-- @ftlvariable name="showFields" type="java.util.LinkedHashMap" -->
<#-- @ftlvariable name="linkField" type="java.lang.String" -->
<#-- @ftlvariable name="flag" type="java.lang.Boolean" -->
<@layout.main import="jquery,ext">
<style type="text/css">
    .selected{
        background: rgba(176, 176, 176, 0.67);
    }
    .models{
        width: 140px;
        height: 250px;
        overflow: auto;
        border-bottom:solid  1px #dfdfdf;
        border-left: solid  1px #dfdfdf;
        border-top: solid  1px #dfdfdf;
    }
    .model{
        border-bottom: dashed  1px #dfdfdf;
    }
    .unShow{
        display: none;
    }

</style>
<table>
    <tr>
        <td class="archiveLeftPanel">
            <div class="a-box">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="min-height:500px;_height:500px;padding-top:10px;">
                            <dl class="a-side">
                                <dt>全文检索</dt>
                                <dd>
                                    <form action="${ctx.env['solr.url']}" method="get" target="_blank">
                                        <input type="hidden" name="bid" value="archive"/>
                                        <table id="search-box" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td class="input">
                                                    <input type="text" name="keyword" class="text" style="width:120px;"/>
                                                    <input type="submit" class="sub" value=""/>
                                                    <input type="hidden" name="cid" value="a_${modelName}"/>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                </dd>
                            </dl>
                            <dl class="a-side" id="treeBox-ct">
                                <dt>案卷分类</dt>
                                <dd>
                                    <div id="treeBox"></div>
                                </dd>
                            </dl>
                            <dl class="a-side">
                                <dt>切换档案分类</dt>
                                <#if ctx.env['classifyViewMode']=='normal'>
                                    <dd>
                                        <select  style="width:140px;" onchange="location.href='archive.action?modelName='+this.value">
                                            <#list tree as res>
                                                <#if res.children??><#list res.children as res>
                                                    <option value="${res.name}"<#if res.id==treeId> selected="selected"</#if>>${res.text}</option>
                                                </#list></#if>
                                            </#list>
                                        </select>
                                    </dd>
                                    <#else>
                                <dd>
                                        <div class="models">
                                        <table style="width:100%;" class="a-table"  cellpadding="0" cellspacing="0">
                                            <#list tree as res>
                                                <#if res.children??>
                                                    <#list res.children as res>
                                                        <tr <#if res.id==treeId> class="selected"</#if>>
                                                            <td class="model"><a href="archive.action?modelName=${res.name}">${res.text}</a></td>
                                                        </tr>
                                                    </#list>
                                                </#if>
                                            </#list>
                                        </table>
                                        </div>
                                </dd>
                                </#if>

                            </dl>
                            <dl class="a-side">
                                <dd>
                                    <a href="print/print.zip">打印控件下载</a></br>
                                </dd>
                            </dl>
                            <dl class="a-side">
                                <dd>
                                    <a href="print/IEQuestion.zip">IE补丁下载</a>
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </td>
        <td class="archiveRightPanel">
            <div class="a-box" >
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame" style="padding-top:10px;">
                            <div class="a-tab clearfix">
                                <a href="#" class="tab on">案 卷</a>
                                <a href="doc.action?modelName=${modelName}_jn" class="tab">卷 内</a>
                                <#if ctx.env['classifyViewMode']=='checkbox'>
                                    <input type="checkbox" checked="true" onclick="changeArchiveByCheck()" id="wgdCheck" style="margin:6px 0 5px 5px;float:left;">
                                    <a href="#" class="btn" id="wgd-btn">未归档</a>
                                    <input type="checkbox" checked="true" onclick="changeArchiveByCheck()" id="ygdCheck" style="margin:6px 0 5px 5px;float:left;">
                                    <a href="#" class="btn" id="ygd-btn">已归档</a>
                                <#else>
                                <a href="#" class="btn active" onclick="return changeArchiveType('wgd');" id="wgd-btn" style="margin-left: 10px;">未归档</a>
                                <div class="sep">|</div>
                                <a href="#" class="btn" onclick="return changeArchiveType('ygd');" id="ygd-btn">已归档</a>
                                </#if>
                                <a href="#" onclick="return showAdvancedSearch();" style="display:block;float:right;margin:0 10px 0 5px;line-height: 20px;">高级检索</a>

                                <div id="searchBox"></div>
                            </div>
                            <div class="a-opt clearfix" id="opt-box">
                                <a class="a-btn a-ctl" href="#" onclick="return showArchive();" id="addArchive">添加</a>

                                <#--<#if ctx.hasEnv('jiangyin.enable')>-->
                                    <#--<#if ctx.isAdmin()>-->
                                        <#--<a class="a-btn a-ctl" href="#" onclick="return editArchive();" id="editArchive">修改</a>-->
                                        <#--<a class="a-btn a-ctl" href="#" onclick="return delArchive();" id="delArchive">删除</a>-->
                                    <#--</#if>-->
                                <#--<#else>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return editArchive();" id="editArchive">修改</a>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return delArchive();" id="delArchive">删除</a>-->
                                <#--</#if>-->
                                <a class="a-btn a-ctl" href="#" onclick="return editArchive();" id="editArchive">修改</a>
                                <a class="a-btn a-ctl" href="#" onclick="return delArchive();" id="delArchive">删除</a>


                                <a class="a-btn a-ctl" href="#" onclick="return gdArchive();" id="gdArchive">归档</a>
                                <#if ctx.hasEnv('allowNullDh.enable')>
                                    <a class="a-btn a-ctl" href="#" onclick="return blArchive();" id="blArchive">档案补录</a>
                                    <a class="a-btn a-ctl" href="#" onclick="return fastAddOriginal();">快速补件</a>
                                </#if>
                                <#if ctx.hasEnv('jintan.enable')>
                                    <a class="a-btn a-ctl" href="#" onclick="return makeUpArchive();">档案补录</a>
                                </#if>

                                <#--<#if ctx.hasEnv('jiangyin.enable')>-->
                                    <#--<#if ctx.isAdmin()>-->
                                        <#--<a class="a-btn a-ctl" href="#" onclick="return cxgdArchive();" id="cxgdArchive">撤销归档</a>-->
                                    <#--</#if>-->
                                <#--<#else>-->
                                    <#--<a class="a-btn a-ctl" href="#" onclick="return cxgdArchive();" id="cxgdArchive">撤销归档</a>-->
                                <#--</#if>-->
                                <a class="a-btn a-ctl" href="#" onclick="return cxgdArchive();" id="cxgdArchive">撤销归档</a>


                                <#if ctx.hasEnv('bengbu.enable')>
                                    <#if perms["originalManager"]??>
                                        <a class="a-btn" href="#" onclick="return showOriginal();">原文管理</a>
                                    </#if>
                                <#else >
                                    <a class="a-btn" href="#" onclick="return showOriginal();">原文管理</a>
                                </#if>
                                <#list topMenu?keys as key><a class="a-btn a-ctl" href="#" onclick="return ${key}();" id="${key}">${topMenu[key]}</a></#list>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="a-box" id="search-item" style="display:none;">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div class="a-box-inner-frame clearfix" style="margin-top:10px;padding:5px 0 5px 5px;position:relative;">
                            <span class="search-item-close" onclick="hideAdvancedSearch();"></span>

                            <div style="float:right;padding:3px 25px 8px 0;">
                                <a class="a-btn" href="#" onclick="return addSearchItem();">增加过滤</a>
                                <a class="a-btn" href="#" onclick="return advancedSearch();">检 索</a>
                                <#if ctx.hasEnv('jiangyin.enable')><a class="a-btn" href="#" onclick="return gdAfterSearch();" id="gdAfterSearch">归档检索结果</a> </#if>
                            </div>
                            <form class="clearfix" id="search-item-box" onkeydown="if(event.keyCode==13){event.keyCode=0;return false;}"></form>
                        </div>
                    </div>
                </div>
            </div>
            <#if ctx.hasEnv('bengbu.enable')>
                <div align="right" style="margin-top: 2px;height: 16px;padding-right: 10px"  id="pageBtn">
                    <img src="/archive/img/previous.png" style="cursor: pointer" class="img" alt="上一页" title="上一页" onclick="perviousPage()"/>
                    <img src="/archive/img/next.png" style="padding-left: 10px;cursor: pointer" class="img" alt="下一页" title="下一页"  onclick="nextPage()"/>
                </div>
            </#if>
            <div class="a-box" style="margin-top:10px;">
                <div class="a-box-frame">
                    <div class="a-box-inner">
                        <div id="dataList" class="a-box-inner-frame" style="min-height:422px;_height:422px">
                            <div id="archivesCt"style=" overflow-x:scroll;"></div>
                            <div id="pagingToolbar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </td>
    </tr>
</table>
<textarea style="display:none;" id="archiveTpl">
    <table style="width:100%;" class="a-table" cellpadding="0" cellspacing="0">
        <tr>
            <th style="width:1px;"><input type="checkbox" onclick="changeSelect(this,'chk-archive');" value=""></th>
            <th style="width:30px;"></th>
            <#list showFields?keys as name>
                <#assign width=showFields[name]['width']!-1/>
                <th<#if width!=-1> style="width:${width}px;"</#if>><a href="#" onclick="return archiveSortBy('${modelName}');" title="点击标题排序"><#if name='state' && ctx.env['classifyViewMode']!='checkbox'><#else>${fields[name].title}</#if></a></th>
            </#list>
            <#if ctx.hasEnv('bengbu.enable')>
                <#if perms["originalManager"]??>
                    <th style="width:30px;"></th>
                </#if>
            <#else >
                <th style="width:30px;"></th>
            </#if>
            <#if ctx.hasEnv('jiangyin.enable')><th style="width:30px;"></th></#if>
        </tr>
        <tpl for=".">
            <tr class='a-item {[xindex%2==0?"even":"odd"]}'>
                <td style="width:1px;"><input type="checkbox" value="{id}" class="chk-archive"></td>
                <td><#if isShowArchiveDoc??><a href="#" onclick="return viewDocument('{id}',this,event);" title="查看卷内列表" class="jn-btn"><img src="img/s.gif" alt=""/></a></#if></td>
                <#list showFields?keys as name>
                    <#assign fd=showFields[name]/>
                    <#assign max=fd['max']!-1/>
                    <td>
                        <#if name==linkField>
                            <a href="#" onclick="return showArchive('{id}');" onmouseover="delayShowTip(this,'{id}')" onmouseout="killdelayShowTip(this);">{${name}:def("无"<#if max!=-1>,${max}</#if>)}</a>
                        <#elseif name=='state'><#if ctx.env['classifyViewMode']=='checkbox'>{state:format}<#else></#if>
                        <#else>{${name}:<#if fd['date']??>renderDate("${fd['date']}")<#else>def<#if max!=-1>("",${max})</#if></#if>}
                        </#if>
                    </td>
                </#list>
                <#--<td><#if isShowArchiveDoc??><a href="#" onclick="return viewDocument('{id}',this,event);" title="查看卷内列表" class="jn-btn"><img src="img/s.gif" alt=""/></a></#if></td>-->
                <#if ctx.hasEnv('bengbu.enable')>
                  <#if perms["originalManager"]??>
                    <td><a class="jn-btn" href="#"  onclick="return showOriginal(null,'{id}');" title="原文管理">原文</a></td>
                   </#if>
                <#else >
                    <td><a class="jn-btn" href="#"  onclick="return showOriginal(null,'{id}');" title="原文管理">原文</a></td>
                </#if>
                <#if ctx.hasEnv('jiangyin.enable')><td>{hasOriginal:style}</td>
                </#if>
            </tr>
            <tr style="display:none;" class="odd">
                <td colspan="7">
                    <div id="d{id}" class="a-ct"></div>
                </td>
            </tr>
        </tpl>
    </table>
</textarea>
</textarea>
<textarea style="display:none;" id="documentTpl">
    <table style="width:100%;" class="a-doc" cellpadding="0" cellspacing="0">
        <caption>
            <tpl if="perm.edit" style="display:none;">
                <a class="a-btn" href="#" onclick="return delDocument('{archiveId}');">删除卷内</a>
                <a class="a-btn" href="#" onclick="return printDocumentList('{archiveId}');">列表打印</a>
                <a class="a-btn" href="#" onclick="return editDocument('{archiveId}');">修改卷内</a>
            </tpl>
            <#if ctx.hasEnv('bengbu.enable')>
                <#if perms["originalManager"]??>
                    <a class="a-btn" href="#" onclick="return showOriginal('{archiveId}');">原文管理</a>
                </#if>
            <#else >
                <a class="a-btn" href="#" onclick="return showOriginal('{archiveId}');">原文管理</a>
            </#if>
            <tpl if="perm.edit" style="display:none;">
                <a class="a-btn" href="#" onclick="return showDocument('','{archiveId}');">添加卷内</a>
            </tpl>
        </caption>
        <tr>
            <th style="width:1px;"><input type="checkbox" onclick="changeSelect(this);" value=""></th>
            <#if docShowFields??>
                <#list docShowFields?keys as name>
                    <#assign width=docShowFields[name]['width']!-1/>
                    <#if name!='archiveId'>
                    <th>${(docFields[name].title)!}</th></#if>
                </#list>
                <#if ctx.hasEnv('jiangyin.enable')>
                    <th>目录号</th>
                    <th>案卷号</th>
                    <th>全宗号</th>
                </#if>
            <#else>
                <th>题名</th>
                <th>页号</th>
                <th>责任者</th>
                <th style="width:120px;">日期</th>
            </#if>
        </tr>
        <tpl for="docs">
            <tr class='{[xindex%2==0?"even":"odd"]}'>
                <td style="width:1px;"><input type="checkbox" value="{id}"></td>
                <#if docShowFields??>
                    <#list docShowFields?keys as name>
                        <#assign fd=docShowFields[name]/>
                        <#assign max=fd['max']!-1/>
                        <#if name!='archiveId'>
                        <td>
                            <#if name==docLinkField>
                                <a href="#" onclick="return showDocument('{id}','{archiveId}');" >{${name}:def("无"<#if max!=-1>,${max}</#if>)}</a>
                            <#else>{${name}:<#if fd['date']??>renderDate("${fd['date']}")<#else>def<#if max!=-1>("",${max})</#if></#if>}
                            </#if>
                        </td>
                        </#if>
                    </#list>
                    <#if ctx.hasEnv('jiangyin.enable')>
                        <td>{mlh}</td>
                        <td>{ajh}</td>
                        <td>{qzh}</td>
                    </#if>
                <#else>
                    <td><a href="#" onclick="return showDocument('{id}','{archiveId}');">{tm:def("无题名",20)}</a></td>
                    <td>{yh:def}</td>
                    <td>{zrz:def}</td>
                    <td>{rq:def}</td>
                </#if>

            </tr>
        </tpl>
    </table>
</textarea>
<textarea style="display:none;" id="searchTpl">
    <#assign advSearchFields=AdvSearchFields/>
    <div class="search-item">
        <select name="name" style="width:120px;">
            <#if advSearchFields??><#list advSearchFields?values as field>
                <option value="${field.name}">${field.title}</option>
            </#list></#if>
        </select>
        <select name="cd" style="width:50px;">
            <option value="like">类似</option>
            <option value="eq">等于</option>
            <option value="ne">不等于</option>
            <option value="gt">大于</option>
            <option value="lt">小于</option>
            <option value="notNull">不为空</option>
            <option value="isNull">为空</option>
        </select>
        <input type="text" name="value" size="13" onkeydown="if(event.keyCode==13){advancedSearch();};"/>
        <span class="search-item-close" onclick="$(this).parent().remove();"></span>
    </div>
</textarea>
<script type="text/javascript" src="js/UploadDialog.js"></script>
<script type="text/javascript" src="js/ext/SearchField.js"></script>
<script type="text/javascript" src="js/ext/ux/ComboPageSize.js"></script>
<script type="text/javascript">
var win, store, treeId = '${treeId}', archiveId, modelName = '${modelName}', jnModelName = '${modelName}_jn', id, _type;
var json =${treeJson!'[]'};
var docTpl = Ext.XTemplate.from('documentTpl');
var perm = ${permJson!'{}'};
var _jsessionid = '${sessionId}';
var _curAId;
var archiveSaveType;
var tree;
var pageToolBar;
/**
 *  arc/doc
 */
var iframeType;


/**
 * 归档状态的render
 * @param v
 */
Ext.util.Format.format=function(v){
    if (v == 1) return "<img src=\"/archive/img/ygd.png\" alt=\"已归档\" title=\"已归档\" class='img' />";
    else return "<img src=\"/archive/img/wgd.png\" alt=\"未归档\" title=\"未归档\" class='img' />";

}


Ext.util.Format.style=function(v){
    if(!v)
        return "<img src=\"/archive/img/wuog.png\" alt=\"未上传原文\"  title=\"未上传原文\" class='img' />";
    return null;
}


/**
 * checkbox方式选择归档状态
 */
function changeArchiveByCheck() {
    if ($('#wgdCheck').attr("checked") && !$('#ygdCheck').attr("checked"))
        changeArchiveType('wgd');
    else if (!$('#wgdCheck').attr("checked") && $('#ygdCheck').attr("checked"))
        changeArchiveType('ygd');
    else
        changeArchiveType('all');
}

function getJsessionidUrl(url) {
    var index = url.indexOf('?');
    if (index > -1) {
        return url.substring(0, index) + ';jsessionid=' + _jsessionid + url.substr(index);
    } else {
        return url + ';jsessionid=' + _jsessionid;
    }
}
function viewDocument(id, aLink, ev) {
    if (ev.stopPropagation)
        ev.stopPropagation();
    else
        ev.cancelBubble = true;
    var ct = $('#d' + id).parent().parent();
    if (ct.is(":hidden")) {
        ct.show();
        reloadDocuments(id);
    }
    else {
        if (aLink)
            ct.hide();
    }
    if (aLink)
        $(aLink).toggleClass('jn-open');
    return false;
}

function changeArchiveType(type, notReload) {
    if (type == 'ygd') {
        $('#addArchive,#gdArchive,#blArchive,#fastOrganize').hide();
        if (perm.edit) {
//            $('#cxgdArchive').show();
            $('#showLoan').show();
            $('#loanCar').show();
        }
    <#if ctx.isAdmin()>
    $('#cxgdArchive').show();
    $('#delArchive').show();
    $('#editArchive').show();
    <#else>
//     if (perm.edit) {
        if (perm.cxgd) {
            $('#cxgdArchive').show();
        } else {
            $('#cxgdArchive').hide();
        }
        if (perm.del) {
            $('#delArchive').show();
        } else {
            $('#delArchive').hide();
        }
        if (perm.change) {
            $('#editArchive').show();
        } else {
            $('#editArchive').hide();
        }
//     }
    </#if>
        $('#wgd-btn').removeClass('active');
        $('#ygd-btn').addClass('active');
    <#if ctx.hasEnv('jiangyin.enable')>
        $("#gdAfterSearch").addClass("unShow");
    </#if>
    } else if(type == 'wgd') {
        if (perm.edit) {
            $('#addArchive,#gdArchive,#blArchive,#fastOrganize').show();
            $('#delArchive').show();
            $('#editArchive').show();
        }
        $('#showLoan').hide();
        $('#loanCar').hide();
    <#if ctx.hasEnv('jiangyin.enable')>
        $("#gdAfterSearch").removeClass("unShow");
    </#if>
        $('#cxgdArchive').hide();
        $('#wgd-btn').addClass('active');
        $('#ygd-btn').removeClass('active');
    }else {
        if (perm.edit) {
            $('#addArchive,#gdArchive,#blArchive,#fastOrganize').show();
            $('#cxgdArchive').show();
        }
        $('#wgd-btn').addClass('active');
        $('#ygd-btn').addClass('active');
    }
    _type = type;
    store.setBaseParam('type', type);

    if (!notReload){
        store.removeListener('load', showProgressBar,this);
        store.load();
    }
}

function onPermChange(perm) {
    if (perm.edit) {
        $('#opt-box a.a-ctl').show();
    } else {
        $('#opt-box a.a-ctl').hide();
    }
    changeArchiveType(_type);
    if (perm.print) {
        $('#printArchive').show();
    } else {
        $('#printArchive').hide();
    }
    <#--<#if ctx.isAdmin()>-->
        <#--$('#cxgdArchive').show();-->
        <#--$('#delArchive').show();-->
        <#--$('#editArchive').show();-->
    <#--<#else>-->
        <#--if (perm.cxgd) {-->
            <#--$('#cxgdArchive').show();-->
        <#--} else {-->
            <#--$('#cxgdArchive').hide();-->
        <#--}-->
        <#--if (perm.del) {-->
            <#--$('#delArchive').show();-->
        <#--} else {-->
            <#--$('#delArchive').hide();-->
        <#--}-->
        <#--if (perm.change) {-->
            <#--$('#editArchive').show();-->
        <#--} else {-->
            <#--$('#editArchive').hide();-->
        <#--}-->
    <#--</#if>-->

}

var archiveTip;

function showTip(a, id) {
    if (archiveTip) {
        archiveTip.hide();
    } else {
        archiveTip = new Archive.ToolTip({
            width:250,
            target:a,
            html:'loading'
        });
    }
    Ext.Ajax.request({
        url:'archive-entity!preview.action',
        params:{id:id, modelName:modelName},
        success:function (rp) {
            var html = ['<div class="info-card"><ul><li><a href="#"  onclick="showOriginal(null,\'' + id + '\');">原文管理</a></li>'];
            html.push(rp.responseText);
            html.push('</ul></div>');
            archiveTip.setHtml(html.join(''));
        }
    });
    archiveTip.showBy(a);
    return false;
}

function delayShowTip(a, id) {
    a.tipTimer = setTimeout(function () {
        showTip(a, id)
    }, 500);
}

function killdelayShowTip(a) {
    if (a.tipTimer) {
        clearTimeout(a.tipTimer);
    }
}

function loanCar(){
    var loanIds=getSelectIds();
    if(loanIds.length==0){
        alert("请选择要借阅的档案");
        return;
    }
    Ext.Ajax.request({
        url:'borrow!addLoanCar.action',
        params:{idString:loanIds, archiveType:modelName},
        success:function (rp) {
            var message=rp.responseText;
            if(message=="success"){
                alert("添加成功");
            }else{
                alert("添加失败");
            }
        }
    });
}

function printDocumentList(id) {
    debugger;
//    if (confirm('确定打印列表吗？')) {
        var base = location.href.substring(0, location.href.lastIndexOf('/'));
        var dataUrl = getJsessionidUrl(base + '/doc!print.action?modelName=' + jnModelName + '&archiveId=' + id);
        var printUrl;
        <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
                var printType= window.localStorage.printType;
                var localPath=window.localStorage.localPath;
                if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
                if(printType==null||printType=="Local"){
                    if(fileExist(localPath+jnModelName+".fr3")){
                        printUrl = localPath+jnModelName+".fr3";
                    }else if(fileExist(localPath+"document.fr3")){
                        printUrl = localPath+"document.fr3";
                    }else{
                        return alert("请检查本地模版是否存在");
                    }
                }else{
                    printUrl = getJsessionidUrl(base + '/doc!fr3.action?modelName=' + jnModelName);
                }
           <#else >
               printUrl = getJsessionidUrl(base + '/doc!fr3.action?modelName=' + jnModelName);
        </#if>
//        prompt('', dataUrl);
        location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
//    }
}

/**
 * 打印档案卷内列表
 * @param ids
 */
function printArchiveDoc(){
    debugger;
    var ids = getSelectIds();
    if(ids.length==0){
        alert('请勾选需要打印的案卷!');
        return;
    }
    var base = location.href.substring(0, location.href.lastIndexOf('/'));
    var dataUrl = getJsessionidUrl(base + '/archive!printArcDocs.action?modelName=' + jnModelName )+'&idsKey=';
    var printUrl;
    <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
        var printType= window.localStorage.printType;
        var localPath=window.localStorage.localPath;
        if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
        if(printType==null||printType=="Local"){
            if(fileExist(localPath+jnModelName+"-arcdoc.fr3")){
                printUrl = localPath+jnModelName+"-arcdoc.fr3";
            }else if(fileExist(localPath+"document.fr3")){
                printUrl = localPath+"archive-arcdoc.fr3";
            }else{
                return alert("请检查本地模版是否存在");
            }
        }else{
            printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=arcdoc&modelName=' + jnModelName);
        }
    <#else>
        printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=arcdoc&modelName=' + jnModelName);
    </#if>
    Ext.Ajax.request({
        url:'archive!cacheIds.action',
        params:{id:ids},
        success:function (r) {
            debugger;
            var key = Ext.decode(r.responseText);
            location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl+key['idsKey'];
        }
    });
}

function orderArchive(id) {
    if (confirm('确定要整理数据吗？')) {
        Ext.Ajax.request({
            url:'archive-entity!order.action?modelName=' + modelName + '&treeId=' + treeId + '&limit=-1',
            success:function (r) {
                store.reload();
            }
        });
    }
}

function printArchive(id) {
    debugger;
    Ext.MessageBox.show({
        title:'打印选择',
        msg:'案卷列表打印选择,选择是打印当前页,否所有案卷',
        buttons:Ext.MessageBox.YESNOCANCEL,
        fn:function (btn) {
            debugger;
            var param = Ext.apply({}, store.lastOptions.params || store.baseParams);
            if (btn == 'no') {
                Ext.apply(param, {limit:-1});
            } else if (btn == 'cancel') {
                return;
            }
            debugger;
            var base = location.href.substring(0, location.href.lastIndexOf('/'));
//            var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName + '&' + Ext.urlEncode(param));
            var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName + '&limit=' +param.limit)+'&idsKey=';
            var printUrl;

            <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
                var printType= window.localStorage.printType;
                var localPath=window.localStorage.localPath;
                if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
                if(printType==null||printType=="Local"){

                    if(fileExist(localPath+modelName+".fr3")){
                        printUrl =localPath+modelName+".fr3";
                    }else if(fileExist(localPath+"archive.fr3")){
                        printUrl = localPath+"archive.fr3";
                    }else{
                        return alert("请检查本地模版是否存在");
                    }
                }else{
                    printUrl = getJsessionidUrl(base + '/archive!fr3.action?modelName=' + modelName);
                }
            <#else >
                printUrl = getJsessionidUrl(base + '/archive!fr3.action?modelName=' + modelName);
            </#if>
            if(param.limit==-1){
               Ext.Ajax.request({
                url:'archive!searchIds.action',
                params:{condition:param.condition,limit:param.limit,start:param.start,modelName:modelName,treeId:param.treeId,type:param.type},
                success:function (r) {
                    var key = Ext.decode(r.responseText);
                    location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl+key['idsKey'];
                }
            });
            }else{
                Ext.Ajax.request({
                    url:'archive!cacheIds.action',
                    params:{modelName:modelName,treeId:param.treeId,type:param.type,id:getListIds()},
                    success:function (r) {
                        debugger;
                        var key = Ext.decode(r.responseText);
                        location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl+key['idsKey'];
                    }
                });
            }
        },
        icon:Ext.MessageBox.QUESTION
    });
}

function exportExcel(id) {
    Ext.MessageBox.show({
        title:'导出excel',
        msg:'excel导出,选择是导出当前页,否导出所有案卷',
        buttons:Ext.MessageBox.YESNOCANCEL,
        fn:function (btn) {
            var param = Ext.apply({}, store.lastOptions.params || store.baseParams);
            if (btn == 'no') {
                Ext.apply(param, {limit:-1});
            } else if (btn == 'cancel') {
                return;
            }
            location.href = 'archive!export.action?modelName=' + modelName + '&' + Ext.urlEncode(param);
        },
        icon:Ext.MessageBox.QUESTION
    });
}

function packageArchive() {
    var fp = new Ext.FormPanel({
        labelWidth:90,
        frame:true,
        border:false,
        bodyStyle:'padding:5px',
        items:[
            {
                fieldLabel:'目录号',
                xtype:"textfield",
                allowBlank:false,
                name:'mlh'
            },
            {
                fieldLabel:'起始案卷号',
                xtype:"numberfield",
                allowBlank:false,
                name:'ajh'
            },
            {
              fieldLabel:'截止案卷号',
                xtype:'numberfield',
                allowBlank:true,
                name:'endAjh'
            },
            {
                fieldLabel:'装盒份数',
                xtype:"numberfield",
                value:10,
                allowBlank:false,
                name:'boxSize'
            },
            {
                xtype:'radiogroup',
                fieldLabel:'排序',
                items:[
                    {boxLabel:'升序', name:'dir', inputValue:'ASC', checked:true},
                    {boxLabel:'降序', name:'dir', inputValue:'DESC'}
                ]
            }
        ],
        buttons:[
            {
                text:'打印目录',
                handler:function () {
                    if (fp.getForm().isValid()) {
                        var param = fp.getForm().getValues();
                        if(param.endAjh!=""){
                            var start=parseInt(param.ajh);
                            var end=parseInt(param.endAjh);
                            if(start>=end)
                                return Ext.MessageBox.alert("提示","请确保截止案卷号要大于起始案卷号");
                        }
                        param.limit = -1;
                        var base = location.href.substring(0, location.href.lastIndexOf('/'));
                        var printUrl;

                        <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
                            var printType= window.localStorage.printType;
                            var localPath=window.localStorage.localPath;
                            if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
                            if(printType==null||printType=="Local"){

                                if(fileExist(localPath+modelName+".fr3")){
                                    printUrl =localPath+modelName+".fr3";
                                }else if(fileExist(localPath+"archive.fr3")){
                                    printUrl = localPath+"archive.fr3";
                                }else{
                                    return alert("请检查本地模版是否存在");
                                }
                            }else{
                                printUrl = getJsessionidUrl(base + '/archive!fr3.action?modelName=' + modelName);
                            }
                        <#else >
                            printUrl = getJsessionidUrl(base + '/archive!fr3.action?modelName=' + modelName);
                        </#if>
                        var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName + '&' + Ext.urlEncode(param));
//                        prompt('', dataUrl);
                        location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
                    }
                }
            },
            {
                text:'打印封皮',
                handler:function () {
                    if (fp.getForm().isValid()) {
                        var param = fp.getForm().getValues();
                        if(param.endAjh!=""){
                            var start=parseInt(param.ajh);
                            var end=parseInt(param.endAjh);
                            if(start>=end)
                                return Ext.MessageBox.alert("提示","请确保截止案卷号要大于起始案卷号");
                        }
                        param.limit = -1;
                        var base = location.href.substring(0, location.href.lastIndexOf('/'));
                        var printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);

                        var printUrl;

                        <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
                            var printType= window.localStorage.printType;
                            var localPath=window.localStorage.localPath;
                            if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
                            if(printType==null||printType=="Local"){
                                if(fileExist(localPath+modelName+"-cover.fr3")){
                                    printUrl =localPath+modelName+"-cover.fr3";
                                }else if(fileExist(localPath+"archive-cover.fr3")){
                                    printUrl = localPath+"archive-cover.fr3";
                                }else{
                                    return alert("请检查本地模版是否存在");
                                }
                            }else{
                                printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);
                            }
                        <#else >
                            printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);
                        </#if>
                        var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName + '&' + Ext.urlEncode(param));
                        location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
                    }
                }
            },
            {
                text:'关闭',
                handler:function () {
                    pWin.close();
                }
            }
        ]
    });
    var pWin = new Ext.Window({
        title:'自动组盒',
        closable:true,
        modal:true,
        width:280,
        layout:'auto',
        border:false,
        resizable:false,
        items:fp
    });
    pWin.show();
}

/**
 * 句容需求，打印封皮
 */
function printArchiveCover(){
    <#if ctx.hasEnv('jiangyin.enable')>
           var selectTpl=new Ext.Panel({
               labelWidth:90,
               frame:true,
               border:false,
               bodyStyle:'padding:5px',
               html:'<span>请选择模版：</span><select id="coverSelect"><option value ="cover">模版1</option><option value ="cover2">模版2</option></select>',
               buttons:[
                   {
                       text:'确定',
                       handler:function () {
                           var temp=$("#coverSelect").val();
                           pWin.close();
                           var ids = getSelectIds();
                           if(ids.length==0){
                               alert('请勾选需要打印的案卷!');
                               return;
                           }
                           var base = location.href.substring(0, location.href.lastIndexOf('/'));
                           var printUrl;
                           var printType= window.localStorage.printType;
                           var localPath=window.localStorage.localPath;
                           if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
                           if(printType==null||printType=="Local"){
                               if(fileExist(localPath+modelName+"-cover.fr3")){
                                   printUrl =localPath+modelName+"-cover.fr3";
                               }else if(fileExist(localPath+"archive-cover.fr3")){
                                   printUrl = localPath+"archive-cover.fr3";
                               }else{
                                   return alert("请检查本地模版是否存在");
                               }
                           }else{
                               printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);
                           }
                           var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName )+'&idsKey=';
//                           var base = location.href.substring(0, location.href.lastIndexOf('/'));
//                           var printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType='+temp+'&modelName=' + modelName);
//                           var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName )+'&idsKey=';
                           Ext.Ajax.request({
                               url:'archive!cacheIds.action',
                               params:{id:ids},
                               success:function (r) {
                                   var key = Ext.decode(r.responseText);
                                   location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl+key['idsKey'];
                               }
                           });
                       }
                   },
                   {
                       text:'关闭',
                       handler:function () {
                           pWin.close();
                       }
                   }
               ]
           });
        var pWin = new Ext.Window({
            title:'选择封皮模版',
            closable:true,
            modal:true,
            width:200,
            layout:'auto',
            border:false,
            resizable:false,
            items:selectTpl
        });
        pWin.show();
    <#elseif ctx.hasEnv('jurong.enable')>
        debugger;
        var ids = getSelectIds();
        if(ids.length==0){
            alert('请勾选需要打印的案卷!');
            return;
        }
        var base = location.href.substring(0, location.href.lastIndexOf('/'));
        var printUrl;
        var printType= window.localStorage.printType;
        var localPath=window.localStorage.localPath;
        if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
        if(printType==null||printType=="Local"){
            if(fileExist(localPath+modelName+"-cover.fr3")){
                printUrl =localPath+modelName+"-cover.fr3";
            }else if(fileExist(localPath+"archive-cover.fr3")){
                printUrl = localPath+"archive-cover.fr3";
            }else{
                return alert("请检查本地模版是否存在");
            }
        }else{
           printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);
        }
        var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName )+'&idsKey=';
            Ext.Ajax.request({
                url:'archive!cacheIds.action',
                params:{id:ids},
                success:function (r) {
                    var key = Ext.decode(r.responseText);
                    location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl+key['idsKey'];
                }
            });
    <#else >
        var ids = getSelectIds();
        if(ids.length==0){
            alert('请勾选需要打印的案卷!');
            return;
        }
        var base = location.href.substring(0, location.href.lastIndexOf('/'));
        var printUrl = getJsessionidUrl(base + '/archive!fr3.action?printType=cover&modelName=' + modelName);
        var dataUrl = getJsessionidUrl(base + '/archive!print.action?modelName=' + modelName )+'&idsKey=';
        Ext.Ajax.request({
            url:'archive!cacheIds.action',
            params:{id:ids},
            success:function (r) {
                var key = Ext.decode(r.responseText);
                location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl+key['idsKey'];
            }
        });
    </#if>
}

/**
 * 打印备考表
 */
function printNote(){
    var ids = getSelectIds();
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个档案!');
        return;
    }
    var param = {start:0,limit:1,archiveId:ids[0]};
    var base = location.href.substring(0, location.href.lastIndexOf('/'));
    var printUrl = getJsessionidUrl(base + '/note!fr3.action?modelName=Note');

    var printUrl;

    <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
        var printType= window.localStorage.printType;
        var localPath=window.localStorage.localPath;
        if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
        if(printType==null||printType=="Local"){
            printUrl = localPath+"note.fr3";
        }else{
            printUrl = getJsessionidUrl(base + '/note!fr3.action?modelName=Note');
        }
    <#else >
        printUrl = getJsessionidUrl(base + '/note!fr3.action?modelName=Note');
    </#if>

    var dataUrl = getJsessionidUrl(base + '/note!print.action?modelName=Note&' + Ext.urlEncode(param));
//    prompt('',dataUrl);
    location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
}

function reloadDocuments(id) {
    Ext.Ajax.request({
        url:'doc!list.action?modelName=' + jnModelName,
        params:{archiveId:id},
        success:function (r) {
            debugger;
            var docs = Ext.decode(r.responseText);
            <#if ctx.hasEnv('jiangyin.enable')>
            var mlh;
            var ajh;
            var qzh;
            if(docs.items.length>0){
                mlh=docs.items[0].archive.mlh;
                ajh=docs.items[0].archive.ajh;
                qzh=docs.items[0].archive.qzh;
            }
            for(var i=0;i<docs.items.length;i++){
                var doc=docs.items[i];
                doc.mlh=mlh;
                doc.ajh=ajh;
                doc.qzh=qzh;
            }
            </#if>
            docTpl.overwrite('d' + id, {docs:docs.items, archiveId:id, perm:perm});
        }
    });
}

function addSearchItem() {
    var item = $('#search-item-box').append($('#searchTpl').val()).children(":last");
    item.hover(
            function () {
                $(this).addClass("hover");
            },
            function () {
                $(this).removeClass("hover");
            });
}

function showAdvancedSearch() {
    if ($("#search-item-box .search-item").length == 0) {
        addSearchItem();
    }
    $('#search-item').toggle();
}

function showProgressBar(){
    Ext.MessageBox.progress( '正在检索数据请稍后.......') ;
    setTimeout(function(){
        for(var i=0;i<6;i++)
            update(i);
    },100);
}
function update(v){
    Ext.MessageBox.updateProgress(v);
}

function advancedSearch() {
    debugger;
    var condition = Ext.lib.Ajax.serializeForm('search-item-box');
    store.setBaseParam('condition', condition.replace(/=/g, ',').replace(/&/g, ';'));
    store.addListener('load', showProgressBar,this);
    store.load({callback:function(a,b,c){
        if(c){
            setTimeout(function () {
                Ext.MessageBox.hide();
                store.removeListener('load', showProgressBar,this);
            },500) ;
        }
    }});
}

function gdAfterSearch(){
    var condition = Ext.apply({}, store.lastOptions.params || store.baseParams).condition;
    if(condition==""||condition==null)
        return alert("请先执行检索!");
    Ext.MessageBox.show({
        title:'归档选择',
        msg:'案卷列表归档选择,选择是归档当前页,否归档所有案卷',
        buttons:Ext.MessageBox.YESNOCANCEL,
        fn:function (btn) {
            var param = Ext.apply({}, store.lastOptions.params || store.baseParams);
            if (btn == 'no') {
                Ext.apply(param, {limit:-1});
            } else if (btn == 'cancel') {
                return;
            }
            Ext.Ajax.request({
                url:'archive!gdAfterSearch.action',
                params:{condition:param.condition,start:(param.start==null?0:param.start),limit:param.limit,modelName:modelName,treeId:param.treeId,type:param.type},
                success:function (r) {
                    if (r.responseText) {
                        alert(r.responseText);
                    }else{
                        alert("归档成功");
                    }
                    store.reload();
                }
            });


        },
        icon:Ext.MessageBox.QUESTION
    });

}

function hideAdvancedSearch() {
    $('#search-item').hide();
    store.setBaseParam('condition', '');
    store.load();
}

var ogDs, linkWin;

function showOriginal(archiveId, id) {
    var isArchive = !archiveId;
    var ids = getSelectIds(archiveId, id);
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个项目!');
        return false;
    }
    id = ids[0];
    ogDs = new Ext.data.JsonStore({
        url:'og!list.action?ownerId=' + id,
        autoLoad:true,
        totalProperty:'totalCount',
        root:'items',
        fields:[
            'id', 'name', 'fileSize', 'updateTime'
        ]
    });
    var ogSm = new Ext.grid.CheckboxSelectionModel();
    var formatSize = function (size, p, record) {
        return Ext.util.Format.fileSize(size);
    };
    var ogGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:ogDs,
        height:250,
        sm:ogSm,
        loadMask:true,
        stripeRows:true,
        region:'center',
        bbar:new Ext.PagingToolbar({
            pageSize:20, //每页显示几条数据
            store:ogDs,
            displayInfo:true,
            displayMsg:'{0} - {1} 共 {2} 条',
            emptyMsg:"没有记录返回" }),
        cm:new Ext.grid.ColumnModel([
            //new Ext.grid.RowNumberer(),//显示行号
            ogSm,
            {header:"名称", width:400, sortable:true, dataIndex:'name'},
            {header:"大小", width:100, sortable:true, dataIndex:'fileSize', renderer:formatSize},
            {header:"上传时间", width:150, sortable:true, dataIndex:'updateTime'}
        ]),
        tbar:[
            {
                text:'查看',
                iconCls:'preview',
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    }
                    var nids = [];
                    for (var i = 0; i < ogSm.getSelections().length; i++) {
                        nids.push(ogSm.getSelections()[i].data.id);
                    }
                    showPreview(nids);
                }
            },
            {
                text:'上传',
                iconCls:'upload',
                hidden:!perm.edit,
                handler:function () {
                    var getUrl = function (url) {
                        return getJsessionidUrl(url + '?modelName=' + (isArchive ? modelName : jnModelName));
                    };
                    var uploadDialog = new UploadDialog({
                        getUrl:getUrl,
                        maxSize:5368709120,
                        typeDescription:'所有文件',
                        autoClose:this.autoClose || true,
                        fileTypes:'*.*'
                    });
                    uploadDialog.on('close', function () {
                        ogDs.reload();
                    });
                    uploadDialog.show(id);
                }
            },
            {
                text:'关联',
                iconCls:'reset',
                hidden:!perm.edit,
                handler:function () {
                    if (linkWin != null) {
                        linkWin.show();
                    }
                    else
                        showLinkWin(id);
                }
            },
            {
                text:'打印',
                iconCls:'print',
                hidden:!perm.print,
                handler:function () {
                    var ssl=ogSm.getSelections().length;
                    if (ssl == 0) {
                        Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                        return;
                    } else if (ssl > 1) {
//                        var ids=[];
//                        for (var i=0;i<ssl;i++){
//                            ids.push(ogSm.getSelections()[i].data.id);
//                        }
                        Ext.MessageBox.alert('提示', '　　只能选择一个原文!　　');
                        return;
                    }else{
                        showPrint(ogSm.getSelections()[0].data.id);
                    }

                }
            },
            {
                text:'下载',
                iconCls:'download',
                hidden:!perm.download,
                handler:function () {
                    var ssl=ogSm.getSelections().length;
                    if (ssl == 0) {
                            Ext.MessageBox.alert('提示', '　　没有原文被选择!　　');
                            return;
                    } else if (ssl > 1) {
                            Ext.MessageBox.alert('提示', '　　只能选择一个原文!　　');
                            return;
                    }
                    window.open('og!get.action?preview=false&id=' + ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:"打包下载",
                iconCls:'download',
                hidden:<#if ctx.hasEnv('bengbu.enable')>false<#else>true</#if>,
                handler:function(){
                    var ssl=ogSm.getSelections().length;
                    if(ssl<1){
                        alert("请选择需要下载的原文!");
                    }else{
                        batchDownload(ogSm.getSelections());
                    }
                }
            },
            {
                text:"查看所有",
                iconCls:"preview",
                hidden:<#if ctx.hasEnv('bengbu.enable')>false<#else>true</#if>,
                handler:function(){
                      Ext.Ajax.request({
                         url:"og!allIds.action",
                          params:{ownerId:id},
                          success:function (r) {
                             var ids= Ext.decode(r.responseText);
                              showPreview(ids);
                          }
                      });
                }
            },
            {
                text:'权限',
                iconCls:'edit',
            hidden:<#if ctx.hasEnv('originalPermission.enable')>!perm.edit<#else>true</#if>,
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        Ext.MessageBox.alert('提示', '　没有原文被选择!　');
                        return;
                    }
                    setPermission(ogSm.getSelections()[0].data.id);
                }
            },
            {
                text:'删除',
                iconCls:'delete',
                hidden:!perm.edit,
                handler:function () {
                    if (ogSm.getSelections().length == 0) {
                        alert('　　没有原文被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(ogSm.getSelections(), function (s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url:'og!remove.action',
                        params:{id:p},
                        success:function (r) {
                            ogDs.reload();
                        }
                    });
                }
            },
            '->',
            new Ext.ux.form.SearchField({
                id:'searchBox1',
                style:{'margin':'0,0,0,150px'},
                store:ogDs,
                width:150,
                renderTo:'searchBox'
            })
        ],
        listeners:{
            rowdblclick:function (g, index, e) {
                if (perm.download) {
                    var id = ogDs.getAt(index).id;
                    showPreview([id]);
                }
            },
            render:function (g) {
                var store = g.getStore();
                var view = g.getView();
                g.tip = new Archive.OgTip({
                    dismissDelay:0,
                    target:view.mainBody,
                    delegate:'.x-grid3-row',
                    autoWidth:!Ext.isIE6,
                    renderTo:document.body,
                    listeners:{
                        beforeshow:function (tip) {
                            var rowIndex = view.findRowIndex(tip.triggerElement);
                            tip.body.update('<img src="' + 'og!thumb.action?modelName=' + modelName + '&id=' + store.getAt(rowIndex).id + '"/>');
                        }
                    }
                });
            }
        }
    });
    var ogWin = new Ext.Window({
        title:'原文',
        closable:true,
        modal:true,
        width:700,
        height:500,
        layout:'fit',
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    ogWin.close();
                    <#if ctx.hasEnv('jiangyin.enable')>
                    if(isArchive){
                        store.reload();
                    }
                    </#if>
                }
            }
        ],
        items:ogGrid
    });
    ogWin.show();
    return false;
}

/**
 * 批量下载原文
 */
function batchDownload(datas){
    var ids=[];
    for(var i=0;i<datas.length;i++){
             ids.push(datas[i].data.id);
    }
    window.open('og!getBatch.action?preview=false&id=' + ids);
}

function showLinkWin(id) {
    var tree = new Ext.tree.TreePanel({
        autoScroll:true,
        loader:new Ext.tree.TreeLoader(),
        root:new Ext.tree.AsyncTreeNode({
            id:"root",
            text:'/',
            iconCls:'root'
        }),
        listeners:{
            render:function (tree) {
                tree.getRootNode().expand(false, false);
            },
            beforeload:function (node) {
                this.loader.dataUrl = 'og!link.action?id=' + encodeURIComponent(node.id)
            }
        }
    });
    tree.on('checkchange', function (node, flag) {
        node.cascade(function (node) {
            node.attributes.checked = flag;
            node.ui.checkbox.checked = flag;
            return true;
        });
    });
    linkWin = new Ext.Window({
        title:'文件关联目录树',
        closable:true,
        modal:true,
        width:600,
        height:450,
        layout:'fit',
        border:false,
        resizable:false,
        closeAction:'hide',
        items:tree,
        buttons:[
            {
                text:'关联',
                handler:function () {
                    var ids = [];
                    var nodes = tree.getChecked();
                    for (var i = 0; i < nodes.length; i++) {
                        ids.push(nodes[i].id);
                    }
                    Ext.Ajax.request({
                        url:'og!saveLink.action?ownerId=' + id,
                        params:{id:ids},
                        success:function (r) {
                            Ext.MessageBox.alert("提示", "关联成功");
                            linkWin.hide();
                            for (var i = 0; i < nodes.length; i++) {
                                nodes[i].getUI().toggleCheck(false);
                                nodes[i].attributes.checked = false;
                            }
                            ogDs.load();
                        }
                    });
                }
            },
            {
                text:'关闭',
                handler:function () {
                    linkWin.hide();
                    ogDs.load();
                }
            }
        ]
    });
    linkWin.show();
}

function setPermission(id) {
    var pDs = new Ext.data.JsonStore({
        url:'og!listPermission.action?id=' + id,
        autoLoad:true,
        root:'items',
        fields:['id', 'userId', 'userName', 'operation', 'expireTime']
    });
    var pSm = new Ext.grid.CheckboxSelectionModel();
    var pGrid = new Ext.grid.GridPanel({
        cls:'og',
        border:true,
        ds:pDs,
        height:250,
        sm:pSm,
        loadMask:true,
        stripeRows:true,
        region:'center',
        cm:new Ext.grid.ColumnModel([
            pSm,
            {header:"用户", width:100, sortable:true, dataIndex:'userName'},
            {header:"权限", width:200, sortable:true, dataIndex:'operation', renderer:function (v) {
                return v == 'download' ? '下载' : '查看';
            }},
            {header:"到期时间", width:200, sortable:true, dataIndex:'expireTime'}
        ]),
        tbar:[
            {
                iconCls:'add',
                text:'添加',
                handler:function () {
                    var fp = new Ext.FormPanel({
                        labelWidth:80,
                        url:'og!addPermission.action?op.originalId=' + id,
                        frame:true,
                        border:false,
                        bodyStyle:'padding:5px',
                        defaultType:'textfield',
                        items:[
                            {
                                xtype:'combo',
                                fieldLabel:'用户',
                                hiddenName:'op.userId',
                                store:new Ext.data.JsonStore({
                                    url:'og!listUsers.action',
                                    fields:['userId', 'userName']
                                }),
                                minChars:1,
                                valueField:'userId',
                                displayField:'userName',
                                mode:'remote',
                                typeAhead:false,
                                triggerAction:'all',
                                loadingText: '获取中...',
                                anchor:'100%',
                                listeners:{
                                    'select':function (cb, record) {
                                        fp.form.findField('op.userName').setValue(record.data['userName']);
                                    }
                                }
                            },
                            {
                                xtype:'combo',
                                fieldLabel:'权限',
                                hiddenName:'op.operation',
                                store:new Ext.data.ArrayStore({
                                    fields:['name', 'value'],
                                    data:[
                                        ["查看", 'view'],
                                        ['下载', 'download']
                                    ]
                                }),
                                value:'download',
                                valueField:'value',
                                displayField:'name',
                                typeAhead:true,
                                mode:'local',
                                triggerAction:'all',
                                anchor:'100%'
                            },
                            {
                                fieldLabel:'到期时间',
                                xtype:'datefield',
                                name:'op.expireTime',
                                anchor:'100%',
                                format:'Y-m-d'
                            },
                            {
                                xtype:'hidden',
                                name:'op.userName'
                            }
                        ],
                        buttons:[
                            {
                                text:'保存',
                                handler:function () {
                                    if (fp.getForm().isValid()) {
                                        fp.getForm().submit({
                                            waitMsg:'正在保存...',
                                            success:function () {
                                                addWin.close();
                                                pDs.reload();
                                            },
                                            failure:function (fp, action) {
                                                Ext.MessageBox.alert('失败', '保存失败');
                                            },
                                            scope:this
                                        });
                                    }
                                },
                                scope:this
                            },
                            {
                                text:'关闭',
                                handler:function () {
                                    addWin.close();
                                }
                            }
                        ]
                    });
                    var addWin = new Ext.Window({
                        title:'原文权限',
                        closable:true,
                        modal:true,
                        width:300,
                        height:200,
                        layout:'fit',
                        border:false,
                        resizable:false,
                        items:fp
                    });
                    addWin.show();
                }
            },
            {
                iconCls:'delete',
                text:'删除',
                handler:function () {
                    if (pSm.getSelections().length == 0) {
                        alert('　　没有权限被选择!　　');
                        return;
                    }
                    if (!confirm('确定要删除吗？'))
                        return;
                    var p = [];
                    Ext.each(pSm.getSelections(), function (s) {
                        p.push(s.data.id);
                    });
                    Ext.Ajax.request({
                        url:'og!removePermission.action',
                        params:{id:p},
                        success:function (r) {
                            pDs.reload();
                        }
                    });
                }
            }
        ]
    });
    var pWin = new Ext.Window({
        title:'原文权限',
        closable:true,
        modal:true,
        width:600,
        height:400,
        layout:'fit',
        border:false,
        resizable:false,
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    pWin.close();
                }
            }
        ],
        items:pGrid
    });
    pWin.show();
}

function showPreview(nids) {
    if (!Ext.isDefined(window.hasEPreOcx)) {
        try {
            new ActiveXObject('GtisOcxShowProj1.GtisOcxShow');
            window.hasEPreOcx = true;
        } catch (e) {
            window.hasEPreOcx = false;
        }
    }
    if (window.hasEPreOcx) {
        var base = location.href.substring(0, location.href.lastIndexOf('/'));
        var link = getJsessionidUrl(base + '/og!preview.action?idsKey=');
        link = link.substr(link.indexOf('//') + 2);
        Ext.Ajax.request({
            url:'archive!cacheIds.action',
            params:{id:nids},
            success:function (r) {
                debugger;
                var json = Ext.decode(r.responseText);
                location.href = 'epre://'+link + json['idsKey'];
            }
        });
    } else {
        window.open('og!get.action?preview=true&id=' + nids[0]);
    }
}

function showPrint(id) {
     debugger;
    var width = 0, height = 0, srcWidth, srcHeight;
    var win = new Ext.Window({
        cls:'og',
        title:'打印原文',
        closable:true,
        modal:true,
        width:Ext.lib.Dom.getViewWidth() * .9,
        height:Ext.lib.Dom.getViewHeight() * .9,
        border:false,
        resizable:false,
        tbar:[
            {
                text:'打印',
                iconCls:'print',
                handler:function () {
                    var print = Ext.getDom('printFrame').contentWindow.webPrint;
                    var link = location.href;
                    print.ContentURL = getJsessionidUrl(link.substring(0, link.lastIndexOf('/')) + '/og!print.action?id=' + id + (width > 0 ? '&width=' + width : '') + (height ? '&height=' + height : ''));
                    print.marginBottom = print.marginLeft = print.marginRight = print.marginTop = 0;
                    print.Preview();
                }
            },
            {
                text:'放大',
                iconCls:'zoom-out',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 1.2;
                    img.height = height = height * 1.2;
                }
            },
            {
                text:'缩小',
                iconCls:'zoom-in',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    if (!width)
                        srcWidth = width = img.width;
                    if (!height)
                        srcHeight = height = img.height;
                    img.width = width = width * 0.8;
                    img.height = height = height * 0.8;
                }
            },
            {
                text:'默认大小',
                iconCls:'reset',
                handler:function () {
                    var img = Ext.getDom('printFrame').contentWindow.document.getElementById('printImg');
                    img.width = width = srcWidth;
                    img.height = height = srcHeight;
                }
            }
        ],
        buttons:[
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="auto" frameborder="0" style="width:100%;height:100%;" src="og!print.action?id=' + id + '" id="printFrame"></iframe>'
    });
    win.show();
    return false;
}

function gdArchive() {
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
        return;
    }
    if (confirm('确定要归档吗？')) {
        Ext.Ajax.request({
            url:'archive!gd.action?modelName=' + modelName,
            params:{id:ids},
            success:function (r) {
                if (r.responseText) {
                    alert(r.responseText);
                }
                store.reload();
            }
        });
    }
}

function cxgdArchive() {
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
        return;
    }
    if (confirm('确定要撤销归档吗？')) {
        Ext.Ajax.request({
            url:'archive!cxgd.action?modelName=' + modelName,
            params:{id:ids},
            success:function (r) {
                if (r.responseText) {
                    alert(r.responseText);
                }
                store.reload();
            }
        });
    }
}

var isBl;
function blArchive(id) {
    var ids = getSelectIds(archiveId, id);
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个项目!');
        return false;
    }
    id = ids[0];
    win = new Ext.Window({
        title:'补录档案',
        closable:true,
        modal:true,
        width:400,
        height:130,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'归档',
                hidden:!perm.edit,
                handler:function () {
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                    isBl = true;
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="archive-entity!bl.action?modelName=' + modelName + '&treeId=' + treeId + (id ? '&id=' + id : '') + '" id="archiveFrame"></iframe>'
    });
    win.show();
    return false;
}

var isMarkUp;
/**
 * 档案补录，金坛需求
 */
function makeUpArchive(){
    win = new Ext.Window({
        title:"档案补录",
        modal:true,
        width:400,
        height:300,
        border:false,
        buttons:[
            {
                text:"补录",
                hidden:!perm.edit,
                handler:function(){
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                    isMarkUp = true;
                }
            },
            {
                text:"关闭",
                handler:function(){
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="archive-entity.action?makeUp=true&modelName=' + modelName + '&treeId=' + treeId + '" id="archiveFrame"></iframe>'
    });
    win.show();
}

function fastOrganize() {
    window.open('archive!fastGd.action?modelName=' + modelName + '&treeId=' + treeId);
}

/**
 * 快速原文补录
 */
function fastAddOriginal(){
    window.open('archive!fastAddOG.action?modelName='+modelName+'&treeId='+treeId+"&type=all");
}

function delDocument(archiveId, id) {
    var ids = getSelectIds(archiveId, id);
    if (ids.length == 0) {
        alert('请至少选择一个卷内!');
    }
    else {
        if (confirm('确定要删除吗？')) {
            Ext.Ajax.request({
                url:'doc!remove.action?modelName=' + jnModelName,
                params:{id:ids},
                success:function (r) {
                    reloadDocuments(archiveId);
                }
            });
        }
    }
}

var docWin;
function showDocument(id, archiveId) {
    docWin = new Ext.Window({
        title:id ? '编辑卷内' : '添加卷内',
        closable:true,
        modal:true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'保存',
                handler:function () {
                    window.archiveId = archiveId;
                    $('#documentFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    docWin.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="doc-entity.action?modelName=' + jnModelName + (id ? '&id=' + id : '') + (archiveId ? '&archiveId=' + archiveId : '') + '" id="documentFrame"></iframe>'
    });
    docWin.show();
    iframeType="doc";
    return false;
}

function editDocument(archiveId) {
    var ids = getSelectIds(archiveId);
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个卷内!');
    }
    else {
        showDocument(ids.pop(), archiveId);
    }
}

/**
 * 显示档案
 * @param id
 */
function showArchive(id) {
    var add=false;
    if(archiveSaveType=="SaveAndAddNew") {
        add=true;
    }
    if (isBl) {
        isBl = false;
        return false;
    }
    if(tree!=null&&tree.getChecked("id").length>1&&id==null){
            return;
    }

    win = new Ext.Window({
        title:id ? '编辑档案' : '添加档案',
        closable:true,
        modal:true,
        width:400,
        height:320,
        border:false,
        resizable:false,
        buttons:[
            <#if ctx.hasEnv('jurong.enable')>
            {
                text:'添加卷内',
                hidden:(!id),
                handler:function(){
                    showDocument(null,id);
                }
            },
            <#if isShowArchiveInfo>
            {
                text:'卷内信息',
                hidden: (!id),
                handler:function(){
                     showArchiveInfo(id);
                }
            },
            </#if>
            </#if>
            {
                text:'添加原文',
                hidden:(!perm.edit) || (!id),
                handler:function () {
                    showOriginal(null, $('#archiveFrame')[0].contentWindow.getArchiveId());
                }
            },
            {
                text:'续添档案',
                hidden:!perm.edit,
                handler:function () {
                    archiveSaveType = 'SaveAndAdd';
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'新增档案',
                hidden:!perm.edit,
                handler:function () {
                    archiveSaveType = 'SaveAndAddNew';
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'保存',
                hidden:!perm.edit,
                handler:function () {
                    archiveSaveType = 'onlySave';
                    $('#archiveFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="archive-entity.action?modelName=' + modelName+'&add='+add+ '&treeId=' + treeId + (id ? '&id=' + id : '') + '" id="archiveFrame"></iframe>'
    });
    win.show();
    iframeType="arc";
    _curAId = id;
    return false;
}

function editArchive(id) {
    if (id) {
        showArchive(id);
    }
    var ids = getSelectIds();
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个档案!');
    }
    else {
        showArchive(ids.pop());
    }
}

function showNote(id, archiveId) {
    var ids = getSelectIds(archiveId, id);
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个项目!');
        return false;
    }
    archiveId = ids;
    win = new Ext.Window({
        title:id ? '编辑备考表' : '编辑备考表',
        closable:true,
        modal:true,
        width:400,
        height:280,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'保存',
                handler:function () {

                    window.archiveId = archiveId;
                    $('#noteFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="note-entity.action?modelName=Note' + (id ? '&id=' + id : '') + (archiveId ? '&archiveId=' + archiveId : '') + '" id="noteFrame"></iframe>'
    });
    win.show();
    return false;

}

function showMetadata(id, archiveId) {
    var ids = getSelectIds(archiveId, id);
    if (ids.length > 1 || ids.length == 0) {
        alert('请选择一个项目!');
        return false;
    }
    archiveId = ids;
    win = new Ext.Window({
        title:'元数据',
        closable:true,
        modal:true,
        width:600,
        height:350,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'保存',
                handler:function () {
                    window.archiveId = archiveId;
                    $('#metadataFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="metadata-entity.action?archiveId=' + archiveId + '" id="metadataFrame"></iframe>'
    });
    win.show();
    return false;
}

function showLoan(id, archiveId) {

    var ids = getSelectIds(archiveId, id);
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
        return;
    }
    var model=modelName;
    win = new Ext.Window({
        title:id ? '借阅登记' : '借阅登记',
        closable:true,
        modal:true,
        width:400,
        height:240,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'立即归还',
                hidden:<#if ctx.hasEnv('jiangyin.enable')>false<#else >true</#if>,
                handler:function(){
                    $('#loanFrame')[0].contentWindow.backNow();
                    $('#loanFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'借阅',
                handler:function () {
                    $('#loanFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'关闭',
                handler:function () {
                    win.close();
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="loan-entity.action?modelName=Loan&type='+modelName+"&"+ Ext.urlEncode({archiveId:ids}) + '" id="loanFrame"></iframe>'
    });
    win.show();
}

/**
 * 显示案卷卷内信息
 * @param archiveId
 */
function showArchiveInfo(archiveId){
    if(!archiveId)
        archiveId = $('#archiveFrame')[0].contentWindow.getArchiveId();
    if(!archiveId) return;
    _curAId = archiveId;
    if(win) win.close();
    win = new Ext.Window({
        title:'卷内信息',
        closable:true,
        modal:true,
        width:400,
        height:300,
        border:false,
        resizable:false,
        buttons:[
            {
                text:'保存',
                handler:function(){
                    $('#archiveInfoFrame')[0].contentWindow.doSubmit();
                }
            },
            {
                text:'打印',
                handler:function(){
                    var ainfoId = $('#archiveInfoFrame')[0].contentWindow.getArchiveId();
                    var param = {start:0,limit:-1,id:ainfoId,archiveId:archiveId};
                    var base = location.href.substring(0, location.href.lastIndexOf('/'));
//                    var printUrl = getJsessionidUrl(base + '/archive-info!fr3.action?modelName=' + modelName+"_ai");

                    var printUrl;

                    <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
                        var printType= window.localStorage.printType;
                        var localPath=window.localStorage.localPath;
                        if(printType=="Local"&&localPath==null) return alert("非IE浏览器无法验证本地模版文件，建议使用IE8+");
                        if(printType==null||printType=="Local"){
                            printUrl = localPath+"archiveinfo.fr3";
                        }else{
                            printUrl = getJsessionidUrl(base + '/archive-info!fr3.action?modelName=' + modelName+"_ai");
                        }
                    <#else >
                        printUrl = getJsessionidUrl(base + '/archive-info!fr3.action?modelName=' + modelName+"_ai");
                    </#if>

                    var dataUrl = getJsessionidUrl(base + '/archive-info!print.action?modelName=' + modelName + '_ai&' + Ext.urlEncode(param));
//                    prompt('',dataUrl);
                    location.href = 'eprt://v2|frURL=' + printUrl + '|dataURL=' + dataUrl;
                }
            },
            {
                text:'关闭',
                handler:function(){
                    win.close();
                    showArchive(archiveId);
                }
            }
        ],
        html:'<iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;margin:10px 0 0 10px;" src="archiveinfo-entity.action?modelName='+modelName+'_ai&archiveModel='+modelName+'&' + Ext.urlEncode({archiveId:archiveId}) + '" id="archiveInfoFrame"></iframe>'
    });
    win.show();
    iframeType="arc";
}

function moveArchive() {
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
        return;
    }
    var tree = new Ext.tree.TreePanel({
        autoScroll:true,
        root:new Ext.tree.AsyncTreeNode({
            id:'rootNode',
            text:'未分类',
            iconCls:'root',
            children:json
        })
    });
    var moveWin = new Ext.Window({
        title:'移动案卷',
        closable:true,
        modal:true,
        width:500,
        height:400,
        layout:'fit',
        border:false,
        resizable:false,
        buttons:[
            {
                text:'保存',
                handler:function () {
                    var ids = getSelectIds();
                    var treeId = tree.getSelectionModel().getSelectedNode().id;
                    Ext.Ajax.request({
                        url:'archive!move.action?modelName=' + modelName,
                        params:{id:ids, treeId:treeId == 'rootNode' ? '' : treeId},
                        success:function (r) {
                            store.reload();
                            moveWin.close();
                        }
                    });
                }
            },
            {
                text:'关闭',
                handler:function () {
                    moveWin.close();
                }
            }
        ],
        items:tree
    });
    moveWin.show();
    tree.getRootNode().expand(false, false);
}

function onResize(w, h ) {
    if(iframeType=='doc'){
        docWin.setWidth(w + 40);
        docWin.setHeight(h + 90);
        docWin.center();
    }else{
        win.setWidth(w + 40);
        win.setHeight(h + 90);
        win.center();
    }
}

function delArchive(id) {
    if (id) {
        showArchive(id);
    }
    var ids = getSelectIds();
    if (ids.length == 0) {
        alert('请至少选择一个项目!');
    }
    else if (confirm('确定要删除吗？')) {
        Ext.Ajax.request({
            url:'archive!remove.action?modelName=' + modelName,
            params:{id:getSelectIds(null, id)},
            success:function (r) {
                store.reload();
            }
        });
    }
}

function onArchiveComplete(result, msg) {
    win.close();
    if (result) {
        if (archiveId) {
            reloadDocuments(archiveId);
        }
        else {
            store.reload();
        }
        if(isMarkUp) isMarkUp = false;
        else{
            debugger;
            if(archiveSaveType=='onlySave') showArchive(msg);
            else showArchive(null);
        }
    } else {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　',function(){
            if(isMarkUp) isMarkUp = false;
            else{
                if(archiveSaveType=='onlySave') showArchive(msg);
                else showArchive(null);
            }
        });
    }

}

function onDocumentComplete(result, msg) {
    docWin.close();
    if (result) {
        if (archiveId) {
            reloadDocuments(archiveId);
        }
        else {
            store.reload();
        }
        showDocument("",archiveId);
    } else {
        showDocument("",archiveId);
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    }
}

function onComplete(result, msg) {
    win.close();
    if (!result) {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    } else {
        Ext.MessageBox.alert('成功', '　　' + msg + '　　');
    }
}

function archiveInfoComplete(result,msg){
    if (!result) {
        Ext.MessageBox.alert('保存失败', '　　' + msg + '　　');
    } else {
        win.close();
        showArchiveInfo(_curAId);
    }
}

function getSelectIds(archiveId, id) {
    if (id)
        return [id];
    var ids = [];
    var ct = archiveId ? '#d' + archiveId : "#archivesCt";
    $(ct + ' [type="checkbox"]').each(function () {
        if ($(this).attr("checked")) {
            if (this.value)
                ids.push(this.value);
        }
    });
    return ids;
}

function getListIds() {
    var ids = [];
    var ct = "#archivesCt";
    $(ct + ' .chk-archive').each(function () {
        if (this.value)
            ids.push(this.value);
    });
    return ids;
}

var aOrder = 'ASC';

function archiveSortBy(field) {
    debugger;
    store.singleSort(field, aOrder);
    store.baseParams.dir=aOrder;
    store.baseParams.sort=field;
    aOrder = aOrder == 'ASC' ? 'DESC' : 'ASC';
    return false;
}

/**
 * 对象拷贝
 * @param obj
 * @return {*}
 */
function clone(obj){
    var objClone;
    if (obj.constructor == Object){
        objClone = new obj.constructor();
    }else{
        objClone = new obj.constructor(obj.valueOf());
    }
    for(var key in obj){
        if ( objClone[key] != obj[key] ){

            if ( typeof(obj[key]) == 'object' ){
                objClone[key] = clone(obj[key]);
            }else{
                objClone[key] = obj[key];
            }
        }
    }
    objClone.toString = obj.toString;
    objClone.valueOf = obj.valueOf;
    return objClone;
}

/**
 * 勾选多个分类时，获取其最小的权限
 * @param ids
 */
function getLeastPerm(ids){
    if(ids.length>1){
        var temp=tree.getNodeById(ids[0]).attributes['perm'];
        var tempPerm;
        var nextPerm;
        if(temp==null){
            tempPerm=0;
        } else{
            tempPerm=(temp.print ? 1:0)+(temp.edit ? 1:0);
        }
        for(var i=1;i<ids.length;i++){
            var next= tree.getNodeById(ids[i]).attributes['perm'];
            if(next==null){
                nextPerm=0;
            }else{
                 nextPerm=(next.print ? 1:0)+(next.edit ? 1:0);
            }
            if(nextPerm<tempPerm){
                temp=next;
            }
        }
        onPermChange(temp);
    }


}



$(function () {
    if (json.length) {
        <#if  ctx.env['classifyViewMode']=='checkbox'>
        var test=clone(json[0]);
        test.id='${treeId}';
        test.text="未分类";
        test.perm= ${permJson!'{}'};
        test.name=null;
        test.checked=true;
        json.splice(0,0,test);
        </#if>
        tree = new Ext.tree.TreePanel({
            width:143,
            renderTo:'treeBox',
            root:new Ext.tree.AsyncTreeNode({
                id:'rootNode',
                text:'未分类',
                iconCls:'root',
                children:json
            }),
            rootVisible:<#if ctx.env['classifyViewMode']=='checkbox'> false <#else> true </#if>,
            listeners:{
                <#if ctx.env['classifyViewMode']=='normal'>
                click:function (n) {
                    if (n.id == 'rootNode') {
                        treeId = '${treeId}';
                        perm = ${permJson!'{}'};
                    } else {
                        treeId = n.id;
                        perm = n.attributes['perm'];
                    }
                    store.setBaseParam('treeId', treeId);
                    onPermChange(perm);
                    store.load();
                } ,
                </#if>
                checkchange:function(node, checked){
                    var ids=tree.getChecked("id");
                    if(ids.length>0){
                        if(ids.length==1){
                            treeId=ids.toString();
                            perm=tree.getNodeById(treeId).attributes['perm'];
                        }
                       else{
                            treeId=ids.toString();
                            var temPerm=clone(tree.getNodeById(ids[0]).attributes['perm']);
                            temPerm.print=false;
                            temPerm.edit=false;
                            temPerm.del=false;
                            temPerm.change=false;
                            temPerm.cxgd=false;
                            perm=temPerm;
                        }
                    }else{
                        treeId='${treeId}';
                        perm = ${permJson!'{}'};
                        var node=tree.getNodeById('${treeId}');
                        node.attributes.checked = true;
                        node.ui.toggleCheck(true);
                    }
                    store.setBaseParam('treeId', treeId);
                    onPermChange(perm);
                    store.load();
                }
            }
        });
        tree.getRootNode().expand(false, false);
        tree.getRootNode().select();
        tree.on('checkchange',function(node,checked){
            node.expand();
            node.attributes.checked = checked;
            node.eachChild(function(child) {
                child.ui.toggleCheck(checked);
                child.attributes.checked = checked;
            });
        },tree);
    } else {
        $('#treeBox-ct').hide();
    }
    store = new Ext.data.JsonStore({
        url:'archive!list.action?modelName=' + modelName,
        root:'items',
        totalProperty:'totalCount',
        fields:[
            'id','hasOriginal',<#list showFields?keys as name>, '${name}'</#list>
        ],
        baseParams:{limit:${limit}, treeId:treeId}
    });

    var tpl = Ext.XTemplate.from('archiveTpl');
    var dv = new Ext.DataView({
        store:store,
        tpl:tpl,
        autoHeight:true,
        overClass:'x-view-over',
        itemSelector:'tr.a-item',
        emptyText:'',
        renderTo:'archivesCt'
    });
    pageToolBar=new Ext.PagingToolbar({
        plugins:new Ext.ux.ComboPageSize({ addToItem:false, prefixText:'每页', postfixText:'条'}),
        renderTo:'pagingToolbar',
        pageSize: ${limit},
        store:store,
        displayInfo:true,
        displayMsg:'{0} - {1} 共 {2} 条',
        emptyMsg:"没有记录返回"
    });
    var sb=new Ext.ux.form.SearchField({
        store:store,
        width:150,
        renderTo:'searchBox'
    });
    <#if id??>
        changeArchiveType('${type!}', true);
        sb.setRawValue('${id}');
        sb.onTrigger2Click();
    <#elseif ctx.env['classifyViewMode']=='checkbox'>
        changeArchiveType('all');
    <#else>
        changeArchiveType('ygd');
    </#if>
    onPermChange(perm);
    debugger;
    $("#archivesCt").width($("#dataList").width());
});

/**
 * 验证本地文件是否存在
 */
function fileExist(filePath){
    var fso =new ActiveXObject("Scripting.FileSystemObject");
    if (fso.FileExists(filePath))
        return true;
    return false;
}

/**
 * 下一页
 */
function nextPage(){
    var pageIndex=parseInt(pageToolBar.cursor/pageToolBar.pageSize)+1;
    var pageCount=parseInt(store.totalLength/pageToolBar.pageSize)+1;
    if(pageIndex<pageCount)
        pageToolBar.changePage(pageIndex+1);
}
/**
 * 上一页
 */
function perviousPage(){
    debugger;
    var pageIndex=parseInt(pageToolBar.cursor/pageToolBar.pageSize)+1;
    if(pageIndex-1>0)
        pageToolBar.changePage(pageIndex-1);
}
</script>
</@layout.main>
