package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 宣传工作台账登记
 * Generated 2013-9-23 9:26:28 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_xcgz")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Xcgz {
    static final MODEL_NAME = Xcgz.class.getSimpleName();
    static final ENTITY_NAME = "宣传工作台账登记";
    static final FIELD_RQ = "日期";
    static final FIELD_DD = "地点";
    static final FIELD_FS = "方式";
    static final FIELD_XCRY = "宣传人员";
    static final FIELD_XCNR = "宣传内容";
    static final FIELD_XCXG = "宣传效果";
    static final FIELD_BZ = "备注";
    static final FIELD_DWDM = "单位代码";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 日期 
     */
    @Column(length = 100)
    String rq;

    /**
     * 地点 
     */
    @Column(length = 100)
    String dd;

    /**
     * 方式 
     */
    @Column(length = 100)
    String fs;

    /**
     * 宣传人员 
     */
    @Column(length = 1000)
    String xcry;

    /**
     * 宣传内容 
     */
    @Column(length = 1000)
    String xcnr;

    /**
     * 宣传效果 
     */
    @Column(length = 100)
    String xcxg;

    /**
     * 备注 
     */
    @Column(length = 100)
    String bz;

    /**
     * 单位代码 
     */
    @Column(length = 100)
    String dwdm;
}