package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 档案库房温湿度登记
 * Generated 2013-9-23 9:26:26 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_wsddj")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Wsddj {
    static final MODEL_NAME = Wsddj.class.getSimpleName();
    static final ENTITY_NAME = "档案库房温湿度登记";
    static final FIELD_DJRQ = "登记日期";
    static final FIELD_SWTQ = "上午天气";
    static final FIELD_XWTQ = "下午天气";
    static final FIELD_SWSJ = "上午时间";
    static final FIELD_XWSJ = "下午时间";
    static final FIELD_SWWD = "上午温度℃";
    static final FIELD_XWWD = "下午温度℃";
    static final FIELD_SWSD = "上午湿度%";
    static final FIELD_XWSD = "下午湿度%";
    static final FIELD_SWCLFS = "上午处理方式";
    static final FIELD_XWCLFS = "下午处理方式";
    static final FIELD_SWJLR = "上午记录人";
    static final FIELD_XWJLR = "下午记录人";
    static final FIELD_SWBZ = "上午备注";
    static final FIELD_XWBZ = "下午备注";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 登记日期 
     */
    Date djrq;

    /**
     * 上午天气 
     */
    @Column(length = 100)
    String swtq;

    /**
     * 下午天气 
     */
    @Column(length = 100)
    String xwtq;

    /**
     * 上午时间 
     */
    @Column(length = 100)
    String swsj;

    /**
     * 下午时间 
     */
    @Column(length = 100)
    String xwsj;

    /**
     * 上午温度℃ 
     */
    @Column(length = 100)
    String swwd;

    /**
     * 下午温度℃ 
     */
    @Column(length = 100)
    String xwwd;

    /**
     * 上午湿度% 
     */
    @Column(length = 100)
    String swsd;

    /**
     * 下午湿度% 
     */
    @Column(length = 100)
    String xwsd;

    /**
     * 上午处理方式 
     */
    @Column(length = 100)
    String swclfs;

    /**
     * 下午处理方式 
     */
    @Column(length = 100)
    String xwclfs;

    /**
     * 上午记录人 
     */
    @Column(length = 100)
    String swjlr;

    /**
     * 下午记录人 
     */
    @Column(length = 100)
    String xwjlr;

    /**
     * 上午备注 
     */
    @Column(length = 100)
    String swbz;

    /**
     * 下午备注 
     */
    @Column(length = 100)
    String xwbz;
}