package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 图书登记
 * Generated 2013-9-23 9:26:26 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_tsdj")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Tsdj {
    static final MODEL_NAME = Tsdj.class.getSimpleName();
    static final ENTITY_NAME = "图书登记";
    static final FIELD_DJRQ = "登记日期";
    static final FIELD_DJHM = "登记号码";
    static final FIELD_SM = "书名";
    static final FIELD_ZZ = "著者或译者";
    static final FIELD_CBZ = "出版者";
    static final FIELD_BQ = "版期";
    static final FIELD_YS = "页数";
    static final FIELD_KB = "开本";
    static final FIELD_ZD = "装订";
    static final FIELD_LY = "来源";
    static final FIELD_CS = "册数";
    static final FIELD_JM = "价目（元）";
    static final FIELD_FLH = "分类号";
    static final FIELD_SCH = "书次号";
    static final FIELD_JJ = "简介";
    static final FIELD_ML = "目录";
    static final FIELD_BZ = "备注";
    static final FIELD_BC = "版次";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 登记日期 
     */
    Date djrq;

    /**
     * 登记号码 
     */
    @Column(length = 100)
    String djhm;

    /**
     * 书名 
     */
    @Column(length = 100)
    String sm;

    /**
     * 著者或译者 
     */
    @Column(length = 100)
    String zz;

    /**
     * 出版者 
     */
    @Column(length = 100)
    String cbz;

    /**
     * 版期 
     */
    @Column(length = 100)
    String bq;

    /**
     * 页数 
     */
    @Column(length = 100)
    String ys;

    /**
     * 开本 
     */
    @Column(length = 100)
    String kb;

    /**
     * 装订 
     */
    @Column(length = 100)
    String zd;

    /**
     * 来源 
     */
    @Column(length = 100)
    String ly;

    /**
     * 册数 
     */
    @Column(length = 100)
    String cs;

    /**
     * 价目（元） 
     */
    @Column(length = 100)
    String jm;

    /**
     * 分类号 
     */
    @Column(length = 100)
    String flh;

    /**
     * 书次号 
     */
    @Column(length = 100)
    String sch;

    /**
     * 简介 
     */
    @Column(length = 500)
    String jj;

    /**
     * 目录 
     */
    @Column(length = 100)
    String ml;

    /**
     * 备注 
     */
    @Column(length = 100)
    String bz;

    /**
     * 版次 
     */
    @Column(length = 100)
    String bc;
}