package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 档案交接登记
 * Generated 2013-9-23 9:26:27 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_jjdj")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Jjdj {
    static final MODEL_NAME = Jjdj.class.getSimpleName();
    static final ENTITY_NAME = "档案交接登记";
    static final FIELD_JJRQ = "交接日期";
    static final FIELD_YJDW = "移交单位";
    static final FIELD_YJR = "移交人";
    static final FIELD_JSR = "接收人";
    static final FIELD_YJSL = "移交数量（总）";
    static final FIELD_DW = "单位";
    static final FIELD_AJSSND = "案卷所属年度";
    static final FIELD_MC = "名称";
    static final FIELD_LB = "类别";
    static final FIELD_GDRQ = "归档日期";
    static final FIELD_ZCC = "暂存处";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 交接日期 
     */
    @Column(length = 100)
    String jjrq;

    /**
     * 移交单位 
     */
    @Column(length = 100)
    String yjdw;

    /**
     * 移交人 
     */
    @Column(length = 100)
    String yjr;

    /**
     * 接收人 
     */
    @Column(length = 100)
    String jsr;

    /**
     * 移交数量（总） 
     */
    @Column(length = 100)
    String yjsl;

    /**
     * 单位 
     */
    @Column(length = 100)
    String dw;

    /**
     * 案卷所属年度 
     */
    @Column(length = 100)
    String ajssnd;

    /**
     * 名称 
     */
    @Column(length = 100)
    String mc;

    /**
     * 类别 
     */
    @Column(length = 100)
    String lb;

    /**
     * 归档日期 
     */
    Date gdrq;

    /**
     * 暂存处 
     */
    @Column(length = 100)
    String zcc;
}