package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 档案利用典型事例
 * Generated 2013-9-23 9:26:29 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_dalydxsl")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Dalydxsl {
    static final MODEL_NAME = Dalydxsl.class.getSimpleName();
    static final ENTITY_NAME = "档案利用典型事例";
    static final FIELD_LYDW = "利用单位";
    static final FIELD_LYRXM = "利用人姓名";
    static final FIELD_JYRQ = "借阅日期";
    static final FIELD_DH = "档号";
    static final FIELD_LYFS = "利用方式";
    static final FIELD_CYNR = "查阅内容";
    static final FIELD_LYMD = "利用目的和效果";
    static final FIELD_TBDW = "填表单位";
    static final FIELD_TBR = "填表人";
    static final FIELD_TBRQ = "填表日期";
    static final FIELD_DWDM = "单位代码";
    static final FIELD_MLH = "目录号";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 利用单位 
     */
    @Column(length = 100)
    String lydw;

    /**
     * 利用人姓名 
     */
    @Column(length = 100)
    String lyrxm;

    /**
     * 借阅日期 
     */
    @Column(length = 100)
    String jyrq;

    /**
     * 档号 
     */
    @Column(length = 100)
    String dh;

    /**
     * 利用方式 
     */
    @Column(length = 100)
    String lyfs;

    /**
     * 查阅内容 
     */
    @Column(length = 100)
    String cynr;

    /**
     * 利用目的和效果 
     */
    @Column(length = 100)
    String lymd;

    /**
     * 填表单位 
     */
    @Column(length = 100)
    String tbdw;

    /**
     * 填表人 
     */
    @Column(length = 100)
    String tbr;

    /**
     * 填表日期 
     */
    @Column(length = 100)
    String tbrq;

    /**
     * 单位代码 
     */
    @Column(length = 100)
    String dwdm;

    /**
     * 目录号 
     */
    @Column(length = 100)
    String mlh;
}