package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <p>
 * 编研材料目录
 * Generated 2013-9-23 9:26:29 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_byclml")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Byclml {
    static final MODEL_NAME = Byclml.class.getSimpleName();
    static final ENTITY_NAME = "编研材料目录";
    static final FIELD_LB = "类别";
    static final FIELD_CS = "册数";
    static final FIELD_QND = "起年代";
    static final FIELD_ZND = "止年代";
    static final FIELD_BYSJ = "编研时间";
    static final FIELD_MC = "名称";
    static final FIELD_BZ = "备注";

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    String modelName = getClass().getSimpleName();

    /**
     * 类别 
     */
    @Column(length = 100)
    String lb;

    /**
     * 册数 
     */
    @Column(length = 100)
    String cs;

    /**
     * 起年代 
     */
    @Column(length = 100)
    String qnd;

    /**
     * 止年代 
     */
    @Column(length = 100)
    String znd;

    /**
     * 编研时间 
     */
    @Column(length = 100)
    String bysj;

    /**
     * 名称 
     */
    @Column(length = 100)
    String mc;

    /**
     * 备注 
     */
    @Column(length = 100)
    String bz;
}