package com.gtis.archive.entity

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;

/**
 * <p>
 * 文书档案
 * Generated 2013-9-23 9:26:23 by Model Code Generater 1.0
 * </p>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_archive_wsda")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class Wsda extends Archive {
    static final MODEL_NAME = Wsda.class.getSimpleName();
    static final ENTITY_NAME = "文书档案";
    static final FIELD_JH = "件号";
    static final FIELD_ZWRQ = "制文日期";
    static final FIELD_WH = "文号";
    static final FIELD_ZRZ = "责任者";
    static final FIELD_GB = "稿本";
    static final FIELD_WZ = "文种";
    static final FIELD_ZTGG = "载体规格";
    static final FIELD_ZTLX = "载体类型";
    static final FIELD_ZTDW = "载体单位";
    static final FIELD_DAGDH = "档案馆代号";
    static final FIELD_DZWDH = "电子文档号";
    static final FIELD_SWH = "缩微号";
    static final FIELD_ZTSL = "载体数量";
    static final FIELD_QWBS = "全文标识";
    static final FIELD_ZTC = "主题词";
    static final FIELD_ZBBM = "主办部门";
    static final FIELD_XBBM = "协办部门";
    static final FIELD_GBJH = "馆编件号";
    static final FIELD_JGWTH = "机构问题号";
    static final FIELD_HH = "盒号";
    static final FIELD_FJBH = "附件编号";
    static final FIELD_SMTX = "扫描图像";
    static final FIELD_TXWJDYML = "图像文件对应目录";
    static final FIELD_ZBS = "总标识";
    static final FIELD_RQ = "日期";
    static final FIELD_LSH = "lsh";
    static final FIELD_ZRR = "责任人";
    static final FIELD_FS = "fs";
    static final FIELD_CLQK = "clqk";
    static final FIELD_SBJH = "sbjh";
    static final FIELD_DHBF = "档号备份";
    static final FIELD_LX = "lx";
    static final FIELD_CWRQ = "cwrq";
    static final FIELD_DJRQ = "djrq";
    static final FIELD_LWDW = "lwdw";
    static final FIELD_QSR = "qsr";
    static final FIELD_CYQK = "cyqk";
    static final FIELD_FWRQ = "fwrq";
    static final FIELD_FWLX = "fwlx";
    static final FIELD_NGR = "ngr";
    static final FIELD_HGR = "hgr";
    static final FIELD_QFR = "qfr";
    static final FIELD_ZSDW = "zsdw";
    static final FIELD_CSDWCBDW = "csdwcbdw";
    static final FIELD_HQ = "hq";
    static final FIELD_SYS_WH = "sys_wh";
    static final FIELD_DJH = "地籍号";
    static final FIELD_DH = "";


    /**
     * 件号 
     */
    @Column(length = 100)
    String jh;

    /**
     * 制文日期 
     */
    Date zwrq;

    /**
     * 文号 
     */
    @Column(length = 100)
    String wh;

    /**
     * 责任者 
     */
    @Column(length = 100)
    String zrz;

    /**
     * 稿本 
     */
    @Column(length = 100)
    String gb;

    /**
     * 文种 
     */
    @Column(length = 100)
    String wz;

    /**
     * 载体规格 
     */
    @Column(length = 100)
    String ztgg;

    /**
     * 载体类型 
     */
    @Column(length = 100)
    String ztlx;

    /**
     * 载体单位 
     */
    @Column(length = 100)
    String ztdw;

    /**
     * 档案馆代号 
     */
    @Column(length = 100)
    String dagdh;

    /**
     * 电子文档号 
     */
    @Column(length = 100)
    String dzwdh;

    /**
     * 缩微号 
     */
    @Column(length = 100)
    String swh;

    /**
     * 载体数量 
     */
    Integer ztsl;

    /**
     * 全文标识 
     */
    @Column(length = 100)
    String qwbs;

    /**
     * 主题词 
     */
    @Column(length = 100)
    String ztc;

    /**
     * 主办部门 
     */
    @Column(length = 100)
    String zbbm;

    /**
     * 协办部门 
     */
    @Column(length = 100)
    String xbbm;

    /**
     * 馆编件号 
     */
    Integer gbjh;

    /**
     * 机构问题号 
     */
    @Column(length = 100)
    String jgwth;

    /**
     * 盒号 
     */
    @Column(length = 100)
    String hh;

    /**
     * 附件编号 
     */
    @Column(length = 100)
    String fjbh;

    /**
     * 扫描图像 
     */
    @Column(length = 100)
    String smtx;

    /**
     * 图像文件对应目录 
     */
    @Column(length = 100)
    String txwjdyml;

    /**
     * 总标识 
     */
    @Column(length = 100)
    String zbs;

    /**
     * 日期 
     */
    @Column(length = 100)
    String rq;

    /**
     * lsh 
     */
    @Column(length = 200)
    String lsh;

    /**
     * 责任人 
     */
    @Column(length = 100)
    String zrr;

    /**
     * fs 
     */
    Long fs;

    /**
     * clqk 
     */
    @Column(length = 200)
    String clqk;

    /**
     * sbjh 
     */
    @Column(length = 100)
    String sbjh;

    /**
     * 档号备份 
     */
    @Column(length = 100)
    String dhbf;

    /**
     * lx 
     */
    Long lx;

    /**
     * cwrq 
     */
    Date cwrq;

    /**
     * djrq 
     */
    Date djrq;

    /**
     * lwdw 
     */
    @Column(length = 100)
    String lwdw;

    /**
     * qsr 
     */
    @Column(length = 100)
    String qsr;

    /**
     * cyqk 
     */
    @Column(length = 100)
    String cyqk;

    /**
     * fwrq 
     */
    Date fwrq;

    /**
     * fwlx 
     */
    @Column(length = 100)
    String fwlx;

    /**
     * ngr 
     */
    @Column(length = 100)
    String ngr;

    /**
     * hgr 
     */
    @Column(length = 100)
    String hgr;

    /**
     * qfr 
     */
    @Column(length = 100)
    String qfr;

    /**
     * zsdw 
     */
    @Column(length = 100)
    String zsdw;

    /**
     * csdwcbdw 
     */
    @Column(length = 100)
    String csdwcbdw;

    /**
     * hq 
     */
    @Column(length = 100)
    String hq;

    /**
     * sys_wh 
     */
    Long sys_wh;

    /**
     * 地籍号 
     */
    Long djh;

    /**
     *  
     */
    Long dh;
}