/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.CriteriaCallback;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexAction
implements Action {
    private static final long serialVersionUID = -465202185697219258L;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private DictService dictService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    private boolean hideBanner;
    private Boolean isA3d;
    private String id;
    private String modelName;
    private HashMap<String, Object> a3dFieldsMap;
    private Map<String, Boolean> sysPerms;
    @Autowired
    protected EntityService entityService;

    public void setHideBanner(boolean hideBanner) {
        this.hideBanner = hideBanner;
    }

    public List<Map<String, Object>> getTree() {
        return this.treeService.getTree(null, new String[]{"model"});
    }

    public String getAbl() {
        String currentDwdm = this.getDwdm();
        try {
            Struts2Utils.renderJson((Object)this.dictService.getItems("hc_" + currentDwdm), (String[])new String[0]);
        }
        catch (Exception ex) {
            Struts2Utils.renderJson((String)"NULL", (String[])new String[0]);
        }
        return null;
    }

    public List<Map<String, String>> getAbs() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        List items = this.dictService.getItems("hc_" + dwdm);
        ArrayList<Map<String, String>> abs = new ArrayList<Map<String, String>>();
        for (Item item : items) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", item.getName());
            map.put("value", item.getValue());
            abs.add(map);
        }
        return abs;
    }

    public boolean isAdmin() {
        return SessionUtil.getCurrentUser().isAdmin();
    }

    public Boolean isA3d() {
        return this.isA3d;
    }

    public Map<String, Boolean> getSysPerms() {
        return this.sysPerms;
    }

    public String a3dframe() throws Exception {
        return "a3dframe";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public HashMap<String, Object> getA3dFieldsMap() {
        return this.a3dFieldsMap;
    }

    public String execute() throws Exception {
        if (this.hideBanner) {
            Struts2Utils.getSession().setAttribute("hideBanner", (Object)Boolean.TRUE);
        }
        if (AppConfig.getBooleanProperty((String)"archive3d.enable")) {
            this.isA3d = true;
        }
        this.sysPerms = new HashMap();
        for (Item item : this.dictService.getItems("sysPerm")) {
            if (!this.securityService.isPermitted("sys", item.getName())) continue;
            this.sysPerms.put(item.getName(), true);
        }
        return "success";
    }

    public String a3d() throws Exception {
        this.isA3d = true;
        Archive archive = null;
        this.a3dFieldsMap = new HashMap();
        if (this.modelName == null) {
            return "a3d";
        }
        if ("Archive".equals(this.modelName)) {
            archive = this.archiveService.getArchive(this.modelName, this.id);
        } else if (this.modelName.lastIndexOf("_jn") > -1) {
            Document doc = this.archiveService.getDocument(this.modelName, this.id);
            archive = this.archiveService.getDocumentArchive(doc);
        }
        if (archive != null) {
            this.a3dFieldsMap.put("archiveid", this.id);
            this.a3dFieldsMap.put("ajh", archive.getAjh());
            this.a3dFieldsMap.put("mlh", archive.getMlh());
            this.a3dFieldsMap.put("title", archive.getTm());
        }
        return "a3d";
    }

    public String exceedLoan() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        ArrayList<Object> criterions = new ArrayList<Object>();
        criterions.add(Restrictions.sqlRestriction((String)"jyrq+jyqx<?", (Object)new Date(), (Type)StandardBasicTypes.DATE));
        criterions.add(Restrictions.eq((String)"state", (Object)0));
        if (SessionUtil.getCurrentUser().isAdmin()) {
            Struts2Utils.renderJson((Object)0, (String[])new String[0]);
            return null;
        }
        if (EnvHolder.isEnable((String)"dwdm.enable")) {
            criterions.add(Restrictions.or((Criterion)Restrictions.isNull((String)"dwdm"), (Criterion)Restrictions.eq((String)"dwdm", (Object)this.getDwdm())));
        }
        criterions.add(Restrictions.or((Criterion)Restrictions.isNull((String)"userId"), (Criterion)Restrictions.eq((String)"userId", (Object)userInfo.getId())));
        int count = this.entityService.search((CriteriaCallback)new /* Unavailable Anonymous Inner Class!! */, criterions, null, 0, -1).getTotalCount();
        Struts2Utils.renderJson((Object)count, (String[])new String[0]);
        return null;
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }
}

