/*
 * Decompiled with CFR 0.152.
 */
package shade.jsonwebtoken.lang;

import java.security.Provider;
import java.security.Security;
import java.util.concurrent.atomic.AtomicBoolean;
import shade.jsonwebtoken.lang.Classes;
import shade.jsonwebtoken.lang.UnknownClassException;

public final class RuntimeEnvironment {
    private static final RuntimeEnvironment INSTANCE = new RuntimeEnvironment();
    private static final String BC_PROVIDER_CLASS_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final AtomicBoolean bcLoaded = new AtomicBoolean(false);
    public static final boolean BOUNCY_CASTLE_AVAILABLE = Classes.isAvailable("org.bouncycastle.jce.provider.BouncyCastleProvider");

    private RuntimeEnvironment() {
    }

    public static void enableBouncyCastleIfPossible() {
        if (bcLoaded.get()) {
            return;
        }
        try {
            Provider[] providers;
            Class clazz = Classes.forName(BC_PROVIDER_CLASS_NAME);
            for (Provider provider : providers = Security.getProviders()) {
                if (!clazz.isInstance(provider)) continue;
                bcLoaded.set(true);
                return;
            }
            Security.addProvider((Provider)Classes.newInstance(clazz));
            bcLoaded.set(true);
        }
        catch (UnknownClassException unknownClassException) {
            // empty catch block
        }
    }

    static {
        RuntimeEnvironment.enableBouncyCastleIfPossible();
    }
}

