/*
 * Decompiled with CFR 0.152.
 */
package shade.jsonwebtoken.impl.crypto;

import java.security.Key;
import shade.jsonwebtoken.SignatureAlgorithm;
import shade.jsonwebtoken.impl.crypto.EllipticCurveSigner;
import shade.jsonwebtoken.impl.crypto.MacSigner;
import shade.jsonwebtoken.impl.crypto.RsaSigner;
import shade.jsonwebtoken.impl.crypto.Signer;
import shade.jsonwebtoken.impl.crypto.SignerFactory;
import shade.jsonwebtoken.lang.Assert;

public class DefaultSignerFactory
implements SignerFactory {
    public static final SignerFactory INSTANCE = new DefaultSignerFactory();

    @Override
    public Signer createSigner(SignatureAlgorithm alg, Key key) {
        Assert.notNull((Object)alg, "SignatureAlgorithm cannot be null.");
        Assert.notNull(key, "Signing Key cannot be null.");
        switch (alg) {
            case HS256: 
            case HS384: 
            case HS512: {
                return new MacSigner(alg, key);
            }
            case RS256: 
            case RS384: 
            case RS512: 
            case PS256: 
            case PS384: 
            case PS512: {
                return new RsaSigner(alg, key);
            }
            case ES256: 
            case ES384: 
            case ES512: {
                return new EllipticCurveSigner(alg, key);
            }
        }
        throw new IllegalArgumentException("The '" + alg.name() + "' algorithm cannot be used for signing.");
    }
}

