/*
 * Decompiled with CFR 0.152.
 */
package shade.jsonwebtoken.impl.crypto;

import java.nio.charset.Charset;
import java.security.Key;
import shade.jsonwebtoken.SignatureAlgorithm;
import shade.jsonwebtoken.impl.TextCodec;
import shade.jsonwebtoken.impl.crypto.DefaultSignatureValidatorFactory;
import shade.jsonwebtoken.impl.crypto.JwtSignatureValidator;
import shade.jsonwebtoken.impl.crypto.SignatureValidator;
import shade.jsonwebtoken.impl.crypto.SignatureValidatorFactory;
import shade.jsonwebtoken.lang.Assert;

public class DefaultJwtSignatureValidator
implements JwtSignatureValidator {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final SignatureValidator signatureValidator;

    public DefaultJwtSignatureValidator(SignatureAlgorithm alg, Key key) {
        this(DefaultSignatureValidatorFactory.INSTANCE, alg, key);
    }

    public DefaultJwtSignatureValidator(SignatureValidatorFactory factory, SignatureAlgorithm alg, Key key) {
        Assert.notNull(factory, "SignerFactory argument cannot be null.");
        this.signatureValidator = factory.createSignatureValidator(alg, key);
    }

    @Override
    public boolean isValid(String jwtWithoutSignature, String base64UrlEncodedSignature) {
        byte[] data = jwtWithoutSignature.getBytes(US_ASCII);
        byte[] signature = TextCodec.BASE64URL.decode(base64UrlEncodedSignature);
        return this.signatureValidator.isValid(data, signature);
    }
}

