/*
 * Decompiled with CFR 0.152.
 */
package shade.jsonwebtoken.impl.compression;

import shade.jsonwebtoken.CompressionCodec;
import shade.jsonwebtoken.CompressionCodecResolver;
import shade.jsonwebtoken.CompressionException;
import shade.jsonwebtoken.Header;
import shade.jsonwebtoken.impl.compression.CompressionCodecs;
import shade.jsonwebtoken.lang.Assert;
import shade.jsonwebtoken.lang.Strings;

public class DefaultCompressionCodecResolver
implements CompressionCodecResolver {
    @Override
    public CompressionCodec resolveCompressionCodec(Header header) {
        String cmpAlg = this.getAlgorithmFromHeader(header);
        boolean hasCompressionAlgorithm = Strings.hasText(cmpAlg);
        if (!hasCompressionAlgorithm) {
            return null;
        }
        if (CompressionCodecs.DEFLATE.getAlgorithmName().equalsIgnoreCase(cmpAlg)) {
            return CompressionCodecs.DEFLATE;
        }
        if (CompressionCodecs.GZIP.getAlgorithmName().equalsIgnoreCase(cmpAlg)) {
            return CompressionCodecs.GZIP;
        }
        throw new CompressionException("Unsupported compression algorithm '" + cmpAlg + "'");
    }

    private String getAlgorithmFromHeader(Header header) {
        Assert.notNull(header, "header cannot be null.");
        return header.getCompressionAlgorithm();
    }
}

