/*
 * Decompiled with CFR 0.152.
 */
package shade.jsonwebtoken.impl.compression;

import java.io.IOException;
import shade.jsonwebtoken.CompressionCodec;
import shade.jsonwebtoken.CompressionException;
import shade.jsonwebtoken.lang.Assert;

public abstract class AbstractCompressionCodec
implements CompressionCodec {
    protected abstract byte[] doCompress(byte[] var1) throws IOException;

    @Override
    public final byte[] compress(byte[] payload) {
        Assert.notNull(payload, "payload cannot be null.");
        try {
            return this.doCompress(payload);
        }
        catch (IOException e) {
            throw new CompressionException("Unable to compress payload.", e);
        }
    }

    @Override
    public final byte[] decompress(byte[] compressed) {
        Assert.notNull(compressed, "compressed bytes cannot be null.");
        try {
            return this.doDecompress(compressed);
        }
        catch (IOException e) {
            throw new CompressionException("Unable to decompress bytes.", e);
        }
    }

    protected abstract byte[] doDecompress(byte[] var1) throws IOException;
}

