/*
 * Decompiled with CFR 0.152.
 */
package shade.jsonwebtoken.impl;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import shade.jsonwebtoken.lang.Assert;

public class JwtMap
implements Map<String, Object> {
    private final Map<String, Object> map;

    public JwtMap() {
        this(new LinkedHashMap<String, Object>());
    }

    public JwtMap(Map<String, Object> map) {
        Assert.notNull(map, "Map argument cannot be null.");
        this.map = map;
    }

    protected String getString(String name) {
        Object v = this.get(name);
        return v != null ? String.valueOf(v) : null;
    }

    protected static Date toDate(Object v, String name) {
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v instanceof Number) {
            long seconds = ((Number)v).longValue();
            long millis = seconds * 1000L;
            return new Date(millis);
        }
        if (v instanceof String) {
            long seconds = Long.parseLong((String)v);
            long millis = seconds * 1000L;
            return new Date(millis);
        }
        throw new IllegalStateException("Cannot convert '" + name + "' value [" + v + "] to Date instance.");
    }

    protected void setValue(String name, Object v) {
        if (v == null) {
            this.map.remove(name);
        } else {
            this.map.put(name, v);
        }
    }

    protected Date getDate(String name) {
        Object v = this.map.get(name);
        return JwtMap.toDate(v, name);
    }

    protected void setDate(String name, Date d) {
        if (d == null) {
            this.map.remove(name);
        } else {
            long seconds = d.getTime() / 1000L;
            this.map.put(name, seconds);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public Object get(Object o) {
        return this.map.get(o);
    }

    @Override
    public Object put(String s, Object o) {
        if (o == null) {
            return this.map.remove(s);
        }
        return this.map.put(s, o);
    }

    @Override
    public Object remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m == null) {
            return;
        }
        for (String string : m.keySet()) {
            this.map.put(string, m.get(string));
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }
}

