/*
 * Decompiled with CFR 0.152.
 */
package com.gsafety.heihe.auth.sdk;

import com.gsafety.heihe.auth.sdk.JwtConstants;
import com.gsafety.heihe.auth.sdk.TokenExpiredException;
import com.gsafety.heihe.auth.sdk.TokenParseException;
import com.gsafety.heihe.auth.sdk.TokenSignatureException;
import com.gsafety.heihe.auth.sdk.UserInfo;
import shade.jsonwebtoken.Claims;
import shade.jsonwebtoken.ExpiredJwtException;
import shade.jsonwebtoken.Jwts;
import shade.jsonwebtoken.SignatureException;

public class TokenValidator {
    public static UserInfo validate(String token) throws TokenExpiredException, TokenSignatureException {
        if (token == null) {
            return null;
        }
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(JwtConstants.JWT_SIGN_SECRET_KEY).parseClaimsJws(token).getBody();
            String username = claims.getSubject();
            String idNumber = claims.get("idNumber", String.class);
            String phone = claims.get("phone", String.class);
            return new UserInfo(username, idNumber, phone);
        }
        catch (ExpiredJwtException e) {
            throw new TokenExpiredException("token\u5df2\u8fc7\u671f");
        }
        catch (SignatureException e) {
            throw new TokenSignatureException("token\u7b7e\u540d\u9a8c\u8bc1\u9519\u8bef");
        }
        catch (Exception e) {
            throw new TokenParseException("token\u89e3\u6790\u5f02\u5e38:" + e.getMessage());
        }
    }
}

