/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.common.util;

import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SignatureAlgorithmConvert {
    private static ASN1ObjectIdentifier getASN1ObjectIdentifier(String algName) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier di = null;
        if (algName.toUpperCase().indexOf("SM2") != -1) {
            if (algName.toUpperCase().indexOf("SHA1") != -1) {
                di = new ASN1ObjectIdentifier("1.2.156.10197.1.502");
            } else if (algName.toUpperCase().indexOf("SHA256") != -1) {
                di = new ASN1ObjectIdentifier("1.2.156.10197.1.503");
            } else if (algName.toUpperCase().indexOf("SM3") != -1) {
                di = new ASN1ObjectIdentifier("1.2.156.10197.1.501");
            }
        }
        if (algName.toUpperCase().indexOf("RSA") != -1) {
            if (algName.toUpperCase().indexOf("SHA1") != -1) {
                di = PKCSObjectIdentifiers.sha1WithRSAEncryption;
            } else if (algName.toUpperCase().indexOf("MD2") != -1) {
                di = PKCSObjectIdentifiers.md2WithRSAEncryption;
            } else if (algName.toUpperCase().indexOf("MD4") != -1) {
                di = PKCSObjectIdentifiers.md4WithRSAEncryption;
            } else if (algName.toUpperCase().indexOf("MD5") != -1) {
                di = PKCSObjectIdentifiers.md5WithRSAEncryption;
            } else if (algName.toUpperCase().indexOf("SHA224") != -1) {
                di = PKCSObjectIdentifiers.sha224WithRSAEncryption;
            } else if (algName.toUpperCase().indexOf("SHA256") != -1) {
                di = PKCSObjectIdentifiers.sha256WithRSAEncryption;
            } else if (algName.toUpperCase().indexOf("SHA384") != -1) {
                di = PKCSObjectIdentifiers.sha384WithRSAEncryption;
            } else if (algName.toUpperCase().indexOf("SHA512") != -1) {
                di = PKCSObjectIdentifiers.sha512WithRSAEncryption;
            } else if (algName.toUpperCase().indexOf("SM3") != -1) {
                di = new ASN1ObjectIdentifier("1.2.156.10197.1.504");
            }
        }
        if (di == null) {
            throw new NoSuchAlgorithmException(algName);
        }
        return di;
    }

    public static AlgorithmIdentifier getSignAlgorithmIdentifier(String algName) throws NoSuchAlgorithmException {
        AlgorithmIdentifier alg = new AlgorithmIdentifier(SignatureAlgorithmConvert.getASN1ObjectIdentifier(algName), (ASN1Encodable)DERNull.INSTANCE);
        return alg;
    }

    public static AlgorithmIdentifier getAlgorithmIdentifier(String alg) throws NoSuchAlgorithmException {
        if ("SHA1".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("SHA256".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("MD2".equals(alg)) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("MD5".equals(alg)) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("SM3".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.401"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("RSA".equals(alg)) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("SM2".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.10045.2.1"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("DESede_CBC".equals(alg)) {
            return new AlgorithmIdentifier(PKCSObjectIdentifiers.des_EDE3_CBC, (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("DES_CBC".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.7"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("DES_ECB".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.6"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("AES128_CBC".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.2"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("AES192_CBC".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.22"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("AES256_CBC".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.42"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("SM1".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.102"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("SM4".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.104"), (ASN1Encodable)DERNull.INSTANCE);
        }
        if ("SSF33".equals(alg)) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.103"), (ASN1Encodable)DERNull.INSTANCE);
        }
        throw new NoSuchAlgorithmException(alg);
    }

    public static String getAlgByIdentify(AlgorithmIdentifier algId) throws NoSuchAlgorithmException {
        if ("1.3.14.3.2.26".equals(algId.getAlgorithm().getId())) {
            return "SHA1";
        }
        if ("2.16.840.1.101.3.4.2.1".equals(algId.getAlgorithm().getId())) {
            return "SHA256";
        }
        if (PKCSObjectIdentifiers.md5.getId().equals(algId.getAlgorithm().getId())) {
            return "MD5";
        }
        if (PKCSObjectIdentifiers.md2.getId().equals(algId.getAlgorithm().getId())) {
            return "MD2";
        }
        if (PKCSObjectIdentifiers.md4.getId().equals(algId.getAlgorithm().getId())) {
            return "MD4";
        }
        if ("1.2.156.10197.1.401".equals(algId.getAlgorithm().getId()) || "1.2.156.10197.1.401.1".equals(algId.getAlgorithm().getId()) || "1.2.156.10197.1.401.2".equals(algId.getAlgorithm().getId())) {
            return "SM3";
        }
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equals(algId.getAlgorithm().getId()) || "1.3.14.3.2.29".equals(algId.getAlgorithm().getId())) {
            return "SHA1withRSA";
        }
        if (PKCSObjectIdentifiers.sha224WithRSAEncryption.getId().equals(algId.getAlgorithm().getId())) {
            return "SHA224withRSA";
        }
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equals(algId.getAlgorithm().getId())) {
            return "SHA256withRSA";
        }
        if (PKCSObjectIdentifiers.sha384WithRSAEncryption.getId().equals(algId.getAlgorithm().getId())) {
            return "SHA384withRSA";
        }
        if (PKCSObjectIdentifiers.sha512WithRSAEncryption.getId().equals(algId.getAlgorithm().getId())) {
            return "SHA512withRSA";
        }
        if (PKCSObjectIdentifiers.md2WithRSAEncryption.getId().equals(algId.getAlgorithm().getId())) {
            return "MD2withRSA";
        }
        if (PKCSObjectIdentifiers.md4WithRSAEncryption.getId().equals(algId.getAlgorithm().getId())) {
            return "MD4withRSA";
        }
        if (PKCSObjectIdentifiers.md5WithRSAEncryption.getId().equals(algId.getAlgorithm().getId())) {
            return "MD5withRSA";
        }
        if ("1.2.156.10197.1.502".equals(algId.getAlgorithm().getId())) {
            return "SHA1withSM2";
        }
        if ("1.2.156.10197.1.503".equals(algId.getAlgorithm().getId())) {
            return "SHA256withSM2";
        }
        if ("1.2.156.10197.1.501".equals(algId.getAlgorithm().getId())) {
            return "SM3withSM2";
        }
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(algId.getAlgorithm().getId())) {
            return "RSA";
        }
        if ("1.2.840.10045.2.1".equals(algId.getAlgorithm().getId()) || "1.2.156.10197.1.301".equals(algId.getAlgorithm().getId()) || "1.2.156.10197.1.301.1".equals(algId.getAlgorithm().getId()) || "1.2.156.10197.1.301.2".equals(algId.getAlgorithm().getId()) || "1.2.156.10197.1.301.3".equals(algId.getAlgorithm().getId())) {
            return "SM2";
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.getId().equals(algId.getAlgorithm().getId())) {
            return "DESede_CBC";
        }
        if ("1.3.14.3.2.6".equals(algId.getAlgorithm().getId())) {
            return "DES_ECB";
        }
        if ("1.3.14.3.2.7".equals(algId.getAlgorithm().getId())) {
            return "DES_CBC";
        }
        if ("2.16.840.1.101.3.4.1.2".equals(algId.getAlgorithm().getId())) {
            return "AES128_CBC";
        }
        if ("2.16.840.1.101.3.4.1.22".equals(algId.getAlgorithm().getId())) {
            return "AES192_CBC";
        }
        if ("2.16.840.1.101.3.4.1.42".equals(algId.getAlgorithm().getId())) {
            return "AES256_CBC";
        }
        if ("1.2.156.10197.1.102".equals(algId.getAlgorithm().getId())) {
            return "SM1";
        }
        if ("1.2.156.10197.1.104".equals(algId.getAlgorithm().getId())) {
            return "SM4";
        }
        if ("1.2.156.10197.1.103".equals(algId.getAlgorithm().getId())) {
            return "SSF33";
        }
        throw new NoSuchAlgorithmException(algId.getAlgorithm().getId());
    }
}

