/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Base64;
import com.custle.security.algorithm.imple.soft.sm2.SM2PublicKeyDer;
import com.custle.security.algorithm.imple.soft.sm2.VerifySignatureDer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class TestSm2Case {
    public static byte[] InputStreamToByte(InputStream iStrm) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = iStrm.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] imgdata = bytestream.toByteArray();
        bytestream.close();
        return imgdata;
    }

    public static byte[] getPublicKeyFromCert(InputStream incert) throws Exception {
        byte[] in = TestSm2Case.InputStreamToByte(incert);
        byte[] Sm2cert1 = new byte[in.length];
        Sm2cert1 = in[0] == 48 && in[1] == -126 ? in : Base64.decode(in);
        ASN1InputStream aIn = new ASN1InputStream(Sm2cert1);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        Certificate cert = Certificate.getInstance((Object)seq);
        SubjectPublicKeyInfo pukinfo = cert.getSubjectPublicKeyInfo();
        byte[] byPuk = pukinfo.getPublicKeyData().getBytes();
        byte[] PublicKey_xy = new byte[64];
        int i = 0;
        while (i < byPuk.length - 1) {
            PublicKey_xy[i] = byPuk[i + 1];
            ++i;
        }
        aIn.close();
        return PublicKey_xy;
    }

    public static void main(String[] args) throws Exception {
        String pubKey = "BLcdPst2RkDaQHgGh/pGM2C2B23iPnqfNA7RY6vYOM7aIVzXJJ69UdZnIehkjCe2CwJKLZbL7WUEWz/15zXbOLk=";
        VerifySignatureDer verifysign = new VerifySignatureDer();
        String certBase64 = "MIICZTCCAgygAwIBAgIDBpGkMAoGCCqBHM9VAYN1MCQxCzAJBgNVBAYTAkNOMRUwEwYDVQQDDAxDTUNBIFJvb3QgQ0EwHhcNMTMwNTIwMDI0NTQ4WhcNMTMwODIwMDI0NTQ4WjBuMQswCQYDVQQGEwJDTjEPMA0GA1UECAwG5rmW5Y2XMQ8wDQYDVQQHDAbplb/mspkxJTAjBgkqhkiG9w0BCQEWFkNNQ0F0ZXN0dXNlcjFAdGVzdC5jb20xFjAUBgNVBAMMDUNNQ0F0ZXN0dXNlcjIwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAS3HT7LdkZA2kB4Bof6RjNgtgdt4j56nzQO0WOr2DjO2iFc1ySevVHWZyHoZIwntgsCSi2Wy+1lBFs/9ec12zi5o4HiMIHfMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDBDAfBgNVHSMEGDAWgBS0iWzrrP4fq7EOGpsVEVQYF9c8uzBmBgNVHR8EXzBdMFugL6AthitodHRwOi8vd3d3LmNtY2EubmV0L2Rvd25sb2FkL2NybC9DUkwxNjkuY3JsoiikJjAkMRUwEwYDVQQDDAxDTUNBIFJvb3QgQ0ExCzAJBgNVBAYTAkNOMAsGA1UdDwQEAwIGwDAdBgNVHQ4EFgQUXjyeneZHUXudijxy8yksKNmJXOMwCQYDVR0TBAIwADAKBggqgRzPVQGDdQNHADBEAiAVk9lSO2xzGnC7m2Ap4Tq2Z05O8W/pKNVuxjdhReytUwIgB+5/w0jxh4awGsCRhlhZoeolUWYUq1uydytXVLxrAfQ=";
        String str1 = "asdf11234!@#$% ^&***((";
        String str1Base64 = "MEQCIFoZ5+ArFszAtsQfNC0ONmsjrycwoe0XZU8s2VLcWBY+AiA9EhPy7Vd0VFV+T+IlKrnqFfgfxSh0NlxeSXPkfXga2A==";
        String str2 = "\u521b\u539f\u5929\u5730\u79d1\u6280\u6709\u9650\u516c\u53f8adsfadsf13241324\uff01@#\uffe5%\u2026\u2026\u2026\u2026&**\uff08\uff08\uff09adfadsfadsfkjmv;zx,vkwercknkajla";
        String str2Base64 = "MEQCIDnnTfVSezhjA4wL2tJf6Q7rmkxcyCFkibOR+NekZL4vAiBW7Ef/pYLraY2upO44wMoIbDt/o9eFwQSaxLf/dSZTDg==";
        String str3 = "\u521b\u539f\u5929\u5730\u79d1\u6280\u6709\u9650\u516c\u53f8adsfadsf13241324\uff01@#\uffe5%\u2026\u2026\u2026\u2026&**\uff08\uff08\uff09\uff08\u521b\u539f\u5929\u5730\u79d1\u6280\u6709\u9650\u516c\u53f8adsfadsf13241324\uff01@#\uffe5%\u2026\u2026\u2026\u2026&**\uff08\uff08\uff09\uff08\u521b\u539f\u5929\u5730\u79d1\u6280\u6709\u9650\u516c\u53f8adsfadsf13241324\uff01@#\uffe5%\u2026\u2026\u2026\u2026&**\uff08\uff08\uff09\uff08\u521b\u539f\u5929\u5730\u79d1\u6280\u6709\u9650\u516c\u53f8adsfadsf13241324\uff01@#\uffe5%\u2026\u2026\u2026\u2026&**\uff08\uff08\uff09\uff08";
        String str3Base64 = "MEUCIQDhKUd/a3ydGq7R59W7NXB7GEyLsR7czG5WLLLbYjPFGwIgRh8Zr2Kxy+GX6hAnX2y0Qbsq0NAGpqoRwrnMPGFNqR4=";
        int verifysignaturestr1 = verifysign.verifySm2SignatureByPubKeyDer(Base64.decode(pubKey), Base64.decode(str1Base64), str1.getBytes());
        int verifysignaturestr2 = verifysign.verifySm2SignatureByPubKeyDer(Base64.decode(pubKey), Base64.decode(str2Base64), str2.getBytes());
        int verifysignaturestr3 = verifysign.verifySm2SignatureByPubKeyDer(Base64.decode(pubKey), Base64.decode(str3Base64), str3.getBytes());
        System.out.println("\u516c\u94a5\u9a8c\u7b7estr1\uff1a" + verifysignaturestr1);
        System.out.println("\u516c\u94a5\u9a8c\u7b7estr2\uff1a" + verifysignaturestr2);
        System.out.println("\u516c\u94a5\u9a8c\u7b7estr3\uff1a" + verifysignaturestr3);
        int verifysignaturestr11 = verifysign.verifySm2SignatureByCertDer(Base64.decode(certBase64), Base64.decode(str1Base64), str1.getBytes());
        int verifysignaturestr22 = verifysign.verifySm2SignatureByCertDer(Base64.decode(certBase64), Base64.decode(str2Base64), str2.getBytes());
        int verifysignaturestr33 = verifysign.verifySm2SignatureByCertDer(Base64.decode(certBase64), Base64.decode(str3Base64), str3.getBytes());
        System.out.println("\u8bc1\u4e66\u9a8c\u7b7estr1\uff1a" + verifysignaturestr11);
        System.out.println("\u8bc1\u4e66\u9a8c\u7b7estr2\uff1a" + verifysignaturestr22);
        System.out.println("\u8bc1\u4e66\u9a8c\u7b7estr3\uff1a" + verifysignaturestr33);
        byte[] publicKey = Base64.decode(pubKey);
        byte[] publicKeyxy = new byte[64];
        int i = 0;
        while (i < publicKey.length - 1) {
            publicKeyxy[i] = publicKey[i + 1];
            ++i;
        }
        SM2PublicKeyDer.testWrite(SM2PublicKeyDer.sm2PubKeyDerEncode(publicKeyxy));
        byte[] sm2PublicKeyDer = SM2PublicKeyDer.sm2PubKeyDerEncode(publicKeyxy);
        System.out.println(sm2PublicKeyDer.length);
        int verifysignaturestr55 = verifysign.verifySm2SignatureByPubKeyDer(sm2PublicKeyDer, Base64.decode(str3Base64), str3.getBytes());
        System.out.println("\u8bc1\u4e66\u9a8c\u7b7estr5\uff1a" + verifysignaturestr55);
        Long pre = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 100) {
            String str = "asdf11234!@#$% ^&***((";
            String strBase64 = "MEQCIFoZ5+ArFszAtsQfNC0ONmsjrycwoe0XZU8s2VLcWBY+AiA9EhPy7Vd0VFV+T+IlKrnqFfgfxSh0NlxeSXPkfXga2A==";
            int n = verifysign.verifySm2SignatureByPubKeyDer(Base64.decode(pubKey), Base64.decode(strBase64), str.getBytes());
            ++i2;
        }
        Long post = System.currentTimeMillis();
        System.out.println("\u516c\u94a5\u9a8c\u7b7e\u5faa\u73af100\u6b21\u65f6\u95f4\uff1a" + (post - pre) + "ms");
        Long pre1 = System.currentTimeMillis();
        int i3 = 0;
        while (i3 < 100) {
            String str = "asdf11234!@#$% ^&***((";
            String strBase64 = "MEQCIFoZ5+ArFszAtsQfNC0ONmsjrycwoe0XZU8s2VLcWBY+AiA9EhPy7Vd0VFV+T+IlKrnqFfgfxSh0NlxeSXPkfXga2A==";
            int n = verifysign.verifySm2SignatureByCertDer(Base64.decode(certBase64), Base64.decode(strBase64), str.getBytes());
            ++i3;
        }
        Long post1 = System.currentTimeMillis();
        System.out.println("\u8bc1\u4e66\u9a8c\u7b7e\u5faa\u73af100\u6b21\u65f6\u95f4\uff1a" + (post1 - pre1) + "ms");
    }
}

