/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import com.custle.security.algorithm.imple.soft.sm2.Constants;
import com.custle.security.algorithm.imple.soft.sm2.EccPoint;
import com.custle.security.algorithm.imple.soft.sm2.ErrCode;
import com.custle.security.algorithm.imple.soft.sm2.SM3Hash;
import com.custle.security.algorithm.imple.soft.sm2.Util;
import java.math.BigInteger;
import java.util.Random;

public class Signature {
    boolean IsReGenerateRand = false;

    private BigInteger[] sign(BigInteger e, BigInteger rank_k, BigInteger Pri_Da, BigInteger Xg, BigInteger Yg, BigInteger a, BigInteger p, BigInteger n) {
        BigInteger tmp2;
        if (e.equals(null) || rank_k.equals(null) || Pri_Da.equals(null) || Xg.equals(null) || Yg.equals(null) || a.equals(null) || p.equals(null) || n.equals(null)) {
            ErrCode.mSignatureLastError = ErrCode.SIG_BIG_PARAM_ERR;
            return null;
        }
        BigInteger[] resultRS = new BigInteger[2];
        BigInteger[] resultXY = new BigInteger[2];
        resultXY = EccPoint.eccPointMul(Xg, Yg, rank_k, a, p);
        BigInteger big_x1 = resultXY[0];
        BigInteger big_y1 = resultXY[1];
        resultRS[0] = e.add(big_x1).mod(n);
        BigInteger tmp1 = resultRS[0].add(rank_k).mod(n);
        if (resultRS[0].equals(BigInteger.ZERO) || tmp1.equals(BigInteger.ZERO)) {
            this.IsReGenerateRand = true;
            return null;
        }
        tmp1 = Pri_Da.add(BigInteger.ONE);
        BigInteger s_left = tmp2 = tmp1.modInverse(n);
        tmp1 = resultRS[0].multiply(Pri_Da);
        tmp2 = rank_k.add(tmp1.negate()).mod(n);
        resultRS[1] = s_left.multiply(tmp2).mod(n);
        if (resultRS[1].equals(BigInteger.ZERO)) {
            this.IsReGenerateRand = true;
            return null;
        }
        return resultRS;
    }

    public byte[] sm2Sign(byte[] src, byte[] UserID, byte[] priKey, byte[] bytRandNumber) {
        BigInteger[] signRS;
        String strYa;
        int lenYa;
        if (src == null || UserID == null || priKey == null || priKey.length != 32) {
            ErrCode.mSignatureLastError = ErrCode.SIG_PARAM_ERR;
            return null;
        }
        BigInteger big_rand_k = BigInteger.ONE;
        BigInteger big_a = new BigInteger(Constants.SM2_A, 16);
        BigInteger big_b = new BigInteger(Constants.SM2_B, 16);
        BigInteger big_n = new BigInteger(Constants.SM2_N, 16);
        BigInteger big_p = new BigInteger(Constants.SM2_P, 16);
        BigInteger big_Xg = new BigInteger(Constants.SM2_G_X, 16);
        BigInteger big_Yg = new BigInteger(Constants.SM2_G_Y, 16);
        BigInteger big_pri_Da = new BigInteger(Util.byteArrayToString(priKey, 0), 16);
        BigInteger[] pubKeyXY = EccPoint.eccPointMul(big_Xg, big_Yg, big_pri_Da, big_a, big_p);
        BigInteger big_Xa = pubKeyXY[0];
        BigInteger big_Ya = pubKeyXY[1];
        byte[] byt_e = null;
        String strXa = big_Xa.toString(16);
        int lenXa = strXa.length();
        if (lenXa < 64) {
            int i = 0;
            while (i < 64 - lenXa) {
                strXa = "0" + strXa;
                ++i;
            }
        }
        if ((lenYa = (strYa = big_Ya.toString(16)).length()) < 64) {
            int i = 0;
            while (i < 64 - lenYa) {
                strYa = "0" + strYa;
                ++i;
            }
        }
        if ((byt_e = this.getE(UserID, Constants.SM2_A, Constants.SM2_B, Constants.SM2_G_X, Constants.SM2_G_Y, Util.stringToByteArray(strXa), Util.stringToByteArray(strYa), src)) == null) {
            return null;
        }
        BigInteger big_e = new BigInteger(Util.byteArrayToString(byt_e, 0), 16);
        do {
            if (bytRandNumber == null) {
                int[] iRandom = new int[8];
                int i = 0;
                while (i < 8) {
                    Random random = new Random();
                    iRandom[i] = random.nextInt();
                    ++i;
                }
                byte[] bytGenRand = new byte[32];
                int i2 = 0;
                while (i2 < 8) {
                    System.arraycopy(Util.int2ByteArray(iRandom[i2], 4), 0, bytGenRand, i2 * 4, 4);
                    ++i2;
                }
                big_rand_k = new BigInteger(Util.byteArrayToString(bytGenRand, 0), 16);
                big_rand_k = big_rand_k.add(big_n.negate()).mod(big_n);
            } else {
                big_rand_k = new BigInteger(Util.byteArrayToString(bytRandNumber, 0), 16);
                big_rand_k = big_rand_k.add(big_n.negate()).mod(big_n);
            }
            signRS = this.sign(big_e, big_rand_k, big_pri_Da, big_Xg, big_Yg, big_a, big_p, big_n);
            if (signRS != null || this.IsReGenerateRand) continue;
            return null;
        } while (signRS == null && this.IsReGenerateRand);
        byte[] signature = new byte[64];
        String strR = signRS[0].toString(16);
        int lenR = strR.length();
        if (lenR < 64) {
            int i = 0;
            while (i < 64 - lenR) {
                strR = "0" + strR;
                ++i;
            }
        }
        System.arraycopy(Util.stringToByteArray(strR), 0, signature, 0, 32);
        String strS = signRS[1].toString(16);
        int lenS = strS.length();
        if (lenS < 64) {
            int i = 0;
            while (i < 64 - lenS) {
                strS = "0" + strS;
                ++i;
            }
        }
        System.arraycopy(Util.stringToByteArray(strS), 0, signature, 32, 32);
        return signature;
    }

    public int verifySm2SignatureByPubKey(byte[] PublicKeySm2, byte[] signature, byte[] src) {
        if (PublicKeySm2 == null || PublicKeySm2.length != 64 || signature == null || signature.length != 64 || src == null) {
            ErrCode.mSignatureLastError = ErrCode.SIG_PARAM_ERR;
            return ErrCode.SIG_PARAM_ERR;
        }
        byte[] pubKey_X = new byte[32];
        byte[] pubKey_Y = new byte[32];
        System.arraycopy(PublicKeySm2, 0, pubKey_X, 0, 32);
        System.arraycopy(PublicKeySm2, 32, pubKey_Y, 0, 32);
        BigInteger Xa = new BigInteger(Util.byteArrayToString(pubKey_X, 0), 16);
        BigInteger Ya = new BigInteger(Util.byteArrayToString(pubKey_Y, 0), 16);
        byte[] signature_r = new byte[32];
        byte[] signature_s = new byte[32];
        System.arraycopy(signature, 0, signature_r, 0, 32);
        System.arraycopy(signature, 32, signature_s, 0, 32);
        BigInteger r = new BigInteger(Util.byteArrayToString(signature_r, 0), 16);
        BigInteger s = new BigInteger(Util.byteArrayToString(signature_s, 0), 16);
        BigInteger Xg = new BigInteger(Constants.SM2_G_X, 16);
        BigInteger Yg = new BigInteger(Constants.SM2_G_Y, 16);
        BigInteger a = new BigInteger(Constants.SM2_A, 16);
        BigInteger b = new BigInteger(Constants.SM2_B, 16);
        BigInteger p = new BigInteger(Constants.SM2_P, 16);
        BigInteger n = new BigInteger(Constants.SM2_N, 16);
        byte[] bytE = null;
        bytE = this.getE(Constants.UserID.getBytes(), Constants.SM2_A, Constants.SM2_B, Constants.SM2_G_X, Constants.SM2_G_Y, pubKey_X, pubKey_Y, src);
        if (bytE == null) {
            return ErrCode.GetSignatureLastError();
        }
        BigInteger E = new BigInteger(Util.byteArrayToString(bytE, 0), 16);
        int iVerResult = -1;
        iVerResult = this.verify(r, s, E, Xa, Ya, Xg, Yg, a, p, n);
        return iVerResult;
    }

    public byte[] getE(byte[] UserID, String a, String b, String Xg, String Yg, byte[] Xa, byte[] Ya, byte[] M) {
        if (UserID == null || a == null || "".equals(a) || b == null || "".equals(b) || Xg == null || "".equals(Xg) || Yg == null || "".equals(Yg) || Xa == null || Ya == null || M == null) {
            ErrCode.mSignatureLastError = ErrCode.SIG_GET_E_PARAM_ERR;
            return null;
        }
        byte[] ENTLa = Util.int2ByteArray(UserID.length * 8, 2);
        String str_ENTLa = Util.byteArrayToString(ENTLa, 0);
        String str_IDa = Util.byteArrayToString(UserID, 0);
        String str_Xa = Util.byteArrayToString(Xa, 0);
        String str_Ya = Util.byteArrayToString(Ya, 0);
        String str_M = Util.byteArrayToString(M, 0);
        String strZa = String.valueOf(str_ENTLa) + str_IDa + a + b + Xg + Yg + str_Xa + str_Ya;
        byte[] bytZa = SM3Hash.getHashValue(Util.stringToByteArray(strZa));
        if (bytZa == null) {
            ErrCode.mSignatureLastError = ErrCode.SIG_GET_E_HASH_ZA_ERR;
            return null;
        }
        String str_Za = Util.byteArrayToString(bytZa, 0);
        String str_ZaAndM = String.valueOf(str_Za) + str_M;
        byte[] byt_E = SM3Hash.getHashValue(Util.stringToByteArray(str_ZaAndM));
        if (byt_E == null) {
            ErrCode.mSignatureLastError = ErrCode.SIG_GET_E_HASH_E_ERR;
            return null;
        }
        return byt_E;
    }

    private String getZa(byte[] UserID, String a, String b, String Xg, String Yg, byte[] Xa, byte[] Ya) {
        byte[] ENTLa = Util.int2ByteArray(UserID.length * 8, 2);
        String str_ENTLa = Util.byteArrayToString(ENTLa, 0);
        String str_IDa = Util.byteArrayToString(UserID, 0);
        String str_Xa = Util.byteArrayToString(Xa, 0);
        String str_Ya = Util.byteArrayToString(Ya, 0);
        String str_srcZa = String.valueOf(str_ENTLa) + str_IDa + a + b + Xg + Yg + str_Xa + str_Ya;
        byte[] byt_srcZa = Util.stringToByteArray(str_srcZa);
        byte[] bytZa = SM3Hash.getHashValue(byt_srcZa);
        if (bytZa == null) {
            ErrCode.mSignatureLastError = ErrCode.SIG_GET_E_HASH_ZA_ERR;
            return null;
        }
        String strZa = Util.byteArrayToString(bytZa, 0);
        return strZa;
    }

    private int verify(BigInteger r, BigInteger s, BigInteger e, BigInteger Xa, BigInteger Ya, BigInteger Xg, BigInteger Yg, BigInteger a, BigInteger p, BigInteger n) {
        if (r.equals(null) || s.equals(null) || e.equals(null) || Xa.equals(null) || Ya.equals(null) || Xg.equals(null) || Yg.equals(null) || a.equals(null) || p.equals(null) || n.equals(null)) {
            ErrCode.mSignatureLastError = ErrCode.SIG_BIG_PARAM_ERR;
            return ErrCode.SIG_BIG_PARAM_ERR;
        }
        if (r.compareTo(BigInteger.ONE) < 0 || r.compareTo(n.add(BigInteger.ONE.negate())) > 0) {
            ErrCode.mSignatureLastError = ErrCode.SIG_R_OUTBOUND_ERR;
            return ErrCode.SIG_R_OUTBOUND_ERR;
        }
        if (s.compareTo(BigInteger.ONE) < 0 || s.compareTo(n.add(BigInteger.ONE.negate())) > 0) {
            ErrCode.mSignatureLastError = ErrCode.SIG_S_OUTBOUND_ERR;
            return ErrCode.SIG_S_OUTBOUND_ERR;
        }
        BigInteger t = r.add(s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            ErrCode.mSignatureLastError = ErrCode.SIG_T_ZERO_ERR;
            return ErrCode.SIG_T_ZERO_ERR;
        }
        BigInteger[] XY = new BigInteger[2];
        BigInteger[] XY1 = new BigInteger[2];
        BigInteger[] XY2 = new BigInteger[2];
        XY1 = EccPoint.eccPointMul(Xg, Yg, s, a, p);
        XY = EccPoint.eccPointAdd(XY1[0], XY1[1], (XY2 = EccPoint.eccPointMul(Xa, Ya, t, a, p))[0], XY2[1], a, p);
        BigInteger R = e.add(XY[0]).mod(n);
        if (!R.equals(r)) {
            ErrCode.mSignatureLastError = ErrCode.SIG_R_r_DIFFERENT_ERR;
            return ErrCode.SIG_R_r_DIFFERENT_ERR;
        }
        return ErrCode.SUCCESS;
    }
}

