/*
 * Decompiled with CFR 0.152.
 */
package com.custle.security.algorithm.imple.soft.sm2;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class SM2Signature
extends ASN1Object {
    private ASN1Integer r;
    private ASN1Integer s;

    private SM2Signature(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.r = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
        this.s = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
    }

    public static SM2Signature getInstance(Object o) {
        if (o instanceof SM2Signature) {
            return (SM2Signature)((Object)o);
        }
        if (o != null) {
            return new SM2Signature(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public ASN1Integer getR() {
        return this.r;
    }

    public void setR(ASN1Integer r) {
        this.r = r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public void setS(ASN1Integer s) {
        this.s = s;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.r);
        v.add((ASN1Encodable)this.s);
        return new DERSequence(v);
    }
}

